
/****************************************************************************/
/*                                                                          */
/*      NNstat -- Internet Statistics Collection Package                    */
/*      April 1991                                                          */
/*                                                                          */
/*            Written by: Bob Braden & Annette DeSchon                      */
/*            USC Information Sciences Institute                            */
/*            Marina del Rey, California                                    */
/*                                                                          */
/*      Copyright (c) 1991 University of Southern California.               */
/*      All rights reserved.                                                */
/*                                                                          */
/*      Redistribution and use in source and binary forms are permitted     */
/*      provided that the above copyright notice and this paragraph are     */
/*      duplicated in all such forms and that any documentation,            */
/*      advertising materials, and other materials related to such          */
/*      distribution and use acknowledge that the software was              */
/*      developed by the University of Southern California, Information     */
/*      Sciences Institute.  The name of the University may not be used     */
/*      to endorse or promote products derived from this software           */
/*      without specific prior written permission.                          */
/*      THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR        */
/*      IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED      */
/*      WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR          */
/*      PURPOSE.                                                            */
/*                                                                          */
/****************************************************************************/

 
 
/*                  scan.h
 * 
 *   This file contains the syntax definitions required for lex and for
 *   the routines that call lex in scan.c and cmds.c.
 *
 */

/*
 * CHANGES:
 *   13Oct89 Katz: Access control tokens added
 *   17Oct89 AKS/RTB: Subnet token added
 *      Rel 3.0:
 *   ISI: add language-extension reserved words
 *   SGI: Add INCLUDE command, to include src text.
 */
 
/*  
 *      lex scan tokens
 */
#define EOFTOKEN        0
#define NUMBER          1
#define IPADDR          2
#define ETHERA          3
#define STRING          4
#define IDTOKEN         5
#define LABEL           6
#define CLASS           7
#define RECORD          10
#define IF              11
#define ELSE            12
#define INIS            13
#define ISNOT           14
#define SYMIF           15
#define SELECT          16
#define CASE            17
#define DEFAULT         18
#define ATTACH          20
#define DETACH          21
#define READ            22
#define CLEAR           23
#define READCL          24
#define SHOW            25
#define HELP            26
#define ENUM            27
#define RESTRICT        28
#define READONLY        29
#define READWRITE       30
#define SUBNET          31
#define AND             32
#define OR              33
#define INCLUDE         34
                
union xlong {
        char xlbytes[MAX_DLENG];
        u_long xllong;
} ;

extern union values {
        int int_val;
        char *ptr_val;
        } yyval;

extern int enumlist;
extern char yytext[];
extern int yyleng;

#define LEXCALL lexcall()
extern char *RsvdWds[];
extern int   RsvdToken[];
extern char *class_name[], *class_nick[];
extern FILE *yyin;
