#       serial - serialize updates & support routines
#
#	$RCSfile: serial.pl,v $
#	$Revision: 2.1 $
#	$Author: ripe-dbm $
#	$Date: 1996/09/25 23:15:26 $

require "defines.pl";

# open a serial file
  
sub openandreadserial {
    local($extension,$logtext)=@_;
   
    local($filename)=$LOGFILE{"SERIALDIR"};
    $filename=$LOCKDIR if ($filename=~ /^\s*$/);
    $filename.=$extension;
   
    # print STDERR "ext: $extension log: $logtext\n";
   
    if (!open(SERIAL,"+<".$filename)) {
      
      if (-f $filename) {
         &fatalerror($logtext." - cannot open serial file in: ".$filename);
      }
      else {
         
         # don't do a destructive open since we are not locked yet
         
         open(SERIAL,">>".$filename) || &fatalerror($logtext." - cannot create new serial file: ".$filename);
         
         &lock(SERIAL);
         
         # another process might have build it between the open & lock...
         # so test if the file has still zero length!
         #
         # we could have done this with other flock options
         # but we don't want to use them for compatibility reasons
         
         local($oldestextensionregular)=&MakeRegular($OLDESTEXTENSION);
         
         if ($extension=~ s/$oldestextensionregular$//) {
            
            close(SERIAL);
            
            # print STDERR "oldest source: $extension\n";
            
            local($currentserial)=&getcurrentserial($extension)+1;
            
            local($serialfile, $serial)=&openandreadserial($extension.$OLDESTEXTENSION, "openandreadserial current");
            print $serialfile $currentserial if (-z $filename);
            close($serialfile);
            
         }
         else {                                   
            print SERIAL 0 if (-z $filename);
            close(SERIAL);
            
            #
            # and make the oldest also
            
            local($currentextensionregular)=&MakeRegular($CURRENTEXTENSION);
            $extension=~ s/$currentextensionregular$//;
            # print STDERR "current source: $extension\n";
            local($serialfile, $serial)=&openandreadserial($extension.$OLDESTEXTENSION, "openandreadserial oldest");
            close($serialfile);
         
         }
         
         open(SERIAL,"+<".$filename) || &fatalerror($logtext." - cannot open serial file after creation: ".$filename);
      
      }
   
   }
   
   &lock(SERIAL) || &fatalerror($logtext." - cannot lock serial file($!): ".$filename);
   
   return (SERIAL, <SERIAL>=~ /^\s*(\d+)\s*$/);
   
}


sub getcurrentserial {
   local($source)=@_;

   local($serialfile, $serial)=&openandreadserial($source.$CURRENTEXTENSION, "getcurrentserial");
   
   print STDERR "CurrentSerial: *$serial*\n" if $opt_V;
   
   close($serialfile) || &fatalerror("getcurrentserial - cannot close/unlock serial file");
    
   return $serial;
}

sub getoldestserial {
   local($source)=@_;

   local($serialfile, $serial)=&openandreadserial($source.$OLDESTEXTENSION, "getoldestserial");
   
   print STDERR "OldestSerial: *$serial*\n" if $opt_V;
   
   close($serialfile) || &fatalerror("getoldestserial - cannot close/unlock serial file");
   
   return $serial;

}


sub writeseriallog {
   local($transaction, *en)=@_;
   
   # print STDERR %en, "\n";
   
   local($serialfile, $serial)=&openandreadserial($en{"so"}.$CURRENTEXTENSION, "writeseriallog");
   
   # and update it ...
   
   seek($serialfile,0,0);
   $serial++;
   print $serialfile $serial;
   
   # only write the entry when the serial dir is specified
   
   # note: we don't want to propagate the limericks for now...
   
   if ($LOGFILE{"SERIALDIR"}!~ /^\s*$/) {
      
      open(SERIALDATA,">".$LOGFILE{"SERIALDIR"}.$en{"so"}.".".$serial) || &fatalerror("writeseriallog - cannot open serial data file: ".$LOGFILE{"SERIALDIR"}.$en{"so"}.".".$serial);
      
      &lock(SERIALDATA) || &fatalerror("writeseriallog - cannot lock serial data file: ".$LOGFILE{"SERIALDIR"}.$en{"so"}.".".$serial);
   
      close($serialfile) || &fatalerror("writeseriallog - cannot close/unlock serial file: ".$LOGFILE{"SERIALDIR"}.$en{"so"}.$CURRENTEXTENSION);
   
      #
      # write the entry
      
      print SERIALDATA $transaction."\n";

      &enwrite(SERIALDATA,*en,0,0,0);
      
      close(SERIALDATA) || &fatalerror("writeseriallog - cannot close/unlock serial data file: ".$LOGFILE{"SERIALDIR"}.$en{"so"}.".".$serial);
      
   }
   else {

      close($serialfile) || &fatalerror("writeseriallog - cannot close/unlock serial file: ".$LOGFILE{"SERIALDIR"}.$en{"so"}.$CURRENTEXTENSION);

   }
   
   return $serial;
   
}

1;
