
#	$RCSfile: newdb.pl,v $
#	$Revision: 2.0 $
#	$Author: ripe-dbm $
#	$Date: 1996/08/08 10:47:30 $

# This is a little tool to generate an empty database which just contains
# the generation date, and the COPYRIGHT notice as defined in the config
# file. Mainly used for testing purposes.
# One should be careful with this, since it will simply overwrite existing
# database files if the -f flag is given. No Mercy.

PERL5OPTIONS

@INC = ("LIBDIR", @INC);

require "rconf.pl";
require "getopts.pl";

&Getopts('f');

# You need help or have no command line arguments ?

if (!$ARGV[0]) {
	print <<"EOF";

Usage: $0 [-f] file

-f		Force new database even if file exists
filename	The name of the new database file to be generated

EOF

	exit;
}

# Check to see if file exists, and if the force overwrite flag is set

if (-e $ARGV[0] && !$opt_f) {
   print STDERR "File exists, will not overwrite\n";
   exit;
}

# Read the conf, for the COPYRIGHT notice

$conffile=$ENV{"RIPEDBCNF"};
$conffile= "DEFCONFIG" unless $conffile;
&rconf($conffile);

# Here we go ...

open(NEWDB, ">".$ARGV[0]) || &fatalerror("Cannot open $ARGV[0]: $!");

# Print generation date and copyright to the database
#
# printright is required since addkey doesn\'t work
# correct when an offset==0

&printrights(NEWDB);

# And that was it ...

close(NEWDB);

# Delete indexes in case they happen to exist ...

&delormoveindices($ARGV[0], "", 0);
&delormoveindices($ARGV[0].$CLASSLESSEXT, "", 1);

# end of script