
#	$RCSfile: networkupdate.pl,v $
#	$Revision: 2.1 $
#	$Author: ripe-dbm $
#	$Date: 1996/08/08 22:10:32 $

# This is a very simple whois client, but it knows the new server arguments
# No support yet, use if you wish

PERL5OPTIONS

require "getopts.pl";

GETLIB SRCDIR/whoisqry.pl;

&Getopts('h:p:');

if (@ARGV) {

    print <<"EOF";

Usage: networkupdate [-h hostname] [-p port]

where:

-h hostname           which server do we want to update
-p port               which port to connect to

Please note that most of these flags are NOT understood by
non RIPE whois servers
EOF
	exit(0);
}

# try to construct something that looks like an E-mail address
# for logging purposes... 


# find the log name of the user

local($logname)="";

if ($ENV{'USERNAME'}) {
   $logname=$ENV{'USERNAME'};
}
elsif ($ENV{'LOGNAME'}) {
   $logname=$ENV{'LOGNAME'};
}
elsif ($ENV{'USER'}) {
   $logname=$ENV{'USER'};
}
elsif ($ENV{'WHOAMI'}) {
   $logname=$ENV{'WHOAMI'};
} 
else {
   
   local(@others);
   
   ($logname,@others)=getpwuid($<);
   
} 

# try find the domain name of the current host

local($domainname)="";

if ($ENV{'LOCALDOMAIN'}) {
   $domainname=$ENV{'LOCALDOMAIN'};
}
elsif ($ENV{'DOMAIN'}) {
   $domainname=$ENV{'DOMAIN'};
}
elsif ($ENV{'HOST'}) {
   $domainname=$ENV{'HOST'};
}
elsif ($ENV{'HOSTNAME'}) {
   $domainname=$ENV{'HOSTNAME'};
}

$logname="nobody" if ($logname=~ /^\s*$/);
$domainname="localhost" if ($domainname=~ /^\s*$/);

# print STDERR $logname, "@", $domainname, "\n";

# and now we are ready to connect

# returning sockets doesn't work so we use the global one ;-(

local($msg);

if ($msg=&initwhoisqry($opt_h?$opt_h:"WHOISHOST",
                       $opt_p?$opt_p:"",
                       "-Vnp2.0 -U ".$logname." ".$domainname,
                       AF_INETVALUE,SOCKADDRVALUE,SOCK_STREAMVALUE)) {
    
    print STDERR $msg;
    exit 1; 
                       
}                       



sub quitconnection {
   
    close(WHOIS_S);
    print "\nConnection closed.\n";
    
    exit;

}


local($child);

if (($child = fork()) == 0) {

   while ((-S WHOIS_S) && ($towhois=<STDIN>)) {
   
      # print STDERR "To whois: ", $towhois, "\n";
      
      print WHOIS_S $towhois;
   
      &quitconnection() if ($towhois=~ /^\s*\.\s*$/);
   
   }
   
   exit;
   
}

$SIG{'HUP'}='quitconnection';
$SIG{'INT'}='quitconnection';
$SIG{'KILL'}='quitconnection';
$SIG{'TERM'}='quitconnection';
   
while ((-S WHOIS_S) && ($fromwhois=<WHOIS_S>)) {
   
   # print STDERR "From whois: ", $fromwhois, "\n";
      
   print STDOUT $fromwhois;   
   
}

# end of program