
#       handle - nichandle supporting routines
#
#	$RCSfile: handle.pl,v $
#	$Revision: 2.0 $
#	$Author: ripe-dbm $
#	$Date: 1996/08/08 10:47:30 $

@INC = ("LIBDIR", @INC);

require "dbopen.pl";
require "dbclose.pl";

sub findinitials {
    local($line)=@_;
    
    local($initials)="";
    
    #
    # get rid of some very common titles
    
    $line=~ s/^$TITLES//oi;
    
    foreach (split(/ +/, $line)) {
       
       #
       # only use parts that start with capitals
       
       $initials.=$1 if (/^([A-Z])/);
       
       #
       # stop when we reach the maximum number of initials
       
       last if (length($initials)>=$MAXLENGTHINITIALS);
       
    }
    
    return $initials;
    
}

sub findfirstfreehandle {
    local(*db, *othernicdb, *entry)=@_;

    local($source)=$entry{"so"};

    local($split)=0;
    $split=1 if ($SPLIT{$source});
    
    local($initials)= $entry{"nh"}=~ /^$AUTONICPREFIXREGULAR\d+([A-Z]+)$/o;
    
    local($postfix)="-".$NICPOSTFIX{$source};

    #
    # do the start up (make sure to handle DK[01]-RIPE the same like DK-RIPE
    #                  as the InterNIC does)
    
    local(@longkeys);
    
    local(@keys)=&makekeys($initials.$postfix, "", *longkeys);
    local(@keys2)=&makekeys($initials."0".$start.$postfix, "", *longkeys);
    local(@keys3)=&makekeys($initials."1".$start.$postfix, "", *longkeys); 
    
    return $initials."1".$postfix if ((!&dbmatch(*db, *keys, "", 0)) && 
                                       ((!$split) || (!&dbmatch(*othernicdb, *keys, "", 0))) &&
                                      (!&dbmatch(*db, *keys2, "", 0)) && 
                                       ((!$split) || (!&dbmatch(*othernicdb, *keys2, "", 0))) &&
                                      (!&dbmatch(*db, *keys3, "", 0)) && 
                                       ((!$split) || (!&dbmatch(*othernicdb, *keys3, "", 0))));
    
    local($start)=2;
    local($end)=3;
    
    local($oldend)=-1;
    local($oldstart)=-1;
    
    for (;;) {
        
        @keys=&makekeys($initials.$start.$postfix, "", *longkeys);
        
        if ((!&dbmatch(*db, *keys, "", 0)) && 
            ((!$split) || (!&dbmatch(*othernicdb, *keys, "", 0)))) {
        
           return $initials.$start.$postfix;
           
        }
        
        @keys=&makekeys($initials.$end.$postfix, "", *longkeys);
        
        if ((!&dbmatch(*db, *keys, "", 0)) && 
            ((!$split) || (!&dbmatch(*othernicdb, *keys, "", 0)))) {
        
           return $initials.$end.$postfix if ($end-$start==1);
        
           $oldstart=$start;
           $oldend=$end;
           
           $diff=int(($end-$start)*rand(1));
           
           $start++;
           $end+=$diff;
           
        }
        else {
        
           if ($oldstart<0) {
              
              $diff=$end-$start;
           
              $start=$end+1;
              $end=$start+1+int(rand($diff*4));
              
              #
              # for filling the gaps that were
              # made by a quick hack for the finger
              # NIC handle allocation tool
                                                        
              $end=249 if (($start<249) && ($end>249));
              
           }
           else {
           
              $start=$end<$oldend?$end+1:$oldend;
              $end=$oldend;
           
              $oldstart=-1;
           
           }
        
        }
    
    }

}


1;
