
#	$RCSfile: dbupdate.pl,v $
#	$Revision: 2.0 $
#	$Author: ripe-dbm $
#	$Date: 1996/08/08 10:47:30 $

#
# This is a client that will update objects read from a file directly
# in the database.
# It will update the object in the database that is linked to the
# source field of the object, so better make sure you have a source field
# and that it has a database associated to it ...


@INC = ("LIBDIR", @INC);

require "getopts.pl";

require "rconf.pl";
require "processdata.pl";

# Parse options:
#
#
# -v			- verbose output (LONGACK)
# -m mail-address       - treat as mail from mail address for
#                         the MAIL-FROM authorization
# -M			- treat input file (or STDIN) as mail and compose
#			  and send ack mail back
# -A                    - assume "assign" mode, only add will be allowed
#                         usually set by parsing mail headers
# -T                    - TEST database update, accept creation of maintainers
#                         always, but give a warning that this is not the
#                         case in the normal database

&Getopts('Am:MTvV');

#
# Need this below for running perl in tainted mode.

$ENV{"PATH"} = "";
$ENV{"SHELL"} = "/bin/sh";
$ENV{"IFS"} = "";

#
# Read config file from RIPEDBCNF, or set to default.

$conffile=$ENV{"RIPEDBCNF"};
$conffile= "DEFCONFIG" unless $conffile;
print STDERR "dbupdate - reading config\n" if $opt_V;
&rconf($conffile);

#
# run on low priority, whois server queries have an
# higher priority

system("$RENICECMD 10 $$ > /dev/null 2>/dev/null");

if ($opt_m) {
   $opt_M=1;
   $FROM=$opt_m;
   $REPLYTO=$FROM;
   print STDERR "Treating as mail from $FROM\n" if ($opt_V);
}

&dbupdate("", STDOUT);

# end of program
