#	$RCSfile: updatecheck.pl,v $
#	$Revision: 1.20 $
#	$Author: ripe-dbm $
#	$Date: 1995/05/30 13:34:47 $

require "defines.pl";
require "adderror.pl";
require "notify.pl";
require "maintainer.pl";

# In updatecheck one can do all the checks one wants because one has both
# the old and the new object. All checks in here are VERY RIPE database
# specific.

# It is supposed to be like this:
# *cur = empty : addition
# *new = empty : deletion
# non  = empty : update

sub updatecheck {

    local(*cur, *new, *db) = @_;
    local($email, $date) = "";
    local($newdate) = "";
    local($curdate) = "";
    local($stat) = $OK;
    
    local($type) = &entype(*new);

    # If this is a maintainer object, bounce it of to the human mailbox
    # configured in the config and sent them a message explaining this.
    # We use the GENERAL ERROR for this (since that one can add anytext)
    
    if ($type eq "mt") {
	if (!$cur{"mt"} && !$new{"uo"}) {
	    # This is a new maintainer object
	    &adderror(*new, "maintainer objects cannot be created automatically");
	    &adderror(*new, "This object has been forwarded to <$HUMAILBOX>");
	    &adderror(*new, "for authorisation");
	    if (open (TMPMAIL, ">$TMPDIR/mtfw.$$")) {
		select(TMPMAIL);
		eval "print \"$MTFWHEADER\n\";";
		eval "print \"$MTFWTEXT\";";
		print "\n" if &enwrite(*new, 1, 0, 0);
		select (STDOUT);
		close(TMPMAIL);
		system("$MAILCMD < $TMPDIR/mtfw.$$");
	        unlink("$TMPDIR/mtfw.$$");
	    } else {
		&adderror(*new, "!! an error occured, please send object to <$HUMAILBOX> !!");
		&syslog("ERRLOG", "updatecheck cannot open file to forward maintainer object $new{\"mt\"}\n");
	    }
	    return $E_GENERAL;
	}
    }

    # Check update date
    
    foreach (split(/\n/, $new{"ch"})) {
	($email, $date) = split(/\s+/, $_);
	if ($date gt $newdate) { $newdate = $date; }
    }
    foreach (split(/\n/, $cur{"ch"})) {
	($email, $date) = split(/\s+/, $_);
	if ($date gt $curdate) { $curdate = $date; }
    }
    
    if (($newdate lt $curdate) && %new) {
	return $E_OLDER;
    }


    # Check authorisation by maintainer unless override is specified
    # and handles special (dirty trick) delete case with $new in $cur

    if (!$new{"uo"} && !&Maintainer(*cur, *new)) {
        return $E_AUTHFAIL if !$cur{"uo"};
    }

    # Catch if called from dbdel, then skip all checks,
    # just do notification.
    
    if (!&entype(*new)) {
	&AddNotify(*cur, *new);
	$type = &entype(*cur);
	&syslog("AUDITLOG",
		"delete [$type] \"$cur{\"$type\"}\" -> \"$cur{\"ud\"}\"");
	return;
    }
    
    # Reset guarded values unless it has the "override" attribute
    
    &addguard(*new, *cur) unless $new{"uo"};
    
    &AddNotify(*cur, *new);

    # Log special actions

    if ($new{"uo"}) {
	&syslog("AUDITLOG",
		"override by \"$new{\"uo\"}\" for [$type] \"$new{\"$type\"}\"");
    }    

    if ($new{"ua"}) {
	&syslog("AUDITLOG",
		"authorise by \"$new{\"ua\"}\" for [$type] \"$new{\"$type\"}\"");
    }

    return $stat;
}

# Resetting guarded values if necessary

sub addguard {

    local(*new, *cur) = @_;
    local($stat) = $OK;

    foreach (split(/\s+/, $GRD{$type})) {
	if ($new{$_} ne $cur{$_}) {
	    &addwarning(*new,
			"update of guarded attribute \"$ATTL{$_}\" ignored");
	    $new{$_} = $cur{$_};

	}
    }
    return;
}

1;
