/* FP: interface file for RIPE gnuPG */

#define INPUT_FD 0
#define OUTPUT_FD 1
#define ERROR_FD 2

#define LINE_LENGTH 1024
#define STRING_LENGTH 255

#define ERRSTRING strerror (errno)

/* FP : global objects used as and interface with gnuPG */

typedef unsigned int u32;

struct VerifySignObject {
  char *iDocSigFilename, *iSigFilename, *oStream;
  char *keyRing;
  int isValid;
  u32 keyID;
};

struct ReadCryptedObject {
  char *iFilename, *oStream;
  char *keyRing;
  int isValid;
  u32 keyID;
};

struct ImportKeyObject {
  char *iFilename;
  char *keyRing;
  int rc;
  u32 keyID; /* check if it works */
};

enum {
   iKO_OK  = 0,
   iKO_UNCHANGED,
   iKO_NOUSERID,
   iKO_GENERAL,
   iKO_NOTVALIDUSERID,
   iKO_NOPUBLICKEY,
   iKO_NODEFAULTPUBLICKEYRING,
   iKO_GENERALFAILURE
};
