/*
 * Program:	Distributed Electronic Mail Manager (Utilities)
 *
 * Author:	Mark Crispin
 *		Networks and Distributed Computing
 *		Computing & Communications
 *		University of Washington
 *		Administration Building, AG-44
 *		Seattle, WA  98195
 *		Internet: MRC@CAC.Washington.EDU
 *
 * Date:	9 May 1989
 * Last Edited:	22 February 2001
 *
 * The MailManager software provided in this Distribution is
 * Copyright 2001 University of Washington.
 * The full text of our legal notices is contained in the file called
 * CPYRIGHT, included with this Distribution.
 */

// Support for MailManager streamprops

STREAMPROP {
  MAILSTREAM *stream;		// MAIL stream attached to window
  MBoxWindow *window;		// associated MBoxWindow
  int nmsgs;			// number of messages
  STREAMPROP *previous;		// back pointer
  STREAMPROP *next;		// forward pointer
};


// Support for sequences (created by MBoxWindow, used by ReadWindow)

SEQUENCE {
  MESSAGECACHE *lelt;		// cache pointer for this message
  SEQUENCE *previous;		// back pointer
  SEQUENCE *next;		// forward pointer
};


// Function prototypes

void headerline (char *text,MAILSTREAM *stream,MESSAGECACHE *elt);
void selstr (char *str,char *name,const char *arg);
ADDRESS *copy_adr (ADDRESS *adr,ADDRESS *ret);
DPSTimedEntryProc mm_wakeup (DPSTimedEntry teNumber,double now,void *userData);
void putstreamprop (MAILSTREAM *stream,MBoxWindow *window);
STREAMPROP *getstreamprop (MAILSTREAM *stream);
char *fixnl (char *text);
unsigned char *gettext (Text *view);
void linebreak (unsigned char *dst,unsigned char *src);
void wordcopy (unsigned char **wrd,unsigned char **dst,unsigned char **src,
	       unsigned char *end);
void append_msg (FILE *file,ADDRESS *s,MESSAGECACHE *elt,char *hdr,
		 unsigned char *text);
char *filtered_header (ENVELOPE *env);
void write_address (char **dest,char *tag,ADDRESS *adr);


// Header geometry

#define FLAGS "RFAD"
#define DATE "dd-mmm"
#define FROM "ffffffffffffffffffff"
#define SUBJECT "sssssssssssssssssssssssssssssssss"
#define FLAGSLEN sizeof (FLAGS)
#define DATELEN sizeof (DATE)
#define FROMLEN sizeof (FROM)
#define SUBJECTLEN sizeof (SUBJECT)


// Message geometry

#define MAXLINELENGTH 78
