/*
 * Program:	Distributed Electronic Mail Manager (SendWindow object)
 *
 * Author:	Mark Crispin
 *		Networks and Distributed Computing
 *		Computing & Communications
 *		University of Washington
 *		Administration Building, AG-44
 *		Seattle, WA  98195
 *		Internet: MRC@CAC.Washington.EDU
 *
 * Date:	25 October 1996
 * Last Edited:	22 February 2001
 *
 * The MailManager software provided in this Distribution is
 * Copyright 2001 University of Washington.
 * The full text of our legal notices is contained in the file called
 * CPYRIGHT, included with this Distribution.
 */

@interface SendWindow : Object
{
  id debugging;			// switch for debug
  id from;			// From: list
  id replyTo;			// Reply-To: list
  id to;			// primary recipients
  id cc;			// carbon copy recipients
  id bcc;			// blind carbon recipients
  id subject;			// subject text
  id envelopeView;		// view of message envelope
  id bodyView;			// view of message body
  id window;			// window on the screen
  id attachmentPanel;		// panel of attachments
  id attachmentView;		// view of attachments
  id book;			// address book
  Matrix *browser;		// browser of attachment view
  NXRect envelopeFrame;		// frame of envelope
  int start;			// selection start
  int end;			// selection end
  ENVELOPE *env;		// envelope to give to MTP
  PART *attachments;		// attachment body parts
  BOOL select;			// call selectBody in envelope item actions
  SNDSoundStruct *sound;	// sound being recorded
}

+ new;
- init;
- setWindow:anObject;
- setFrom:anObject;
- setReplyTo:anObject;
- setTo:anObject;
- setCc:anObject;
- setBcc:anObject;
- setSubject:anObject;
- setEnvelopeView:anObject;
- setBodyView:anObject;
- setAttachmentPanel:anObject;
- setAttachmentView:anObject;
- bodyView;
- (ENVELOPE *) msg;
- window;
- help:sender;
- from:sender;
- replyTo:sender;
- to:sender;
- cc:sender;
- bcc:sender;
- setAddress:view :(ADDRESS **) list;
- subject:sender;
- textDidEnd:textObject endChar:(unsigned short) whyEnd;
- (BOOL) textWillEnd:textObject;
- selectBody;
- updateEnvelopeView;
- insertFile:sender;
- attachFile:sender;
- (PART *) attachFile:(char *) name data:(char *) data size:(int) size;
- attachSound:sender;
- deleteAttachment:sender;
- reformat:sender;
- send:sender;
- exit:sender;
- windowWillClose:sender;
- windowWillResize:sender toSize:(NXSize *) frameSize;
- windowDidMove:sender;
- windowWillReturnFieldEditor:sender toObject:client;	// mdd
- setDebugging:anObject;
- rcptErr:(ADDRESS *) adr;

@end
