/*
 * Program:	Distributed Electronic Mail Manager (ReplyWindow object)
 *
 * Author:	Mark Crispin
 *		Networks and Distributed Computing
 *		Computing & Communications
 *		University of Washington
 *		Administration Building, AG-44
 *		Seattle, WA  98195
 *		Internet: MRC@CAC.Washington.EDU
 *
 * Date:	27 June 1989
 * Last Edited:	22 February 2001
 *
 * The MailManager software provided in this Distribution is
 * Copyright 2001 University of Washington.
 * The full text of our legal notices is contained in the file called
 * CPYRIGHT, included with this Distribution.
 */


#import "MailManager.h"

@implementation ReplyWindow

// Create a new ReplyWindow

+ new:(MAILHANDLE *) h lelt:(MESSAGECACHE *) e text:(char *) text all:(BOOL) all
{
  char tmp[16*TMPLEN],frm[TMPLEN],c,*src,*dst,*d;
  int i;
  ENVELOPE *msg;
  self = [super new];		// open a SendWindow, set as window's delegate
  [[self window] setDelegate:self];
  [self setHandle:h];
  [self setElt:e];
				// note cache element for later and lock
  if (!++e->lockcount) fatal ("Elt lock count overflow");
				// copy reply-to
  (msg = [self msg])->to = copy_adr (e->private.msg.env->reply_to,NIL);
  if (all) {			// copy to/cc lists if "reply all"?
    if (msg->to) msg->cc = copy_adr (e->private.msg.env->cc,copy_adr (e->private.msg.env->to,msg->cc));
    else msg->to = copy_adr (e->private.msg.env->cc,copy_adr (e->private.msg.env->to,NIL));
    msg->bcc = copy_adr (e->private.msg.env->bcc,msg->bcc);
  }
  if (e->private.msg.env->subject) {	// use subject in reply if present
    strncpy (tmp,e->private.msg.env->subject,3);
    tmp[3] ='\0';		// tie off copy of first 3 chars
    ucase (tmp);		// make the whole thing uppercase
				// a "re:" already there?
    if (strcmp (tmp,"RE:")) sprintf (tmp,"re: %s",e->private.msg.env->subject);
    else sprintf (tmp,"%s",e->private.msg.env->subject);
  }
  else sprintf (tmp,"(response to message of %s)",e->private.msg.env->date);
  msg->subject = cpystr (tmp);	// copy desired subject
				// calculate simple from
  if (!e->private.msg.env->from) strcpy (frm,"(unknown)");
  else if (e->private.msg.env->from->personal) strcpy (frm,e->private.msg.env->from->personal);
  else sprintf (frm,"%s@%s",e->private.msg.env->from->mailbox,e->private.msg.env->from->host);
				// in-reply-to is our message-id if exists
  if (e->private.msg.env->message_id) sprintf (tmp,"%s",e->private.msg.env->message_id);
  else sprintf (tmp,"Message of %s from %s",e->private.msg.env->date,frm);
  msg->in_reply_to = cpystr (tmp);

  sprintf (tmp,"On %s, %s wrote:\n\n> Subject: %s\n",
	   e->private.msg.env->date,frm,e->private.msg.env->subject ? e->private.msg.env->subject : "(none)");
  d = tmp + strlen (tmp);
  write_address (&d,"> To",e->private.msg.env->to);
  write_address (&d,"> cc",e->private.msg.env->cc);
  strcat (d,">\n> ");		// trailing junk
				// get size of header + text
  i = strlen (src = text) + strlen (tmp);
				// plus space for leading widgits in string
  while (*src) if (*src++ == '\n') i += 2;
  strcpy (d = fs_get (i+1),tmp);// start with header
  dst = d + strlen (d);		// set destination at end of header
  src = text;			// set up for copy
  while (c = *src++) {		// copy string, inserting brokets at each line
    if (c != '\r') *dst++ = c;	// first copy the character (nuke CR if seen)
    if ((c == '\n') && *src) {	// if newline and not end
      *dst++ = '>';		// insert widgit + space if not blank line
      if (*src != '\n') *dst++ = ' ';
    }
  }
				// back over blank lines
  while ((dst[-1] == '\n') && (dst[-2] == '>') && (dst[-3] == '\n')) dst -= 2;
				// ensure ending with newline
  if (dst[-1] != '\n') *dst++ = '\n';
  *dst++ = '\0';		// tie off string
  [NXApp setPasteboard:d];	// write reply message to pasteboard
  fs_give ((void **) &d);	// return the space
  return [self updateEnvelopeView];
}

// "Attach" on bottom of read window

- attachWindow:w
{
  NXRect frame;
  NXPoint pt;
  [window getFrame:&frame];	// get our dimensions
  pt.x = 0;			// get window's bottom left corner
  pt.y = 0;
  [w convertBaseToScreen:&pt];	// get it in screen coordinates
				// move our top left to that place
  [window moveTopLeftTo:pt.x :max (pt.y,NX_HEIGHT (&frame))];
  return self;
}


// Reply has been sent

- exit:sender
{
  char tmp[TMPLEN];
  MAILSTREAM *stream = handle ? mail_stream (handle) : NIL;
  if (stream && lelt->msgno) {
				// mark message as answered
    sprintf (tmp,"%lu",lelt->msgno);
    mail_setflag (stream,tmp,"\\Answered");
				// update status in main window
    [(getstreamprop (stream))->window updateTitle];
  }
  [super exit:self];		// do the superior's actions
  return self;
}


- setElt:(MESSAGECACHE *) e
{
  lelt = e;
  return self;
}


- setHandle:(MAILHANDLE *) h
{
  handle = h;
  return self;
}


// Window is closing

- windowWillClose:sender
{
  mail_free_elt (&lelt);	// flush the cache element
  mail_free_handle (&handle);	// flush the MAIL stream handle
				// do the superior's actions
  return [super windowWillClose:sender];
}


@end
