/*
 * Program:	Distributed Electronic Mail Manager (PullOutMenu object)
 *
 * Author:	Mark Crispin
 *		Networks and Distributed Computing
 *		Computing & Communications
 *		University of Washington
 *		Administration Building, AG-44
 *		Seattle, WA  98195
 *		Internet: MRC@CAC.Washington.EDU
 *
 * Date:	18 July 1989
 * Last Edited:	22 February 2001
 *
 * The MailManager software provided in this Distribution is
 * Copyright 2001 University of Washington.
 * The full text of our legal notices is contained in the file called
 * CPYRIGHT, included with this Distribution.
 */


#import "MailManager.h"

@implementation PullOutMenu

// Create a new PullOutMenu

+ new:(Button *) aButton
{
  self = [super new];		// ask superior to make us
				// pull-down menu style
  [self changeButtonTitle:FALSE];
  NXAttachPopUpList (aButton,self);
  [aButton setIcon:"menuArrow"];
  return self;			// give us back to caller
}


// Add a new item to the list

- addItem:(const char *)title action:(SEL) action;
{
  return [[self addItem:title] setAction:action];
}


// Position the menu

- moveTopLeftTo:(NXCoord) x :(NXCoord) y
{
  x += 20;
  [super moveTopLeftTo:x :y];	// move to that position
  return self;
}


// Set the geometry of the menu

- sizeWindow:(NXCoord) width :(NXCoord) height
{
  NXRect r;
  [matrix sizeToFit];		// resize matrix to hold all the items
  [matrix getFrame:&r];		// get that geometry
				// resize the window to that
  [super sizeWindow:NX_WIDTH (&r) :NX_HEIGHT (&r)];
  return self;
}


@end
