/*
 * Program:	Distributed Electronic Mail Manager (AttachedPanel class)
 *
 * Author:	Mark Crispin
 *		Networks and Distributed Computing
 *		Computing & Communications
 *		University of Washington
 *		Administration Building, AG-44
 *		Seattle, WA  98195
 *		Internet: MRC@CAC.Washington.EDU
 *
 * Date:	15 May 1989
 * Last Edited:	22 February 2001
 *
 * The MailManager software provided in this Distribution is
 * Copyright 2001 University of Washington.
 * The full text of our legal notices is contained in the file called
 * CPYRIGHT, included with this Distribution.
 */


#import "MailManager.h"

@implementation AttachedPanel

// AttachedPanel's don't center

- center
{
  return self;
}


// AttachedPanel's don't get moved this way either

- moveTopLeftTo:(NXCoord) x :(NXCoord) y
{
  return self;
}


// This should be in the Appkit and done right but...


// "Attach" to the left of a master window

- attachWindow:(Window *) window
{
  NXPoint pt;
  NXRect r;
  [window getFrame:&r];		// get window's rectangle
  pt.x = NX_WIDTH (&r);		// get its top right corner
  pt.y = NX_HEIGHT (&r);
				// get it in screen coordinates
  [window convertBaseToScreen:&pt];
				// move our top left to that place
  [super moveTopLeftTo:pt.x :pt.y];
  return self;
}


@end
