/*
 * Program:	Distributed Electronic Mail Manager (AddressBookCell class)
 *
 * Author:	Mark Crispin
 *		Networks and Distributed Computing
 *		Computing & Communications
 *		University of Washington
 *		Administration Building, AG-44
 *		Seattle, WA  98195
 *		Internet: MRC@CAC.Washington.EDU
 *
 * Date:	22 March 1990
 * Last Edited:	22 February 2001
 *
 * The MailManager software provided in this Distribution is
 * Copyright 2001 University of Washington.
 * The full text of our legal notices is contained in the file called
 * CPYRIGHT, included with this Distribution.
 */


@interface AddressBookCell : ActionCell
{
  const char *nickName;		// short nickname
  const char *fullName;		// full name
  const char *address;		// electronic mail address
  const char *extra;		// extra information
}

+ new;
- free;
- setNickName:(char *) newNickName fullName:(char *) newFullName
 address:(char *) newAddress extra:(char *) newExtra;
- (const char *) nickName;
- (const char *) fullName;
- (const char *) address;
- (const char *) extra;

@end
