/*
 * Program:	Distributed Electronic Mail Manager (AddressBook object)
 *
 * Author:	Mark Crispin
 *		Networks and Distributed Computing
 *		Computing & Communications
 *		University of Washington
 *		Administration Building, AG-44
 *		Seattle, WA  98195
 *		Internet: MRC@CAC.Washington.EDU
 *
 * Date:	8 March 1990
 * Last Edited:	22 February 2001
 *
 * The MailManager software provided in this Distribution is
 * Copyright 2001 University of Washington.
 * The full text of our legal notices is contained in the file called
 * CPYRIGHT, included with this Distribution.
 */

@interface AddressBook:Object
{
  id entry;			// form of entry items
  id nickname;			// entry nickname
  id name;			// personal name
  id address;			// net e-mail address
  id window;			// our window
  id addressItems;		// view of address items
  Matrix *browser;		// browser of address items
}

- setNickname:anObject;
- setName:anObject;
- setAddress:anObject;
- setWindow:anObject;
- setAddressItems:anObject;
- help:sender;
- window;
- new:sender;
- selectAddress:sender;
- OK:sender;
- add:sender;
- addNickName:(char *) newNickName fullName:(char *) newFullName
 address:(char *) newAddress extra:(char *) newExtra update:(BOOL) update;
- remove:sender;
- lookup:(ADDRESS **) adr;
- (int) find:(char *) t;
- update;

@end
