.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.\" X Window System is a trademark of The Open Group.
.\"
.\" Copyright (c) 2004, Oracle and/or its affiliates.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XAddHost __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XAddHost, XAddHosts, XListHosts, XRemoveHost, XRemoveHosts, XSetAccessControl, XEnableAccessControl, XDisableAccessControl, XHostAddress, XServerInterpretedAddress \- control host access and host control structure
.SH SYNTAX
.HP
int XAddHost\^(\^Display *\fIdisplay\fP, XHostAddress *\fIhost\fP\^);
.HP
int XAddHosts\^(\^Display *\fIdisplay\fP, XHostAddress *\fIhosts\fP,
int \fInum_hosts\fP\^);
.HP
XHostAddress *XListHosts\^(\^Display *\fIdisplay\fP, int *\fInhosts_return\fP,
Bool *\fIstate_return\fP\^);
.HP
int XRemoveHost\^(\^Display *\fIdisplay\fP, XHostAddress *\fIhost\fP\^);
.HP
int XRemoveHosts\^(\^Display *\fIdisplay\fP, XHostAddress *\fIhosts\fP, int \fInum_hosts\fP\^);
.HP
int XSetAccessControl\^(\^Display *\fIdisplay\fP, int \fImode\fP\^);
.HP
int XEnableAccessControl\^(\^Display *\fIdisplay\fP\^);
.HP
int XDisableAccessControl\^(\^Display *\fIdisplay\fP\^);
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIhost\fP 1i
Specifies the host that is to be added or removed.
.IP \fIhosts\fP 1i
Specifies each host that is to be added or removed.
.IP \fImode\fP 1i
Specifies the mode.
You can pass
.B EnableAccess
or
.BR DisableAccess .
.IP \fInhosts_return\fP 1i
Returns the number of hosts currently in the access control list.
.IP \fInum_hosts\fP 1i
Specifies the number of hosts.
.IP \fIstate_return\fP 1i
Returns the state of the access control.
.SH DESCRIPTION
The
.B XAddHost
function adds the specified host to the access control list for that display.
The server must be on the same host as the client issuing the command, or a
.B BadAccess
error results.
.LP
.B XAddHost
can generate
.B BadAccess
and
.B BadValue
errors.
.LP
The
.B XAddHosts
function adds each specified host to the access control list for that display.
The server must be on the same host as the client issuing the command, or a
.B BadAccess
error results.
.LP
.B XAddHosts
can generate
.B BadAccess
and
.B BadValue
errors.
.LP
The
.B XListHosts
function returns the current access control list as well as whether the use
of the list at connection setup was enabled or disabled.
.B XListHosts
allows a program to find out what machines can make connections.
It also returns a pointer to a list of host structures that
were allocated by the function.
When no longer needed,
this memory should be freed by calling
.BR XFree .
.LP
The
.B XRemoveHost
function removes the specified host from the access control list
for that display.
The server must be on the same host as the client process, or a
.B BadAccess
error results.
If you remove your machine from the access list,
you can no longer connect to that server,
and this operation cannot be reversed unless you reset the server.
.LP
.B XRemoveHost
can generate
.B BadAccess
and
.B BadValue
errors.
.LP
The
.B XRemoveHosts
function removes each specified host from the access control list for that
display.
The X server must be on the same host as the client process, or a
.B BadAccess
error results.
If you remove your machine from the access list,
you can no longer connect to that server,
and this operation cannot be reversed unless you reset the server.
.LP
.B XRemoveHosts
can generate
.B BadAccess
and
.B BadValue
errors.
.LP
The
.B XSetAccessControl
function either enables or disables the use of the access control list
at each connection setup.
.LP
.B XSetAccessControl
can generate
.B BadAccess
and
.B BadValue
errors.
.LP
The
.B XEnableAccessControl
function enables the use of the access control list at each connection setup.
.LP
.B XEnableAccessControl
can generate a
.B BadAccess
error.
.LP
The
.B XDisableAccessControl
function disables the use of the access control list at each connection setup.
.LP
.B XDisableAccessControl
can generate a
.B BadAccess
error.
.SH STRUCTURES
The
.B XHostAddress
structure contains:
.LP
.EX
typedef struct {
        int family;     /\&* for example FamilyInternet */
        int length;     /\&* length of address, in bytes */
        char *address;  /\&* pointer to where to find the address */
} XHostAddress;
.EE
.LP
The family member specifies which protocol address family to use
(for example, TCP/IP or DECnet) and can be
.BR FamilyInternet ,
.BR FamilyInternet6 ,
.BR FamilyServerInterpreted ,
.BR FamilyDECnet ,
or
.BR FamilyChaos .
The length member specifies the length of the address in bytes.
The address member specifies a pointer to the address.
.LP
For the ServerInterpreted family, the length is ignored and the address
member is a pointer to a
.B XServerInterpretedAddress
structure which contains:
.LP
.EX
typedef struct {
        int typelength;         /\&* length of type string, in bytes */
        int valuelength;        /\&* length of value string, in bytes */
        char *type;             /\&* pointer to where to find the type string */
        char *value;            /\&* pointer to where to find the address */
} XServerInterpretedAddress;
.EE
.LP
The type and value members point to strings representing the type and value of
the server interpreted entry.
These strings may not be NULL-terminated so care
should be used when accessing them.
The typelength and valuelength members
specify the length in byte of the type and value strings.
.SH DIAGNOSTICS
.TP 1i
.B BadAccess
A client attempted
to modify the access control list from other than the local
(or otherwise authorized) host.
.TP 1i
.B BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.
Any argument defined as a set of
alternatives can generate this error.
.SH "SEE ALSO"
XFree(__libmansuffix__)
.br
\fI\*(xL\fP
