#ifndef MAIN_H
#define MAIN_H

void save_game(void);

void str_print(char *msg);
int count_inventory(void);
int is_really_dark(void);
int is_dark(void);

void print_room_items(int location);
void print_room_exits(int room);
void print_table_string(UINT16 table, int table_offset);
void print_room_descr(int room);
void print_the_string(int string_num);
void num_print(int num);
void run_game(void);
void load_game(void);

int noun_item(int noun_word_num, int from);
void gprintf(char *strX, ...);

UINT16 fix_address(UINT16 ina);
UINT16 fix_word(UINT16 word);
UINT8 get_byte(UINT8 *mem);
UINT16 get_word(UINT8 *mem);
void set_bit(unsigned char *bits, int pos, int state);
int get_bit(unsigned char *bits, int pos);

void calc_max_items(void);
void calc_max_messages(void);
void decompile_game(void);
void decomp_the_string(int msg);
void decomp_item_name(int item);
void decomp_word(int word, UINT16 table, int num_words);
void decomp_table_string(UINT16 table, int table_offset);

glui32 get_keypress(void);
void grab_input(void);

extern int max_messages;

extern int saved_seed;
extern int action;
extern winid_t mainwin;
extern winid_t roomwin;
extern frefid_t f_script_input;
extern strid_t	s_script_input;
extern frefid_t f_output;
extern strid_t	s_output;

/* global data */
extern 	char *game_file;
extern 	long game_size;
extern char *script_file;
extern char *source_file;

extern 	struct HEADER		h;
extern 	struct DATAHEADER 	dh;

extern 	UINT8		*game;
extern 	struct GAME *gm;
extern 	struct GAME *gm_undo;

extern	int		move_room;
extern 	int 	game_flag;
extern 	int		inroom_flag;
extern	int		counter_idx;

extern 	char	in_noun[32];
extern	char	in_verb[32];
extern	int		verb_num;
extern	int		noun_num;
extern	int		item_num;
extern	int		scripting;
extern	int		count_light;
extern	int		dump_codes;

extern int		max_item_descr;

#endif
