/*
 *   Test HTML modes kept between turns
 */

#include <adv3.h>
#include <en_us.h>
//#include <file.h>
//#include <date.h>
//#include <tads.h>
//#include <file.h>
//#include <date.h>
//#include <harset.h>

gameMain: GameMainDef
	initialPlayerChar = me
   showIntro()   
   	{
   	"XTads - test HTML modes between turns.<p>";
   	} 
   showGoodbye()   
   	{ 
   	"<p>Thanks for playing!</p>";   
   	} 
   ;

versionInfo: GameID
	name = 'XTads HTML modes test'
	byline = 'by Rune Berg'
	htmlByline = 'by <a href="mailto:runeberg76@gmail.com">Rune Berg</a>'
	version = '0. Serial number 000000.'
	authorEmail = 'runeberg76@gmail.com' 
  	desc = 'An XTads test game.'   
  	htmlDesc = 'An XTads test game.'
  	showCredit()
  		{ 
  		"The TADS 3 language and library were created by Michael J. Roberts.";
  		"\b";   
  		} 
  	showAbout()   
  		{ 
  		"<b>Nah...</b>\n
  		<p>";
  		} 
  ;

me: Actor 
    desc = "You're not interesting. " 
    location = testRoom
;

testRoom: Room 
	roomName = 'Test Room'
	desc 
		{
		"Nothing to see here. Type: on/off tag-name ";
		}
	//knownModeTags = ['b', 'i', 'center', 'h1', 'pre']
	setMode(modeName, state)
		{
		local modeNameLc = modeName.toLower();
		//if (knownModeTags.indexOf(modeNameLc) != nil) 
			{
			local slash = (state ? '' : '/');
			local onOff = (state ? 'on' : 'off');
			"\<<<slash>><<modeNameLc>>\>";
			"<<modeNameLc>> <<onOff>>";
			} 
		//else 
		//	{
		//	"*** Unknown mode <<modeNameLc>>";
		//	}
		}
	;

/* 
 *  "on <topic>" verb
 */

DefineTopicAction(On)
	execAction()
		{
		testRoom.setMode(gTopic.getTopicText(), true);
		}
	;

VerbRule(On)
   'on' singleTopic
   : OnAction
   verbPhrase = 'on/oning (what)'
   askDobjResponseProd = singleNoun
	;

/* 
 *  "off <topic>" verb
 */

DefineTopicAction(Off)
	execAction()
		{
		testRoom.setMode(gTopic.getTopicText(), nil);
		}
	;

VerbRule(Off)
   'off' singleTopic
   : OffAction
   verbPhrase = 'off/offing (what)'
   askDobjResponseProd = singleNoun
	;

/* 
 *  "misc" verb
 */

DefineIAction(Misc)
	execAction()
		{
		"regular <b>bold only <i>bold and italics</i> bold only </b>regular\n";
		"regular <b>bold only <i>bold and italics</b> italics only? </i>regular?\n";
		"regular <i>italics only <b>bold and italics</b> italics only </i>regular\n";
		"regular <i>italics only <b>bold and italics</i> bold only? </b>regular\n";
		" \n";
		"regular <i>italics only </b>italics only?</i> regular?\n";
		"regular <b>bold only </i>bold only? </b>regular?\n";
		//TODO compare to qtads and mjr terp
		}
	;
	
VerbRule(Misc)
	('misc')
	: MiscAction
	verbPhrase = 'misc/miscing'
	;
