#include <tads.h>

/*
 * An XTads test game.
 * Focus is on sizing vert. text banner to content.
 */
main(args)
{
	local b0 = nil;

    "A banner test game for XTads.\b\b";

    local b1 = bannerCreate(b0, BannerFirst, nil, BannerTypeText, BannerAlignRight,
                       50, BannerSizePercent,
                       0);
    "b1 (child of b0) is a vertical text banner right of b0, sized to 50% of its parent. ";
    "\bPress a key to continue...\n";
    inputKey();

    bannerSizeToContents(b1);
    "\bb1 should now be sized to horiz content - i.e. be invisible\n";
    "\bPress a key to continue...\n";
    inputKey();
    
    bannerSay(b1, '1');
    bannerSizeToContents(b1);
    "\bb1 should now be sized to horiz content\n";
    "\bPress a key to continue...\n";
    inputKey();
    
    bannerSay(b1, ' 12');
    bannerSizeToContents(b1);
    "\bb1 should now be sized to horiz content\n";
    "\bPress a key to continue...\n";
    inputKey();
    
    bannerSay(b1, ' 123');
    bannerSizeToContents(b1);
    "\bb1 should now be sized to horiz content\n";
    "\bPress a key to continue...\n";
    inputKey();
    
    bannerSay(b1, ' 12');
    bannerSizeToContents(b1);
    "\bb1 should now be sized to horiz content\n";
    "\bPress a key to continue...\n";
    inputKey();

    bannerSay(b1, ' <b>123456</b>');
    bannerSizeToContents(b1);
    "\bb1 should now be sized to horiz content\n";
    "\bPress a key to continue...\n";
    inputKey();
    
    bannerSay(b1, ' 123456789');
    bannerSizeToContents(b1);
    "\bb1 should now be sized to horiz content\n";
    "\bPress a key to continue...\n";
    inputKey();
    
    bannerSay(b1, ' 123456789012');
    bannerSizeToContents(b1);
    "\bb1 should now be sized to horiz content\n";
    "\bPress a key to continue...\n";
    inputKey();

	 bannerClear(b1);
    bannerSizeToContents(b1);
    "\bb1 should now be sized to horiz content - i.e. be invisible\n";
    "\bPress a key to continue...\n";
    inputKey();    

    bannerSay(b1, '1');
    bannerSizeToContents(b1);
    "\bb1 should now be sized to horiz content\n";
    "\bPress a key to continue...\n";
    inputKey();    

    "\bPress another key to exit...\n";
    inputKey();
}

showBannerInfo(win)
{
    local info = bannerGetInfo(win);

    "align = <<info[1]>>, style = <<toString(info[2], 16)>>,
    rows = <<info[3]>>, columns = <<info[4]>>, pixel height = <<info[5]>>,
    pixel width = <<info[6]>>";
}
