#include <tads.h>

/*
 * An XTads test game.
 * Focus is on abs sizing horiz. text banner w/ border and/or scroll bar(s).
 */
main(args)
{
	local b0 = nil;

    "A banner test game for XTads.\b\b";
    "b1 (child of b0) is a horiz grid banner above b0 sized to 5 lines.\n
    All 5 lines should show. ";

    local b1 = bannerCreate(b0, BannerFirst, nil, BannerTypeTextGrid, BannerAlignTop,
                       5, BannerSizeAbsolute,
                       BannerStyleHScroll); // | BannerStyleBorder);
    bannerSetTextColor(b1, ColorYellow, ColorBlack);
    bannerSay(b1, 'b1 Line 1\nLine 2\nLine3\nLine4\nLine5');
    "\bPress a key to continue...\b";
    inputKey();
    
    bannerClear(b1);
    "\bBanner should now be cleared
    \nPress a key to continue...\b";
    inputKey();

    bannerSay(b1, 'b1 new Line 1\n');
    "\bBanner should now contain one new line
    \nPress a key to continue...\b";
    inputKey();
    
    bannerGoTo(b1, 3, 4);
    bannerSay(b1, 'at row 3, col 4');
    "\bBanner should now contain three new lines
    \nPress a key to continue...\b";
    inputKey();

    bannerSizeToContents(b1);
    "After resize to contents\b
    Press a key to continue...\b";

    "Press another key to exit...\n";
    inputKey();
}
