#include <tads.h>

/*
 * An XTads test game.
 * Focus is on auto-scrolling for grid banner.
 */
main(args)
{
	local b0 = nil;
	local b1;
    
    "A banner test game for XTads.";

    //------------

    "\bGrid banner. Vert & horiz auto-scroll. Vert & horiz scroll-bars:";
    b1 = bannerCreate(b0, BannerFirst, nil, BannerTypeTextGrid, BannerAlignBottom,
                       50, BannerSizePercent,
                       BannerStyleVScroll | BannerStyleAutoVScroll | BannerStyleHScroll | BannerStyleAutoHScroll);
    bannerSetTextColor(b1, ColorBlue, ColorTransparent);
    "\bPress a key to continue...";
    inputKey();
    
    walkGrid(b1);
    "\bPress a key to continue...";
    inputKey();

    bannerDelete(b1);
    clearScreen();
    
    //------------

    "\bGrid banner. Vert & horiz auto-scroll. No scroll-bars:";
    b1 = bannerCreate(b0, BannerFirst, nil, BannerTypeTextGrid, BannerAlignBottom,
                       50, BannerSizePercent,
                       BannerStyleAutoVScroll | BannerStyleAutoHScroll);
    bannerSetTextColor(b1, ColorBlue, ColorTransparent);
    "\bPress a key to continue...";
    inputKey();
    
    walkGrid(b1);
    "\bPress a key to continue...";
    inputKey();

    bannerDelete(b1);
    clearScreen();  
    
    //------------
    
    "\bPress another key to exit...\n";
    inputKey();
}

walkGrid(banner)
{
	local coordList = [[10,10], [1,1], [2,2], [50,50], [20,20], [51,51], [1,5], [50,1], [55,55], [50,1], [3,3], [60, 60], [4,4], [70,1], [1,2], [65,10], [1,1], [1,50], [5,5]];
	
	foreach (local coord in coordList) {
		local row = coord[1];
		local col = coord[2];
    	bannerGoTo(banner, row, col);
    	local msg = '' + row + ',' + col;
	   bannerSay(banner, msg); 
	   "<<msg>>\n";
    	inputKey();
    }
}
