#include <tads.h>

/*
 * An XTads test game.
 * Focus is on scroll bars for grid banner.
 */
main(args)
{
	local b0 = nil;
    
    "A banner test game for XTads.";

	/*    
    "\bGrid banner with horiz scroll bar:";

    local b1 = bannerCreate(b0, BannerFirst, nil, BannerTypeTextGrid, BannerAlignBottom,
                       50, BannerSizePercent,
                       BannerStyleHScroll);
    bannerSetTextColor(b1, ColorYellow, ColorBlack);
    "\bPress a key to continue...";
    inputKey();
    
    bannerGoTo(b1, 1, 1);
    bannerSay(b1, '1234567890');
    inputKey();
    
    bannerGoTo(b1, 2, 11);
    bannerSay(b1, '1234567890');
    inputKey();
    
    bannerGoTo(b1, 3, 21);
    bannerSay(b1, '1234567890');
    inputKey();
    
    bannerGoTo(b1, 4, 31);
    bannerSay(b1, '1234567890');
    inputKey();
    
    bannerGoTo(b1, 5, 41);
    bannerSay(b1, '1234567890');
    inputKey();
    
    bannerGoTo(b1, 6, 51);
    bannerSay(b1, '1234567890');
    inputKey();
    
    bannerGoTo(b1, 7, 61);
    bannerSay(b1, '1234567890');
    inputKey();
    
    bannerDelete(b1);
    clearScreen();
    */

    "\bGrid banner without scroll bars:";

    local b1 = bannerCreate(b0, BannerFirst, nil, BannerTypeTextGrid, BannerAlignBottom,
                       50, BannerSizePercent,
                       0);
    bannerSetTextColor(b1, ColorYellow, ColorBlack);
    "\bPress a key to continue...";
    inputKey();
    
    fillGrid(b1);
    "\bPress a key to continue...";
    inputKey();

    bannerDelete(b1);
    clearScreen();
    
    //------------

    "\bGrid banner with vert scroll bar:";

    b1 = bannerCreate(b0, BannerFirst, nil, BannerTypeTextGrid, BannerAlignBottom,
                       50, BannerSizePercent,
                       BannerStyleVScroll);
    bannerSetTextColor(b1, ColorYellow, ColorBlack);
    "\bPress a key to continue...";
    inputKey();
    
    fillGrid(b1);
    "\bPress a key to continue...";
    inputKey();

    bannerDelete(b1);
    clearScreen();

    //------------

    "\bGrid banner with horiz scroll bar:";

    b1 = bannerCreate(b0, BannerFirst, nil, BannerTypeTextGrid, BannerAlignBottom,
                       50, BannerSizePercent,
                       BannerStyleHScroll);
    bannerSetTextColor(b1, ColorYellow, ColorBlack);
    "\bPress a key to continue...";
    inputKey();
    
    fillGrid(b1);
    "\bPress a key to continue...";
    inputKey();

    bannerDelete(b1);
    clearScreen();

    //------------

    "\bGrid banner with vert and horiz scroll bar:";

    b1 = bannerCreate(b0, BannerFirst, nil, BannerTypeTextGrid, BannerAlignBottom,
                       50, BannerSizePercent,
                       BannerStyleVScroll | BannerStyleHScroll);
    bannerSetTextColor(b1, ColorYellow, ColorBlack);
    "\bPress a key to continue...";
    inputKey();
    
    fillGrid(b1);
    "\bPress a key to continue...";
    inputKey();

    bannerDelete(b1);
    clearScreen();

	 //--------------    
    
    "\bPress another key to exit...\n";
    inputKey();
}

fillGrid(banner)
{
    for (local i = 0; i < 50; i++) {
    		for (local j = 0; j < 10; j++) {
    			bannerSay(banner, 'Line ' + i + ' ');
    		}
  			bannerSay(banner, '\n');
    }
}
