/* The Scoring Methods:
 *	The following lines show how the right half of the status line will
 * appear on turn 10, with 5 points (1 puzzle solved), 100 total points
 * (20 total puzzles), and a starting time of 9:00am on Monday.
 *
 *	You are 5% done.			PERCENT_SCORE
 *	Puzzles Remaining: 19			PUZZLE_SCORE
 *	Score: 5				SCORE_SCORE
 *	Score: 5 / Turn: 10			SCORE_TURN_SCORE
 *	Monday 9:10 a.m.			TIME_SCORE
 *	Turn: 10				TURN_SCORE
 *
 * These are each easily modifiable, so I think that this is a good enough
 * selection for you to play with.  The SCORE_TURN_SCORE method is the
 * default selected for you in WADV.T.  To choose another, just comment the
 * default out, and uncomment another one.  Whichever you choose, please
 * be sure to read this file before using any of them.  There are some
 * important notes in that file, as well as some reasonably interesting code
 * besides. (Read 'some creative uses of #ifdef' here.)
 */

/*
 *  incscore: function( amount )
 *
 *  Adds amount to the total score, and updates the status line
 *  to reflect the new score.  The total score is kept in global.score.
 *  Always use this routine rather than changing global.score
 *  directly, since this routine ensures that the status line is
 *  updated with the new value.  NOTE: When using the PUZZLE_SCORE method,
 * always call incscore() with a 1, as in 'incscore(1);'.
 */

//INSCR
incscore: function( amount )
{
    global.score += amount;
    scoreStatus();
#ifdef SCORE_NOTIFIER
    notify2(amount);
#endif
}

#ifdef TIME_SCORE
timeVerb: sysverb
        verb = 'time' 't'
        printtime =
        {
                say(global.hour); ":";
                if ( global.minute > 9 ) say(global.minute);
                else { "0"; say(global.minute); }
                if ( global.isAM ) " a.m.\ on ";
                else " p.m.\ on ";
                say( global.daylist[global.day]);
        }
        action(actor) = 
        {
                "The time is now ";
                self.printtime;
                abort;
        }
;

modify global
    hour = 9    // the default starting hour
    minute = 00  // the default starting minute
    isAM = true  // it is the afternoon, not the morning
    day = 1  // the default starting day
    daylist = [ 'Monday' 'Tuesday' 'Wednesday' 'Thursday' 'Friday' 'Saturday'
	'Sunday' ]
;

replace turncount: function(parm)
{
    incturn();
    inctime();
    global.turnsofar += 1;
    scoreStatus();
}

/* 
 *     This function is used to change the time. Each turn, you need to
 *     call this at least once to change the time. The timeinc is always
 *     in minutes. If you need anything to change depending on the time 
 *     spent you need to either make it a daemon or alter this function to
 *     change it whenever it is called. For example, awakeTime is changed
 *     accordingly here. Warning: It isn't safe to call scoreStatus with
 *     anything but 0 or 1 as an argument. Otherwise, it will mess up the
 *     daemons and fuses.
 */
inctime: function
{
  global.minute += 1;
  if ( global.minute > 59 ) 
  {
    global.minute := global.minute - 60;
    global.hour := global.hour + 1;
    if ( global.hour = 12 )
    if ( global.isAM ) 
      global.isAM := nil;
    else 
    {
      global.isAM := true;
      global.day += 1;
      if (global.day > 7)
        global.day := 1;
    }
    if ( global.hour > 12)
    {
      global.hour -= 12;
    }
  }
}
#endif

/*
 *   The scoreRank() function displays how well the player is doing.
 *   This default definition doesn't do anything aside from displaying
 *   the current and maximum scores.  Some game designers like to
 *   provide a ranking that goes with various scores ("Novice Adventurer,"
 *   "Expert," and so forth); this is the place to do so if desired.
 *
 *   Note that "global.maxscore" defines the maximum number of points
 *   possible in the game; change the property in the "global" object
 *   if necessary.
 */

//SCRNK
scoreRank: function
{
#ifdef PERCENT_SCORE
    "In a total of "; say( global.turnsofar );
    " turns, you have achieved a score of ";
    say( global.score ); " points out of a possible ";
    say( global.maxscore ); ".  This means you have completed ";
    say(global.score*(100/global.maxscore));
    "% of the game.\n";
#endif
#ifdef PUZZLE_SCORE
    "In a total of "; say( global.turnsofar );
    " turns, you have solved ";
    say( global.score ); " puzzles out of a possible ";
    say( global.maxscore ); ".\n";
#endif
#ifdef SCORE_SCORE
    "In a total of "; say( global.turnsofar );
    " turns, you have achieved a score of ";
    say( global.score ); " points out of a possible ";
    say( global.maxscore ); ".\n";
#endif
#ifdef SCORE_TURN_SCORE
    "In a total of "; say( global.turnsofar );
    " turns, you have achieved a score of ";
    say( global.score ); " points out of a possible ";
    say( global.maxscore ); ".\n";
#endif
#ifdef TIME_SCORE
    "By "; timeVerb.printtime;
    ", you have achieved a score of ";
    say( global.score ); " points out of a possible ";
    say( global.maxscore ); ".\n";
#endif
#ifdef TURN_SCORE
    "In a total of "; say( global.turnsofar );
    " turns, you have achieved a score of ";
    say( global.score ); " points out of a possible ";
    say( global.maxscore ); ".\n";
#endif
}

/*
 *  scoreStatus: function
 *
 *  This function updates the score on the status line.  This implementation
 *  simply calls the built-in function setscore() with the same information.
 *  The call to setscore() has been isolated in this function to make it
 *  easier to replace with a customized version; to replace the status line
 *  score display, simply replace this routine.
 */

//SCSTS
scoreStatus: function
{
     local amorpm, x;

#ifdef PERCENT_SCORE
  x := 100/global.maxscore;
  x *= global.score;
  setscore('You are '+cvtstr(x)+'% done');
#endif
#ifdef PUZZLE_SCORE
  x := global.maxscore - global.score;
  setscore('Puzzles Remaining: '+cvtstr(x));
#endif
#ifdef SCORE_SCORE
  x := global.score;
  setscore('Score: '+cvtstr(x));
#endif
#ifdef SCORE_TURN_SCORE
  x := global.score;
  setscore('Score: '+cvtstr(x)+' / Turn: '+cvtstr(global.turnsofar));
#endif
#ifdef TIME_SCORE
  if ( global.isAM = true ) amorpm := 'a.m.';
  else amorpm := 'p.m.';
  if (global.minute > 9)
  setscore(global.daylist[global.day]+' '+cvtstr(global.hour)+':'+
    cvtstr(global.minute)+' '+amorpm);
  else
  setscore(global.daylist[global.day]+' '+cvtstr(global.hour)+':0'+
    cvtstr(global.minute)+' '+amorpm);   
#endif
#ifdef TURN_SCORE
  x:= global.turnsofar;
  setscore('Turn: '+cvtstr(x));
#endif
}
