#charset "us-ascii"

#include <adv3.h>
#include <en_us.h>
#include <SquareCircle.h>

// Fields. t

/*
 *  This file contains the other half of the map - the part outside the prison
 *  compound.
 */
 
sun : MultiLoc, Distant 'sun' 'sun'
 desc()
 {
  switch(daylight.time)
  {
    case dusk:
      "The sun is starting to redden as it sinks towards the west. ";
      break;
    default:
      "Staring directly at the sun would be a bad idea -- it could seriously damage your
      eyesight. ";
  }
 }
 initialLocationClass = OutdoorRoom
;

clouds: MultiLoc, Distant 'wispy white spectacular orange cloud/clouds' 'clouds'
  "A few wispy, white clouds float lazily in the distance. <<daylight.time == dusk ?
   'Those to the west, however, are lit a spectacular orange by the rays of the
   setting sun.' : ''>> "
  isPlural = true
  initialLocationClass = OutdoorRoom
;

modify defaultSky
  desc()
  {
    switch(daylight.time)
    {
     case noon:
      "The sky is a deep, clear blue, with just a few wispy white clouds in the
       distance. "; break;
     case dusk:
       "The sky is turning a paler blue, reddening in the west as the sun starts
        to sink to the horizon. "; break; 
     case night:
      "The sky is a deep black, punctured by the myriad points of a galaxy of
        stars. The moon is a thin sliver, nearing the end of its last quarter. "; break;
   }
  }  
;

modify defaultCeiling
  feelDesc()
  {
    if(gActor.location is in (cellBed, desk, guardChair, sandBox) && gActor.posture==standing)
    {
      "It feels pretty solid. ";
    }
    else
      "You can't reach it. ";
  }
;



fieldFence : Unclimbable, defaultSouthWall 
  'south tall solid sturdy wood wooden battered fence/planking' 
   'fence'
  "The fence running along the southern edge of the field is made from solid wooden
   planking; it may look a little battered in places but it's basically sound. "
   cantClimbMsg = 'The fence is too high to climb, and there\'s nowhere to get a 
    handhold or foothold to haul yourself over. '
  sightSize = large
  shouldNotBreakMsg = 'You can\'t; it\'s too sturdy. '
;

+ Component 'solid sturdy wooden weathered plank/planks' 'planks'
  "The wooden planks look weathered but sturdy. "
  isPlural = true
  shouldNotBreakMsg = 'You can\'t break the planks; they\'re too sturdy. '
;

fenceBarrier : NoTravelMessage { "You can't just walk through a solid wooden fence, you know! "}

fieldGateConnector : OneWayRoomConnector   
   destination = smallYard
   noteTraversal(traveler)
   {
     "By standing on <<traveler.location.theName>> you just manage to clamber over 
      the gate into the small yard.<.p><.reveal gate-climbed-again>";
   }
   canTravelerPass (traveler) 
   {
     return traveler.location.ofKind(Platform);
   }
   explainTravelBarrier (traveler) 
   {
     "The gate is just too high too climb over. ";
   }
;

fieldNorthWall : RoomPart 'north n wall*walls' 'north wall'
   "It's a high concrete wall with a tall rusty gate in it. "
   cannotClimbMsg = 'It doesn\'t look too easy to climb, and besides, there\'s
     a perfectly good gate. '
;

field : OutdoorRoom 'Field by Gate' 'the field, by the gate'
  "This is the small northern arm of a large L-shaped field, the bulk of which lies to
   the south. Directly to the east lies a dense forest, while a gate in the wall to the north
   leads into a small yard. Immediately to the west is the blank wall of the prison
   building. "
  travelerArriving(traveler, origin, connector, backConnector)
  {
    inherited(traveler, origin, connector, backConnector);
    achievement.awardPointsOnce();
  }
  achievement : Achievement { +1 "reaching the field" }
  north = fieldGate  
  south = westField
  west : NoTravelMessage { "There's a building in the way. " }
  east : NoTravelMessage { "The combination of densely packed trees and heavy
    undergrowth makes the forest impenetrable at this point, but it may be
    enterable elsewhere. " }
  roomParts = static(inherited + fieldNorthWall )  
;

+ fieldGate : RustyFieldGate 'tall iron black rusty gate' 'rusty gate'
  "The gate, which is about six feet high, is made of rusty iron, from which most of 
   the black paint is peeling off. On the other side of the gate is a small
    enclosed yard. "
    dobjFor(Climb)
    {
      verify() {}
      action()
      {
        replaceAction(TravelVia, fieldGateConnector);
      }
    }   
  thruDesc {
    if(gActor.isIn(field))
      "Through the gate a small courtyard can be seen. ";
    else
      "{You/he} can't really look through it from here. ";    
  }
  dobjFor(Pull) asDobjFor(Open)
  dobjFor(Push) asDobjFor(Close)
  makeOpen(stat)
  {
    inherited(stat);
    if(stat)
       hasBeenOpened = true;
  }
  hasBeenOpened = nil
  shouldNotBreak = 'Despite your best efforts, it proves to be too robust. '
;

++ Component 'peeling (black) paint' 'black paint'
  "The black paint is starting to peel off the gate, revealing quite a bit
   of rust beneath. "
;

++ Component 'patches/rust' 'rust'
  "Several patches of rust can be seen on the gate where the paint has peeled
   away. The gate itself still looks pretty sound, however."
;

++ rustyFieldLock : RestrictedContainer, Component 'lock/keyhole' 'lock'
   "The lock is not so rusted that it shouldn't work; from the size of the 
    keyhole it's obviously meant to take a fairly substantial key. "
    validContents = [ironKey, filedIronKey]
    dobjFor(Pick)
    {
      verify() {}
      action() { "You don't know how to. "; }
    }
;



+ fieldWestWall : Fixture 
   'east e west w blank concrete prison face/side/building/wall*walls' 'prison building'
  "The east face of the single-storey prison building is simply a blank concrete wall,
   featureless apart from a black steel drainpipe. "
   dobjFor(Climb) remapTo(Climb, drainpipe);
;



++ drainpipe : StairwayUp 'vertical black steel drain pipe/drainpipe/tube' 'drainpipe'
  "It's just a vertical black tube running down the side of the building. "
  noteTraversal(traveler)
  {
    "Almost to your own surprise, you manage to haul yourself up the drainpipe to
     the roof. ";
     field.up = self;
  }
  cannotMoveMsg = 'It seems to be very firmly attached to the wall; however hard you
   try to ' + gVerbName + ' the pipe, it budges not at all. '
  travelBarrier = [pipePushTravelBarrier]
;

+ Fixture 'dense impenetrable forest/barrier' 'dense forest'
  "The dense forest runs up to the eastern edge of the field, effectively forming an 
  impenetrable barrier. In the distance you can see the forest climbing a hill to
  the northeast. "  
  cannotEnterMsg = 'The forest is quite impenetrable at this point. '  
  sightSize = large
;

++ Distant 'impenetrable tree/trees/barrier' 'trees'
  "As one might expect, there are many trees in the forest -- but from here they
   all seem to merge into one another, forming a seemingly impenetrable barrier. "
   isPlural = true
   sightSize = large
;

+ Distant '(upper) distant (green) hill/slopes/fields' 'distant hill'
  "Quite some way to the northeast the forest starts to climb up a hillside that
  slopes up to the north; the climb eventually proves too much for it, since the
  upper slopes are green fields, bare of trees. "
  sightSize = large
;

pipePushTravelBarrier : PushTravelBarrier  

;

MultiLoc, Decoration 'green grass' 'grass'
  "It's all over the field, and it's green. "
  dobjFor(Eat) {
    verify() { illogical('You\'re not a horse or a cow! '); }
  }
  locationList = [westField, field]
;


westField : OutdoorRoom 'Open Field' 'the open field'
  "A tall wooden fence runs along the southern edge of the field, while a major
   road runs along its western boundary. A smaller section of this L-shaped
   field lies just to the north, on the east side of the prison block. 
   Directly to the east lies a large forest; although the trees are quite densely
   packed, there <<forestPath.seen ? 'is' : 'may be'>> a path. "
   north = field
   south = fenceBarrier   
   west = road
   east = forestPath
   northWest : NoTravelMessage { "The prison block is in the way. " }
   roomParts = static (inherited + fieldFence)
;

+ PathPassage 'path' 'path'
  "A closer examination reveals that there is, indeed, a path running
   east into the forest. "
   destination = forestPath
;

+ Fixture 'back featureless concrete prison block north n slab/concrete/wall*walls' 
   'prison block'
  "The back wall of the prison block, little more than a featureless slab of
   concrete, abuts part of the northern edge of the field. "
   cannotClimbMsg = 'There seems to be no way to climb it from here. '
;

+ westFieldForest : Distant 'large dense forest/trees' 'forest'
  "The forest lying to the east looks pretty dense, but there seems to be
   a path leading through the trees. <<blueCoveralls.wornBy == gPlayerChar
   ? 'Right now, the forest looks like it might provide your best chance
   of refuge.' : '' >> "
   dobjFor(Enter) remapTo(East)   
;

+ Enterable ->road 'major road' 'road'
  "The road runs north-south along the western boundary of the field. "
  sightSize = large
;

+ trough :  ComplexContainer, TravelPushable, Platform 'old wooden feeding trough' 
   'feeding trough'
   "It's an old wooden feeding trough. "
   initSpecialDesc = "An old feeding trough lies abandoned by the fence. "
   specialDesc = "An old wooden trough rests just next to the gate. "
   remoteInitSpecialDesc(pov) 
   { "An old feeding trough lies by the fence running along the southern boundary
      of the field. "; }
   remoteSpecialDesc(pov) { "An old wooden trough rests near the rusty gate
     between the field and the small yard. "; }
   specialDescOrder = 10
   cannotTakeMsg = 'It\'s too heavy to lift. '
   useSpecialDesc { return isDirectlyIn(field) || useInitSpecialDesc; }
   subContainer: ComplexComponent, Container {  }
   subSurface: ComplexComponent, Surface {  }
   movePushable(traveler, connector)
   {
     inherited(traveler, connector);
     pig.afterPushTravel(traveler.location);
   }
   describeMovePushable(traveler, connector)
     { 
         if (gActor.isPlayerChar){
           "<.p>You push <<theName>> <<location == bridge ? 'o' : 'i'>>nto <<location.destName>>";
           if(location == field) {
            ", and up against the gate";
           }
           ". ";
         }  
     }
    beforeMovePushable(traveler, connector, dest) 
    {
    inherited(traveler, connector, dest);
    "{You/he} push{es} the trough out of <<traveler.location.destName>>. ";
    } 
   actionDobjExamine()
   {
     foreach(local cur in subContainer.contents)
       if(cur.ofKind(Hidden)) cur.discover;
     inherited;
   }
   allowedPostures = [sitting, standing]
   obviousPostures = [sitting, standing]
   cannotLieOnMsg = '{You/he} can\'t exactly lie <i>on</i> the trough, and it\'s
    certainly not something {it actor/he} want{s} to lie <i>in</i>. '
   bulk = 20
   weight = 30 
;

++ hat : Hidden, Wearable, Container 
   'battered crumpled greyish brown greyish-brown floppy shapeless broad round old hat/brim'
   'battered old hat'
   "Greyish-bown in colour, the old hat has almost been crumpled into shapelessness;
    it was once a floppy round hat with a broad brim. "
   initDesc()
   {
     desc;
     if(oldClothes.wornBy == gPlayerChar)
       "If nothing else, it would be in keeping with the tatty old clothes you\'re
        wearing. ";
   }
   location = trough.subContainer
   bulkCapacity = 2
   bulk = 2
   dobjFor(Wear)
   {
     action()
     {
       "You put the hat firmly on your head and pull its brim down over your face. ";
       isOpen = nil;
       inherited;
     }
   }
   dobjFor(Doff)
   {
     action()
     {
       inherited;
       isOpen = true;
     }
   }
   iobjFor(PutIn)
   {
     preCond = static(inherited + objNotWorn)
     check() {
       if(gDobj == sand || gDobj.ofKind(Sand))
       {
         reportFailure('You really don\'t want to do that -- it\'ll be so messy
          when you come to wear it! ');
          exit;
       }
     }
   } 
   dobjFor(Take)
   {
     action()
     {
       inherited;
       achievement.awardPointsOnce();
     }
   }  
   dobjFor(FillWith) remapTo(PutIn, IndirectObject, self)
   iobjFor(PutUnder)
   {
     preCond = [objHeld, objNotWorn]
     verify() {  }
     action() {       
       nestedAction(PutIn, gDobj, self);
       if(gDobj.isIn(self))
       {
         "{You/he} put{s} {the dobj/him} in the hat. ";
         if(gDobj == gAction.dobjList_[gAction.dobjList_.length].obj_)
         nestedAction(Wear, self);
       }
     }
   }
   achievement : Achievement { +1 "acquiring the hat. " } 
   isObviousContainer = nil 
   sightSize = small 
;

++ boots : Hidden, Wearable, Container 'old green rubber thick wellington pair/boots/wellies/soles/boot' 
   'old boots'
  "They're a pair of old, green Wellington boots, with thick rubber soles. "
  initDesc()
  {
    desc;
    "They look like they might fit you, and though they\'re far from elegant, they have
     to be better that going round in bare feet. ";
  }
  location = trough.subContainer
  isPlural = true
  aName = ('a pair of ' + name)
  sightSize = small
  dobjFor(Wear)
  {
    action()
    {
      inherited;
      if(contents.length > 0)
        extraReport('There\'s something inside them that makes them feel
         rather uncomfortable. ' );
      isOpen = nil;
    }
  }
  dobjFor(Doff)
  {
    action()
    {
      inherited;
      isOpen = true;
    }
  }
  cannotMoveThroughContainerMsg(obj, cont)
  {
     gMessageParams(obj, cont);
     return '{You/he} can\'t put {that obj/him} in the boots while you\'re wearing them;
      they fit too tight. ';
  }

  bulkCapacity = 2
  maxSingleBulk = 1
  bulk = 4
  weight = 2
  isObviousContainer = nil
;



class ForestRoom : OutdoorRoom

  cannotGoMsg = 'The trees are too densely packed in that direction. '
  atmosphereList = forestAtmosphere
  private = true
;

forestAtmosphere : ShuffledEventList
  [
    'There\'s a rustling sound from somewhere among the trees. ',
    'A squirrel dashes up a tree and disappears out of sight. ',
    'A deer leaps across the path, and darts off among the trees in an instant. ',
    'A pair of rabbits hop quickly out of sight. ',
    'A pair of birds take flight somewhere to the left. ',
    'A fox darts among the trees -- and then he\'s gone. ',
    'From off to the right comes the distant cooing of a dove. ',
    'Somewhere in the distance a crow lets out a raucous cry. ',
    'You catch a fleeting glimpse of a fieldmouse, before it vanishes once 
     more into the undergrowth. ',
    'A squirrel dashes across the path, chased by a fox -- then both are gone. ',
    'A small furry animal darts away, too fast for it to be identifiable. ',
    'Something flies overhead and disappears through the leafy canopy. '
  ]
  eventPercent = 50
  eventReduceAfter = 10
  eventReduceTo = 30 
;

forestSounds: MultiLoc, SimpleNoise 'forest sounds/noises/birdsong/rustling/ccoing' 'sounds'
  "The forest sounds are subtle, so much so that at first you hardly hear them.
   But they are there -- distant birdsong in the trees, the light rustling of
   leaves and branches caught by an occasional breeze, the sudden rustling in the
   undergrowth as some small animal scurries about out of sight. It is peaceful here 
   -- but not absolutely silent. "
  isPlural = true
  initialLocationClass = ForestRoom
;

forestSmells : MultiLoc, SimpleOdor 'forest damp smells/odours/odors/odor/odour' 'smells'
  "Damp earth, fresh leaves, cool air, just a hint of mustiness. 
   There's nothing overpowering here, but it's far from antisceptic and sterile. "
  isPlural = true
  initialLocationClass = ForestRoom 
;


MultiInstance
  initialLocationClass = ForestRoom
  instanceObject : Fixture {
    '(ancient) (majestic) (tall) gloomy dense (spreading) forest/tree/trees/oaks/elms/chestnuts/oak/elm/chestnut' 'trees'
    "Many of the trees here seem ancient: majestic oaks, tall elms, spreading chestnuts. 
     There are rows of them whichever way you look, but never straight rows;
     these trees conform to some order of their own making, not that of human
     ideals of rational regulation. Overhead the branches intertwine to form a canopy of leaves,
     softening the light and sheltering the forest from the outside world. "
    isPlural = true
    cannotClimbMsg = 'Some of the trees are indeed probably climbable -- but only by
     someone fitter and more athletic than yourself. '
    cannotTakeMsg = 'Many of these trees were old before you were born, and most of them
     will still be here when you\'re nothing more than nourishment for their roots: show
     some respect and leave them alone. '
    cannotMoveMsg = (cannotTakeMsg)
    dobjFor(ListenTo) remapTo(ListenTo, forestSounds)
    dobjFor(Smell) remapTo(Smell, forestSmells)
  }
;

MultiInstance
  initialLocationClass = ForestRoom
  instanceObject : Decoration {
    'green twisted leafy canopy/leaf/leaves/branches/twigs/twig/branch' 'leaves'
    "In sundry shades of summer green -- no hint of autumn yet -- the leaves adorning
     the branches around and above
     come in a plethora of shapes and sizes: but no squares, no circles, no nice neat
     regular geometrical shapes. Fractal-complex, these leaves
     defy description in simple terms, as do the twisted twigs and branches that
     bear them. "
    isPlural = true
    notImportantMsg = 'You\'d rather leave them alone. '
  }
;

MultiInstance
 initialLocationClass = ForestRoom
  instanceObject : Decoration {
    'damp earth' 'earth'
    "The earth underfoot is still a little damp from recent rainfall, the shade of
     the leaves above slowing the process of drying. "
    notImportantMsg = 'It\'s best left on the ground. '  
    smellDesc = "A little damp, slightly bitter. "  
    soundDesc = "Your hearing is not acute enough to detect the burrowing of
     earthworms, if that's what you had in mind. "
  } 
;

MultiInstance
 initialLocationClass = ForestRoom
  instanceObject : Decoration {
    'tall tufts/undergrowth/grass/saplings/moss/ferns/weeds' 'undergrowth'
    "The undergrowth, mainly comprising tufts of tall grass, moss, ferns, weeds and the
     occasional sapling, covers most of the ground between the trees away from
     the path. "
    notImportantMsg = 'That\'s where the forest creatures feed and frolic -- leave
     it be. '  
    soundDesc = "Occasional rustlings can be heard, as small animals scamper about
      unseen. "
    smellDesc = "A strange mixture of smells, some fresh and some rotting vegetation. "  
  } 
;

MultiInstance
 initialLocationClass = ForestRoom
  instanceObject : MultiName, Unthing {
    vocabWords = 'small (forest) pair/animals/foxes/birds/rabbits/creatures/squirrels/mice
    /fieldmice' 
    nonHereMsg = 'They\'re not in sight. '
    isPlural = true
    defaultName = 'animals'
  } 
;

MultiInstance
 initialLocationClass = ForestRoom
  instanceObject : MultiName, Unthing {
    vocabWords = 'small furry (forest) animal/fox/bird/rabbit/creature/deer/squirrel/mouse/
    fieldmouse/crow/dove' 
    notHereMsg = '{The dobj/he} is not in sight. '
    defaultName = 'creature'
  } 
  
;


forestPath : ForestRoom 'Forest Path' 'the forest path'
  "This narrow path runs for quite a while through the dense forest,
   twisting from side to side round the trees, but broadly running from east
   to west. About halfway along the path, a second path runs
   off to the north. <<firstVisit()>> "
   firstVisit()
   {
     if(!visited)
     {
       "It feels strangely refreshing to have reached somewhere so clearly unconstrained 
        by the sterile geometry of straight lines, squares and circles. ";
       visited = true;
     }     
   }
   visited = nil
   vocabWords = 'main forest path*paths' 
   west = westField
   east = forestClearing
   north : TravelMessage {
     -> forestPathJunction
      "The path starts running north, but keeps bending round to the right until
       it ends up heading east and joins a second path.<.p>"
   }
   travelBarrier : PushTravelBarrier {
     explainTravelBarrier(traveler)
     {
         "That would push <<traveler.obj_.theName>> into the forest;
          the muddy forest paths don't look suitable for pushing 
         <<traveler.obj_.theName>> along, so you'd best leave it here. ";
     }
   }  
   private = true    
;

+ PathPassage 'second north n path*paths' 'second path'
  "The second path runs off to the north; it's impossible to see where it
   goes to from here, as it rapidly disappears into the trees, but it looks
   like it bends round to the right. "
  dobjFor(TravelVia) remapTo(North)
;


forestPathJunction : ForestRoom 'Forest Path Junction' 'the forest path junction'
   "Shaded from the sun, the main track running east and west bends through
    the trees. A narrower but brighter track slopes up towards the north. "
   east = forestClearing
   west = forestPath
   north : TravelMessage {
      -> hill
      "The leaf-strewn path climbs gently through the trees for quite a while, and finally
       emerges onto a grassy hillside. "
       }
   up asExit(north) 
   private = true   
;

+ acorns : Thing 'small round brown handful/acorn/acorns' 'acorns'
  "They're small, round and brown. "
  isPlural = true
  initSpecialDesc = "A handful of acorns lies scattered on the ground, freshly fallen from
   the trees. "
  cannotEatMsg = 'These acorns are not fit for human consumption. '
  smellDesc = "They have a faint woody, nutty smell. "
  newLocation {
    switch(locCount++)
    {
      case 0: return forestPath;
      case 1: return forestClearing;
      case 2: return smallClearing;
      default: return rand(forestPathJunction, forestClearing,
                forestPath, smallClearing);
        
    }
  }
  locCount = 0
  sightSize = small
;

+ PathPassage  
  'narrow narrower sloping north track/path*tracks paths' 'narrow track to the north'
  "The narrow track slopes up through the trees, until it disappears to the north. "
  actionDobjTravelVia() { replaceAction(North); }
;  

+ PathPassage 'main relatively broad track/path*tracks paths' 'main track'
  "The main, relatively broad, track runs east and west from here, though it
  is apparent that both arms of the track start to bend towards the north some
  way off. "
  dobjFor(TravelVia)
  {
    verify() {}
    action() {
      "The main track runs east and west from here: which way do you want to go? ";
    }
  }  
;

hill : OutdoorRoom 'Hillside' 'the hillside'
  "This side of the hill slopes sharply down to north and west and commands an
   excellent view of the valley in both these directions: in the distance to the northwest 
   a road bends round an ugly concrete compound and continues past a tall, white building and
   some kind of checkpoint, before disappearing out of sight towards the east. The south 
   slope is more gentle, and quickly becomes heavily wooded, but there is a path running
   through the trees directly to the south. To the east, the hill rises briskly towards its
   summit. "
   south = forestPathJunction
   down asExit(south)
   cannotGoMsg = 'The descent is too steep that way. '
   southwest : NoTravelMessage { "The only path through the trees is directly south. " }
   southeast asExit(southwest)
   east = toSummit
   northeast asExit(east)
   up asExit(east)
   vocabWords = 'hill/hillside'
   dobjFor(LookIn) asDobjFor(Examine)
;

+ PathPassage 'path' 'path'
  "Some way to the south a path leads back down the hillside through the trees. "
  dobjFor(TravelVia) remapTo(South)
;

+ Decoration 'trees' 'trees'
  "The trees form a ragged line a little way down the hillside to the south. "
  isPlural = true
;

+ Decoration 'leftover scraps/crumbs/leftovers/remains/picnic' 'scraps'
  "They look like the remains of somebody's picnic; something about them
   stirs a memory that won't quite come to the fore. "
  initSpecialDesc()
   { 
    if(described)
      "The remains of someone's picnic lie scattered on the hillside. ";
    else
     "In the middle of the grassy hillside lie some leftover scraps. ";
   }
  specialDescOrder = 0
  isPlural = true
  notImportantMsg = 'The pathetic remains of the picnic are too scattered,
   too fragmentary, too scrappy to be worth trying to do much with; there\'s
   something painfully familiar about them, but it doesn\'t seem likely that
   they contain any answers. '
;

+ paperScrap : Readable, DrawingSurface 'small little white scrap/paper' 'scrap of paper'
  "It's a scrap of white paper, with some handwriting on it. "
  initSpecialDesc = "A small scrap of paper is being blown hither and thither across the
   hillside by the occasional gust of wind. "
  dobjFor(Read)
  {
    preCond = static inherited + objHeld;
  }
  dobjFor(Take)
  {
    check()    
    {
      if(!moved && !netStick.isHeldBy(gActor))
      {
        blownList.doScript;      
        exit;
      }
    }
    action()
    {
      if(!moved && netStick.isHeldBy(gActor))
        replaceAction(TakeWith, self, netStick);
      else
       inherited;
    }
  }
  
  blownList : ShuffledEventList {
   [
     'Just as {you/he} {is} about to take the scrap of paper, a chance
      gust of wind blows it just beyond your reach.<.reveal scrap-blown> ',
      
     'The pesky scrap of paper evades your grasp again; if only you had
      something to catch it with! ',
      
     'You almost wonder if the elements are in league with the authorities,
      for yet again the breeze catches the scrap of paper and sends it
      scudding across the field. ',
      
     'This is getting silly, you realize; you\'re plainly not going to trap
      that wretched scrap with your bare hands, so if you really want it
      you\'re going to have to find something to help you catch it. '
   ]
   [
     'Another gust of wind blows the scrap just beyond your reach just before
       you fingers can close on it. ',
       
     'You walk briskly towards the scrap of paper, but the winds blows it
      back across the hillside before you can reach it. ',
      
     'Once again the wind blows it just beyond your grasp. ',
     
     'It seems even the elements are conspiring against you today, for as
      your fingers are about to close on the small scrap of paper, a
      chance gust once again sends it scudding across the hillside. ',
      
     'Damn that breeze! Once again the little scrap of paper is blown away
      from you as you chase after it in vain. ',
      
     'Oh the unbelievably perfidious perversity of inanimate objects! Yet
      again that wretched little scrap of paper is snatched from your
      imminent grasp by a freak puff of wind. '    
   ]
  }
  
  throwHitFallMsg(projectile, target, dest)
  {
    if(moved)
      return playerActionMessages.throwHitFallMsg(projectile, target, dest);
    else
      return 'A gust of wind blows the scrap aside, so that
       {the dobj/he} misses and falls futiley to
       the ground. ';
  }
  readDesc = "The paper is crumpled and torn, and the writing is
  frustratingly smudged in places, but you manage to make out a few
    handwritten words:\b
   <q>We'll meet to discuss this, my l[...], at our fa[...]\n   
   Your <u>Square Circle</u> idea is great, but won't they [...]\n   
   If they think you're [...]ing the New En[...]\n
   They can be <u>far</u> more da[...]\n
   Dunderhead and his [...] will s[...] no[...]</q><.p>
   Something about the handwriting strikes you as familiar, but you can't
   quite decide what.<<achieve>><.reveal scrappy-text>
   <<gRevealed('paper-scrap') ? 'The words also start to look familiar; you\'re
    pretty certain that the way {the hermit/he} filled in the blanks for you
    was totally wrong, and although you can\'t be absolutely sure that you\'ve
    got it right, you feel strangely convinced that what the writing actually
    says is:\b
   <q>We\'ll meet to discuss this, my love, at our favourite spot. Your
    <u>Square Circle</u> idea is great, but won\'t they hate you for it?
    If they think you\'re opposing the New Englightenment, they won\'t forgive
    you. They can be <u>far</u> more dangerous than you can ever imagine.
    Dunderhead and his friends will stop at nothing to neutralise you.</q>\b
    You stare at the scrap again, wondering how you can feel so confident about
    this reconstruction<.reveal blanks-filled>' : 
    'There\'s also something tantalisingly familiar
    about the message, as if your memory only needs the smallest jolt for
    it to be able to fill in the blanks' >>. "
  achievement : Achievement { +1 "capturing and reading the scrap of paper. "}
  achieve() { achievement.awardPointsOnce(); }
  sightSize = small
;

++ Component 'handwriting/writing' 'handwriting'
   dobjFor(Examine) remapTo(Read, paperScrap)
   dobjFor(Read) remapTo(Read, paperScrap)
;

+ Distant 'road/bend' 'road'
  "To the west, the road runs between a high hedgerow and an open field before disappearing
   over a bridge to the south. To the northwest the road bends sharply round to the east,
   and runs through some kind of park to a checkpoint, before continuing eastwards out
   of sight behind the hill. "
;

+ Distant 'tall white building' 'tall white building'
  "The white building is the most conspicuous structure in sight, if only because it is
   the largest. Eight to ten stories high, it juts out of the landscape like an accusing
   finger pointing to an empty sky. "
;

+ Distant 'park/lawn/avenue' 'park'
  "The space between the sharp bend in the road and the checkpoint seems carefully laid out.
   A tall white building stands in a geometrically neat little garden, while a little further
   to the west a drive runs southwards from the road through a broad avenue of trees to
   an ugly concrete compound. Otherwise, the park is mainly flat, fresh-green lawn. "
;

+ Distant 'bridge/river' 'bridge'
  "The old stone bridge bearing the south road crosses a broad river flowing to the east.
  In places, it looks like the river has burst its banks. "
;  

+ Distant 'pole checkpoint/barrier/hut' 'checkpoint'
  "About fifty yards east of where it runs past the tall white building, the road is
   blocked by a red-and-white pole barrier, next to which is a guard hut. A pair
   of ant-like figures are on guard at the barrier, checking all the traffic that
   wants to pass through -- though there does not seem to be much. "
;

+ Distant 'ugly concrete compound' 'ugly concrete compound'
   "A mean, single storey building squats between the avenue leading from the road
    and a meadow. No windows are visible in it anywhere; it has all the charm of a
    concrete blockhouse. "
;

+ Distant 'valley' 'valley'
  "The valley stretches out below: in the distance to the northwest 
   a road bends round an ugly concrete compound and continues past a tall, white building and
   some kind of checkpoint, before disappearing out of sight towards the east."
;

+ Distant 'ant-like figures' 'figures'
  "From this distance they have no individuality at all, you can't even be sure whether
   they're men or women (though you suspect that they're the former). It looks
   like they have a pretty dull job, standing by the pole, but at least it's decent
   weather for being stuck outside not doing very much. "
  isPlural = true
;

+ Distant 'traffic' 'traffic'
  "The traffic is surprisingly sparse. Perhaps it's because this isn't an area that's
   all that welcoming to visitors<<warningSign.described ? ', or it may just be that
    the damaged bridge has cut off the road' : ''>>. "
  isMassNoun = true
;

+ Distant 'high hedgerow/hedge' 'hegrerow'
  "The hedgerow is too far away to make out much detail, beyond the fact that
   it runs alongside the west side of the road leading to the bridge. "
;

+ Distant 'open l-shaped field' 'open field'
  "The field is L-shaped, with a short stubby spur running round the near side
   of the compound. The main part of the field lies to the south of the compound
   and the east of the road that runs to the bridge. "
;

+ toSummit : StairwayUp 'summit' 'summit'
  "The summit is a couple of hundred yards up to the east. "  
  dobjFor(Enter) asDobjFor(TravelVia)
  noteTraversal(traveler) { "You climb up the long slope to the summit. "; }
;

summitGround : defaultGround 
  'grassy patch grass/ground/soil/earth/mud' 'ground'   
   desc()
   {
    "Some footprints are embedded deep in the earth, while 
     furrows scored across the grass suggest that something heavy has
     recently been dragged from here. ";
     if(!cartridgeCase.discovered)
     {
       cartridgeCase.discover;
       cartridgeCase.initSpecialDesc;
     }
   }
   dobjFor(LookIn) asDobjFor(Examine)
;

+ Container, Fixture 'parallel furrow*furrows' 'furrows'
  "The parallel furrows scored into the grassy soil look like they
   have been made recently, perhaps by someone dragging something like a
   human body away from this spot. "
  isPlural = true
  notFollowableMsg = 'The furrows don\'t run all that far, but they
   appear to lead back down the hill. '
;

++ cartridgeCase : Hidden 'small brass brassy shell cartridge object/case/casing' 
   'cartridge case'
   "It's a small brass cartridge case, perhaps fired from a semi-automatic
     weapon. "
  initSpecialDesc = "A small brassy object lies in one of the furrows. "
  sightSize = small
  inflammable = nil
;

+ Decoration '(foot) footprints/prints' 'footprints'
  "There are several sets of footprints, rather muddled up together, so that it's
   hard to distinguish one from another. About the only thing you can glean from
   them is that several people have recently trampled this particular patch of
   mud. "
   isPlural = true
   dobjFor(Follow)
   {
     verify() {}
     action() {
       "The footprints are rather confused, and don't really extend beyond the muddy
        furrows, so {you/he} can't really follow them; but the only way they could
        lead is back down the hill. ";
     }
   }
;

summit : OutdoorRoom 'summit' 'the summit'
  "At first sight this is a beautiful, tranquil spot, overlooking the countryside
   for miles around. And yet the ground looks recently churned up. To the south the
   slope is heavily wooded, to north and east it falls away sharply, but there's
   a gentler slope down to the west. "
  down = toHill
  west asExit(down)
  atmosphereList : EventList {
  [
    'You are struck by a sense of sudden familiarity here, but the feeling is
     one of shock and sadness. ',
    'You are convinced that something deeply sad and violent happened here
     recently, but you can\'t quite recall what. ',
    'For a moment, a face flashes into your mind, and for that moment you
     almost recognize it; but then it is gone, with
     an agonizing sense of loss. '  
  ]
  }
  roomParts = static inherited - defaultGround + summitGround 
;

+ Distant 'countryside/scenery/view' 'countryside'
  "To north and east the countryside rolls lazily towards the horizon,
   a misleadingly tranquil view, perhaps. "
;

+ toHill : StairwayDown -> toSummit 'gentler slope' 'slope'
  "The only easily negotiable slope is that inclining gently down the hillside
   to the west. "
  noteTraversal(traveler) { "You walk slowly back down the slope. "; } 
;

forestClearing : ForestRoom 'Large Forest Clearing' 'the large forest clearing'
   "The narrow path from the west comes to the end in this large forest clearing,
    at the centre of which stands a large but rather shabby-looking wooden hut. 
    Other paths snake off through the trees to the southeast, northwest and northeast. "
   west = forestPath
   northeast : OneWayRoomConnector { 
     ->(gRevealed('secret-path') ? escapeRoom : forestClearing)
      noteTraversal(traveler){
      if(gRevealed('secret-path'))
        "You start off down the path, wandering deeper and deeper into the
        dense forest, but remembering the directions {the hermit/he} gave
        you. After a few minutes you come across the almost hidden, narrow little
        track to the right, so you take it. It duly broadens, turns to the north,
        and comes to a junction of five paths. There you remember to take the
        second path to the right, which you follow for fifteen to twenty
        minutes. Eventually the path broadens, the trees start to thin, and
        after a few more minutes you find yourself at last clear of the forest. ";
      else
       "You start off down the path and find yourself
       wandering deeper and deeper into the dense forest until you lose all sense
       of direction. After fifteen to twenty minutes of increasingly desperate
       blundering about you stumble across a clearing and recognize it as the 
       one from which you started out.<.reveal twisty-paths>" ; } 
     isCircularPassage = true
     getApparentDestination(origin, actor)
     {
       if(escapeRoom.seen)
           return escapeRoom;
       else if(gRevealed('twisty-paths'))
          return dummyDest;
       else
         return nil;
     }  
     dummyDest : Room { destName = 'the twisty forest paths' }
    }
  southeast : TravelMessage {
    ->smallClearing
    "You wander down a narrow forest track for some while, as it slowly
     bends round to the east, and finally comes to a small clearing. "
  } 
  northwest : TravelMessage {
    ->forestPathJunction
    "The path starts northwest through the trees, but gradually turns further and
     further to the left till it ends up running west. "
   }
  in = hutDoorOutside  
  south asExit(in)
  vocabWords = 'large forest clearing'
;
   
+ smallHut : Enterable ->hutDoorOutside 'large wooden shabby shabby-looking tumbledown hut' 'hut'
  "The hut is quite large but rather tumbledown in appearance. There's a couple
   of grimey windows with chipped, and in some places broken, glass, and a few
   wisps of smoke every now and again escape from the solitary chimney. "
;   

++ Distant 'solitary battered stove chimney/pipe/stove-pipe' 'chimney' 
   "A solitary chimney -- little more than a
   battered stove-pipe -- pokes through the roof of the hut. "
;

++ Vaporous 'pale white puffs/smoke' 'smoke'
   "Occasional puffs of pale white smoke can be see wafting out of the chimney. "
;

++ Fixture '(a) dirty chipped broken rotting glass/window*windows frames' 'windows'
  "The windows seem in very poor repair; the glass is dirty, being chipped and broken
   in places, while the frames are rotting. "
  dobjFor(LookThrough)
  {
    verify() {logicalRank(130, 'transparent'); }
    check() {}
    action()
    {
      "You try to peer through the windows, but the glass is so grimey and the
       inside of the hut so gloomy that you make virually nothing out. ";
    }  
  }
;

++ hutDoorOutside : Door -> hutDoorInside '(hut) door' 'hut door'
   initiallyOpen = true
   dobjFor(KnockOn)
   {
     verify() { }
     action() {
       "You knock on the door, <<hermit.isIn(insideHut) ? 'and a voice from 
        inside calls, <q>Come in!</q>' : 'but there\'s no response.'>> ";      
     }
   }
;

smallClearing : ForestRoom 'Small Secluded Clearing' 'the small secluded clearing'
  "This small clearing is secluded deep in the forest. The main path, such as it is,
   runs east and west, but there is also a narrow path running south. "
   west = forestClearing   
   east : TravelMessage { 
    -> smallClearing
    "<<lexicalParent.breakStick>>You follow the path for a while, but it quickly
    becomes narrower and narrower and increasingly overgrown, until the combination
    of branches across your path and thick undergrowth snagging your legs 
    makes further progress too difficult; so you eventually give up
    and turn back.<.reveal smallClearing-path>"
    isCircularPassage = true 
    
     getApparentDestination(origin, actor)
    {
       if(gRevealed('smallClearing-path'))
          return dummyDest;
       else
         return nil;
    }  
     dummyDest : Room { destName = 'the narrow forest path' }
  }
  south = pathToRiverBank      
  private = true
  breakStick()
  {     
    if(!stick.brokenOff) 
    {
      "A stick grows across the mouth of the path, obstructing your way, 
       so you break it off before proceeding. ";
       stick.makePresent();       
    }
  }
;

+ pathToRiverBank : PathPassage 'narrow path*paths' 'narrow path'
  "The narrow path disappears southwards through the trees. "
  dobjFor(Follow) asDobjFor(TravelVia)
  noteTraversal(traveler)
  {
    "You set off southwards down the narrow path; the further you go, the
     soggier it becomes underfoot, the mud squelching <<boots.isWornBy(gPlayerChar) ?
     'over your boots' : 'between your toes'>> till eventually further progress south
     is blocked at the bank of a swollen river.<.p>";
  }
;

+ Fixture 'main path*paths' 'main path'
  "The main path (a purely relative term) runs east and west from here. "
  dobjFor(Take) asDobjFor(TravelVia)
  dobjFor(Follow) asDobjFor(TravelVia)
  dobjFor(TravelVia){
    verify() {}
    action() {
      desc; "Which way do you want to go? ";
    }
  }
;

+ stick : Attachable, PresentLater, Thing 
  'reasonably freshly broken-off stout old stick' 'stick'
  "It's a reasonably stout old stick. "
  initSpecialDesc = "A freshly broken-off stick lies across the mouth of the path leading east. "
  brokenOff = nil
  makePresent()
  {
    inherited;
    brokenOff = true;
    moved = nil;
  }
  sightSize = small
  bulk = 3
;


muddyGround : defaultGround 'soggy waterlogged ground/mud' 'ground'
  "The ground underfoot is soggy mud; just to the south it is completely waterlogged. "
;  


riverBank : ForestRoom 'Riverbank' 'the riverbank'
  "The path from the north comes to the end at the bank of a swollen river. Had the
  river not been in flood there may have been other paths from here, but as it
  is the only way is back through the trees to the north. Water sloshes across the
  path and <<boots.isWornBy(gPlayerChar) ? 'round your boots' : 'over your bare feet'>>. 
  Across the river to the south an open meadow stretches invitingly, 
  but there is no way of reaching it. "
  north = pathFromRiver  
  roomParts = [muddyGround, defaultSky]
  cannotGoMsg = 'The swollen waters of the river make it impossible to go that way. '
  swimDesc = "The cold, fast-flowing waters of the swollen river look deeply uninviting;
   besides, you're not at all sure you ever learned to swim. "
;

+ river : Disposer, Fixture '(present) cold fast-flowing swollen river/flood/water/flooding/waters' 
  'river'
  "Presumably there must have been a lot of heavy rainfall recently, since the river
   has burst its banks and flooded this area, submerging any paths there may have
   been along the riverbank. "
   disposalMsg =
     "You toss {the dobj/him} into the river, and it's rapidly carried off
      downstream by the torrent. It's most unlikely that you or 
      anyone else will ever see {it dobj/him} again.<.p>" 
   dobjFor(Drink)
   {
     preCond = [touchObj]
     verify() { logicalRank(140, 'potable'); }
     action() {
       "You cup your hands and drink some of the water from the river, glad to
        find it cool and fresh. ";
     }
   }
   dobjFor(Enter)
   {
     verify() { }
     action() {
       "You really don't fancy trying to wade or swim in those swollen, fast-flowing
        waters. ";
     }
   }

   iobjFor(PourOnto) remapTo(PutIn, DirectObject, self)
   sandFill(obj)
   {
     if(obj.ofKind(Sand))
     {
       "You pour the sand out of <<gDobj.container.theName>> into the water,
        where it quickly disperses. ";
        return true;
     }
     else
        return nil;
   }
   cannotJumpOverMsg = 'It\'s far too wide; you\'d fall in and drown. '
;

+ Distant 'inviting open meadow/pasture' 'meadow'
  "The meadow on the far side of the river looks like open pasture for sheep or cattle,
   though none are in sight. "   
;

+ Decoration '(river) bank/banks/riverbanks' 'riverbanks'
  "The banks of the river are out of sight, submerged by the recent flooding. "
  isPlural = true
;

+ Unthing 'past heavy rainfall' 'heavy rainfall'
  "The past rainfall is a deduction from the present flooding, not something
   that can currently be observed. "
;

+ Unthing 'sheep' 'sheep'
  "There are none in sight -- perhaps they left the meadow to find shelter from the rain. "
  isPlural = true
;

+ Unthing 'cattle/cows/oxen/bulls/kine' 'cattle'
  "There are none in sight, the meadow across the river is deserted. "
  isPlural = true
;

+ pathFromRiver : PathPassage ->pathToRiverBank  '(narrow) path/paths' 'paths'
  "There may have been some paths along the riverbanks, but if so they're now totally
   submerged under the swollen river. The only path you can see is the one leading
   north back into the forest. "   
   dobjFor(Follow) asDobjFor(TravelVia)
   noteTraversal(traveler)
   {
     "You turn away from the river and walk up the narrow path, with the mud
     squelching underfoot and the water still dripping off the surrounding
     trees, until after a short while you arrive back at the small secluded clearing.<.p>";
   }
;

+ net : Attachable, Thing 'old piece/netting/net' 'old net'
  "It looks like it might have come from a fishing net, although the handle has
   broken off. "
  initSpecialDesc = "A piece of old netting is floating in the water near the
    bank. "
  initDesc()
  {
    desc;
    if(gRevealed('scrap-blown'))
      "It could be just the job, and, luckily, it seems to be within reach. ";
  }
  canAttachTo(obj)
  { 
    return(obj == stick);
  }
  handleAttach(other)
  {
    if(other==stick)
    {
      netStick.moveInto(location);
      stick.moveInto(nil);
      net.moveInto(nil);
      "You manage to tie the loose ends of the net to the stick. ";
    }
  }
  iobjFor(TakeWith)
  {
    verify()  { }
    action()
    {       
       "{You/he} almost manage{s} to scoop {the dobj/him} into the net,
        but the floppy old net proves too unwieldy. ";       
    }
  }
  sightSize = small
;


netStick : Container 'old piece/net/netting/stick' 'net'
  "The net is secured reasonably firmly to a stick. "
  bulkCapacity = 1
  iobjFor(TakeWith)
  {
    verify()  { }
    action()
    {
       gDobj.moveInto(self);
       "{You/he} scoop{s} {the dobj/him} into the net. ";
       
    }
  }
  disambigName = 'net tied to a stick'
  bulk = 4
;

hutWestWall : RoomPart 'bare wooden west wall*walls' 'west wall'
  "The west wall of the hut is bare apart from a threadbare rug hung on it. "
;

hutEastWall : RoomPart 'bare wooden south wall*walls' 'east wall'
  "The east wall of the hut is almost completely bare, apart from a small, 
   unglazed window. "
;

+ Component 'small unglazed square window/aperture' 'small window'
  "The small window is little more than a square aperture in the east wall, letting
   in most of the light that illuminates the interior of the hut. A tattered rag
   hanging next to the window is perhaps intended to act as a curtain. "
  dobjFor(LookThrough)
  {  
    verify() { logicalRank(140, 'transparent'); }
    action() { "The window overlooks the clearing. "; }
  }
;

hutNorthWall : RoomPart 'bare wooden north wall*walls' 'north wall'
  "A number of tattered rugs try vainly to cover the north wall of the hut, one of
   them forming the sole covering of the otherwise open doorway. "      
;

hutSouthWall : RoomPart 'bare wooden south wall*walls' 'south wall'
  "The south wall of the hut is decoration with a few faded rugs. "
;
   
insideHut : Room 'Inside the Hut' 'the interior of the hut'
  "The inside of the hut has been made comfortable in a rudimentary kind of way,
  with some tattered rugs hung about the walls to give it a cosier feel, and
  a fire burning away in a primitive stove. The principal items of furniture are a rickety
  chair, an old table, and a plain wooden bench. "
  out = forestClearing 
  north asExit(out) 
  roomParts = [defaultFloor, defaultCeiling, hutNorthWall, hutWestWall, hutEastWall, hutSouthWall]
;   

+ hutDoorInside : Door 'door' 'door'
  initiallyOpen = true
;

+ Heavy, Chair 'plain wooden bench*furniture' 'plain wooden bench'
  "It's just a plain wooden bench, really -- about four feet long and unrelentingly
   uncomfortable to sit on. "
   out = nil
   performEntry(posture)
   {
     inherited(posture);
     if(posture == sitting)
      "{You/he} sit{s} down on the bench and find{s} that it's every bit as
       uncomfortable as it looks. ";
     if(posture == lying)
      "{You/he} just about manage{s} to lie on the bench, with {your/his} feet
        overhanging one end and {your/his} head the other. It\'s exceedingly
        uncomfortable. ";
   }
   allowedPostures = [sitting, lying, standing]
;  
  
+ ricketyChair : Chair 'rickety old upright dark (wood) wooden chair*furniture' 'rickety chair'
  "It's old, upright, and made of some dark wood. "
  isListed = (!hermit.isIn(self))
  cannotPushTravelMsg()
  {
    if(hermit.isIn(self))
      return '<q>Leave it alone, for goodness\'s sake!</q> {the hermit/he} complains. ';
    else
      return 'It\'s the only half-decent chair in the place; it\'s best left where
       it is. ';
  }
  moveToNoEffectMsg() { return cannotPushTravelMsg(); }
;

+ ExitPortal ->forestClearing 'open (north) doorway' 'doorway'
  "The doorway (in the north wall) is covered with a tattered rug. "
;

+ Decoration 'tattered faded threadbare rugs/rug' 'tattered rugs'
  "Some of the rugs are almost threadbare, and all of them are faded, but they do their
   poor best to soften the effect of the otherwise bare wooden walls, and may even
   contribute a little to the thermal insulation of this hovel. "
   isPlural = true
;

+ Decoration 'blazing warm fire/glow' 'fire'
  "The fire sheds a warm glow from the stove. "
   notImportantMsg = 'The fire is blazing away inside the stove; you\'ll burn yourself
    if you try to do anything with it. '
  iobjFor(PutIn) remapTo(PutIn, DirectObject, stove)  
  iobjFor(ThrowAt) remapTo(ThrowAt, DirectObject, stove)   
  iobjFor(BurnWith) remapTo(PutIn, DirectObject, stove)
;

+ stove: Openable, Disposer, Fixture 'large iron crude primitive stove/pipe/cylinder/grating' 'stove'
  "The stove is basically a large iron cylinder connected to a pipe running up
   through the roof. A crude grating contains the fire blazing away inside. "
   disposalMsg = "You put {the dobj/him} into the blazing stove; {it dobj/he} rapidly catch{es}
    alight, blazing away and adding to the warmth of the fire. "
   feelDesc = "It's hot!" 
   iobjFor(PutIn) 
   { 
      preCond = static inherited + objOpen 
      check()
      {
        if(!gDobj.inflammable)
        {
          reportFailure('That\'s probably a waste of time; {the dobj/he} won\'t burn. ');
          exit;
        }
        inherited;
      }
   }
  iobjFor(BurnWith) remapTo(PutIn, DirectObject, stove) 
;

+ oldTable : ComplexContainer, Heavy 'old solid table*furniture' 'old table'
  "The table may not be remotely elegant but at least it looks pretty solid. "
  subUnderside : ComplexComponent, Underside { bulkCapacity = 5  }
  subSurface : ComplexComponent, Surface { }
  cannotPushTravelMsg = 'It\'s too awkward to move, and besides, it\'s best left
   where it is. '
  moveToNoEffectMsg { return cannotPushTravelMsg; } 
;  

++ sack : Openable, StretchyContainer 'old brown faded bag/sack/writing' 'old brown sack'   
  "It's made of plain brown sackcloth. The faded writing on its side suggests it
   may once have been used to transport salt. <.reveal sack>"
   location = (oldTable.subUnderside)   
  dobjFor(LookIn)
  {
    preCond = [objHeld, objVisible, objOpen]
  }  
  okayOpenMsg = '{You/he} pull{s} open the mouth of the sack to peer inside. '
  okayCloseMsg = '{You/he} pull{s} the mouth of the sack closed. '
  preCondDobjOpen = static inherited + objHeld
  openStatus() {
    if(isOpen)
    {
      if(contents.length>0)
        return 'It has an open mouth';
      return 'Its mouth hangs open';
    }
    return 'Its mouth is pulled tightly shut';
  }
  iobjFor(PutIn)
  {
    check() {
      if(gDobj == sand || gDobj.ofKind(Sand))
      {
        reportFailure('You decide against doing that -- it\'d probably make the
         sack too heavy to carry and it\'d be such a mess making sure you got
         all the sand out again. ');
        exit;
      }
    }
    action()
    {
      inherited;     
      local listlen = gAction.dobjList_.length();
      local idx = gAction.dobjList_.indexWhich({x : x.obj_ == gDobj} );
       
      "{You/he} put{s} {the dobj/him} into the sack.\n";    
      /* It's not easy to see what's in a sack, so we
        close it after putting an object in it to 
        simulate this */
        
      /* But only close it again when we have acted on the last dobj
         in the list */  
      if(idx == listlen)
      {      
         reportAfter('<.p>You then pull the neck of the sack closed. ');
         makeOpen(nil);
      }
    }
  }
  dobjFor(FillWith) remapTo(PutIn, IndirectObject, self)
  minBulk = 2
  bulkCapacity = 30
  sightSize = (getBulk() < 4 ? small : medium )
;

+++ oldClothes :  Wearable 'old tatty torn shirt/jacket/trousers/clothes' 'old clothes'
    "It's not hard to tell why {the hermit/he} was planning to burn these old
     rags: even a moderately self-respecting tramp would refuse to be seen dead in them;
     but they comprise a pair of trousers, a torn shirt, and a tatty jacket that at least
     look capable of covering nakedness. "
    smellDesc = "Months ago these old rags might have smelt musty -- now they're
     starting to get positively putrid. "
    isPlural = true
    dobjFor(Wear)
    {
      check()
      {
        if(blueCoveralls.isWornBy(gActor))
        {
          "{You/he}'ll have to remove the coveralls first. ";
          exit;
        }
      }
      action()
      {
        inherited;
        achievement.awardPointsOnce();
      }
    }
    dobjFor(Doff)
    {
      check()
      {
        "That would leave you naked, which doesn't seem such a good idea. ";
        exit;
      }
    }
    achievement : Achievement { +1 "changing clothes ";}
    bulk = 5
    weight = 3
;

+ Unthing 'chopped pile/wood' 'chopped wood'
  notHereMsg = 'You can\'t see the wood {the hermit/he} was chopping -- he must
   have put it straight in the stove. '
  isMassNoun = true
;

+ axe : Unthing 'axe' 'axe'
  notHereMsg = '{The hermit/he} must have put it away somewhere, for you can\'t see it. '
;

hedgeBarrier :  NoTravelMessage { "You press against the hedge and try to force your
    way through it, but it's a plainly futile exercise, since the hedge is 
    too thick for anything much larger than a fieldmouse to pass through. After
    about a minute spent vandalising the shrubbery and earning yourself a few
    well-deserved scratches for your stupidity, you give up the daft attempt. " }
   
hedgeRow : Unclimbable, defaultWestWall 
   'thick dark green high tall hedgerow/hedge/leaves' 'hedge'
  "The hedge is six or seven feet tall and thick with dark green leaves. "
  cantClimbMessage = 'There\'s nothing to get a purchase on; the twigs and branches
   bend away as soon as you put even a tiny fraction of your weight upon them, and the
   leaves simply come away in your hand. '
;
   
road : OutdoorRoom 'Road' 'the road'
  "The road runs north-south, between a high hedgerow to the west and a large open
   field to the east<<boots.isWornBy(gPlayerChar) ? '' : '; its surface feels
   hard on your bare feet'>>. In the distance to the northeast you can see a clump of
   ugly buildings, while some way to the south the road goes over a bridge. "
  east = westField
  west = hedgeBarrier 
  south = bridge
  north = northRoad   
  roomParts = static (inherited + hedgeRow) 
  roomAfterAction
  {
   if(blueCoveralls.isWornBy(gActor) && gActionIs(TravelVia))
    {
      "<.p>The coveralls you are wearing make you feel dangerously conspicuous
       here, out on the open road so close to the prison complex. <<gRevealed(hermit)
       ? 'It strikes you that you might do better to find a change of clothes before 
       exploring anywhere where you might be seen' : 'Anxious above all things
       not to get recapured, it strikes you that the forest might provide a safer
       refuge right now'>>. ";
    }
   else if(blueCoveralls.isIn(gActor) && gActor.canSee(blueCoveralls)
     && gActionIs(TravelVia))
   {
     "<.p>You wonder whether carrying your prison coveralls in plain sight is such
      a good idea. ";
   }  
  }
;    

+ Enterable -> westField 'large open field' 'large open field'
  "The large open field lies to the east of the road, and stretches away to a
  distant forest. " 
;

+ Distant 'old stone bridge' 'bridge'
  "The old stone bridge is some way off to the south. "
  dobjFor(Enter) remapTo(TravelVia, bridge)  
;


+ Distant 'distant edge/forest' 'distant forest'
  "The edge of the distant forest can just be discerned across the field to
  the east. "
;

+ Distant 'ugly mean concrete prison set/clump/buildings/compound' 'buildings'
  "It's a low, mean set of ugly concrete buildings. It could well be the prison compound. "
  isPlural = true
;

bridge : OutdoorRoom 'North Side of Bridge' 'the north side of the bridge'
  "The long, straight road from the north reached a bridge at this point, 
   << warningSign.pushedAside ? 'and continues over the bridge to the south, 
   past a large sign that has been pushed to one side.' : 'but the way south is 
   blocked by a large sign, probably because the bridge has suffered recent flood 
   damage.'>> "
   north = road   
   warned = nil
   south : NoTravelMessage 
    {
     showTravelDesc()
     {
      if(warningSign.pushedAside)
      {
        if(warned){
         "You start to walk over the bridge, but a couple of yards beyond the warning
         side the walkway crumbles beneath your feet, plunging you into the raging
         torrent beneath, while falling masonry drops after you and knocks you on
         the head. Maybe that's why you drown. <.p>";
         endGame(ftDeath);
        }
        else {
         "You take another step onto the bridge, but you hesitate to go any
          further, mindful both of the warning sign and of the parlous state of the
          bridge. ";
          warned = true;
       }
      }
      else
       "The road over the bridge is blocked by a large sign. "; 
     }
    }
    swimDesc = "The river flowing under the bridge is a torrent; if you jumped in
     from here the chances are you'd never come up again -- even assuming you ever
     learned to swim in the first place, and you can't definitely recall that
     you ever did. "
;

+ Enterable ->road 'long straight road' 'long straight road'
  "The road runs south over the bridge and north past a large open field. "
;

+ Distant 'large open grassy field' 'large open field'
  "The field, which lies to the northeast, runs along the eastern edge of the
   long road running north. "
  dobjFor(Enter) {
    verify() { }
    action() {
      "(going north)";
      nestedAction(North);            
      "<.p>(going east)";
      nestedAction(East);
    }
  }
  
;

+ warningSign : Heavy 'large warning sign' 'large sign'
  "The sign declares:\n
  <FONT COLOR=RED>\ \ \ \ \ \ \ \ DANGER!</FONT>\n
  BRIDGE CLOSED FOR REPAIRS\n
  UNTIL FURTHER NOTICE"
  pushedAside = nil
  dobjFor(Push)
  {
    verify() {}
    check() {}
    action()
    {
      local verb = gAction.getOrigTokenList[1][1].toLower();
      if(pushedAside)
        "You <<verb>> the sign back into place. ";
      else
        "You <<verb>> the sign to one side. ";
      pushedAside = !pushedAside;
    }
  }
  dobjFor(Pull) asDobjFor(Push)
  dobjFor(Move) asDobjFor(Push)
;

class Disposer : object
  vitalObjs = [hat, oldClothes, greenBook, blueBook, redBook, net, stick, netStick,
    whiteEnvelope, brassKey, ironKey, filedIronKey]
  disposalMsg = "You dispose of {the dobj/him) in <<theName>>. "
  documentWarning = nil
  greenLetterWarning = nil
  paperScrapWarning = nil
  warningMsg = "You hesitate, suspecting that this action may result in your destroying
   something you'd rather keep. "
  wouldDestroy(obj) { return gDobj == obj || obj.isIn(gDobj); }
  iobjFor(PutIn)
  {
    verify() {}
    check() 
    {
      foreach(local obj in vitalObjs)
      {
        if(wouldDestroy(obj))
        {
          warningMsg;
          exit;
        }      
      }
      if(!gDobj.described && gDobj != blueCoveralls)
      {
        "You decide you\'d better look at {it dobj/him} first. ";
         exit;
      }
      local cont = (gDobj.ofKind(ComplexContainer) && gDobj.subContainer != nil
           ? gDobj.subContainer.contents : gDobj.contents);
      foreach(local obj in cont)
      {
        if(!obj.described && !obj.ofKind(NonPortable))
        {
          "It occurs to you that you should first examine its contents. ";
          exit;
        }
      }
    }
    action()
      {
         if(wouldDestroy(document) && !documentWarning)
         {
             documentWarning = true;
             warningMsg;
             exit;
         }
         if(wouldDestroy(greenLetter) && !greenLetterWarning)
         {
             greenLetterWarning = true;
             warningMsg;
             exit;
         }
         if(wouldDestroy(paperScrap) && !paperScrapWarning)
         {
             paperScrapWarning = true;
             warningMsg;
             exit;
         }
         disposalMsg;
         local loc = nil;         
         if(gDobj == acorns)
         {
           loc = acorns.newLocation();
         }
         gDobj.moveInto(loc);
         if(wouldDestroy(blueCoveralls))
         {
           "Disposing of those blue coveralls like that <<blueCoveralls.isIn(gDobj) ?
           '(they were in {the dobj/him})' : nil>> is probably a good idea -- they might
           have been incriminating. ";
           coverallsAchievement.awardPointsOnce();
         }
         if(wouldDestroy(document))
         { 
            "Getting rid of that document <<document.isIn(gDobj) ? '(which was inside
            {the dobj/him})' : nil>> ensures that its contents will never get into
            the public domain -- which is just what the New Enlightenment Government
            want, of course; but maybe being so obliging to them wasn't such a
            great idea.<.p>";           
            endGame(ftFailure);
           
         }
         if(wouldDestroy(pressRelease))
         {
           
            "You smile broadly as you reflect on what will happen tomorrow when
             that press release about the elections <<pressRelease.isIn(gDobj) ? 
             '(which was in {the dobj/him}) ': nil>> fails to appear.<.p>";
             pressReleaseAchievement.awardPointsOnce();
           
         }
         if(wouldDestroy(greenLetter))
         {          
           "It's only after the green letter
           <<greenLetter.isIn(gDobj) ? '(which was in {the dobj/him}) '
            : nil>> is utterly beyond retrieval that it occurs to you
            that destroying it might not have been the best idea.<.p>";            
         }
         if(wouldDestroy(paperScrap))
         {           
             "You have a horrible feeling you might have just destroyed something
              useful. ";             
         }
      }
    }
    coverallsAchievement : Achievement {+1 "disposing of the blue prison coveralls"}
    pressReleaseAchievement : Achievement {+1 "disposing of the press release" }
  
;

+ Disposer, Immovable 'raging high flood/river/torrent/water' 'river'
  "The river is still very high; it charges under the damaged bridge in a raging torrent. "
  disposalMsg =
     "You toss {the dobj/him} over the parapet, and {it dobj/he} fall{s} into the river below.
      In an instant, {it dobj/he} {is} sucked under by the powerful current and {is} 
      then carried rapidly downstream by the torrent. It's most unlikely that you or 
      anyone else will ever see {it dobj/him} again.<.p>"  
  cannotEnterMsg = 'There\'s a terribly powerful current in those swollen floodwaters,
   and you\'re not at all confident of you\'re ability to swim. In fact, a moment\'s
   reflection suggests that if you enter those waters, you\'ll probably never emerge
   alive. '
  cannotJumpOverMsg = 'It\'s far too wide: if you tried you\'d probably fall in and
   drown. ' 
  iobjFor(PutIn)
   {
     
     check() {
       if(!gDobj.ofKind(Sand))
        inherited;
     }
     action() {
       if(!gDobj.ofKind(Sand))
        inherited;
     }
   }
   sandFill(obj)
   {
     if(obj.ofKind(Sand))
     {
       "You pour the sand out of <<gDobj.container.theName>> into the river,
        where it quickly disperses. ";
        return true;
     }
     else
        return nil;
   } 
;

+ damagedBridge : Fixture 'damaged cracked bridge/parapet/masonry' 'damaged bridge'
  "The bridge looks like it could have stood here for centuries; recently, however, its masonry
   has become cracked and part of the parapet is missing. "
   dobjFor(JumpOff)
   {
     verify() {}
     action() {
       "That would probably be suicidal, and you're not that desperate. ";
     }
   }
   dobjFor(StandOn)
   {
     verify() {}
     action() { replaceAction(South); }
   }
   cannotJumpOverMsg = 'It\'s far too wide: if you tried you\'d probably fall in 
   the river and drown. ' 
;  

wallBarrier : NoTravelMessage { "You simply <i>can't</i> walk through a solid brick wall. " }
;

compoundWallEast: RoomPart 'long high east a wall*walls' 'long high wall'
  "The long high wall runs along the east side of the road to the south, obscuring most
   of the compound within. "
   cannotClimbMsg = 'Most people would want to get <i>out</i> of that compound; besides,
    the wall is too high to climb. '
;

northRoad : OutdoorRoom 'Road Bend' 'the bend in the road'
  "The long road from the south turns sharply round to the east at this bend, 
   continuing past a walled compound that looks depressingly familiar. The southern
   spur of the road runs between a tall hedge and a high wall, while the
   eastern spur runs between two high walls. "
  south = road 
  north = wallBarrier
  west = hedgeBarrier
  east = prisonRoad     
  roomParts = static (inherited + hedgeRow + prisonRoadNorthWall + compoundWallEast)
  roomAfterAction
  {
   if(blueCoveralls.isIn(gActor) && gActionIs(TravelVia) && gActor.canSee(blueCoveralls))
    {
      "<.p>You feel very nervous indeed about wandering around this close to the buildings
       <<blueCoveralls.isWornBy(gActor) ? 'in' : 'carrying' >> your prison coveralls. ";
    }    
  }
  travelBarrier : PushTravelBarrier {
    canPushedObjectPass(obj) { return obj != trough; }
    explainTravelBarrier(traveler)
     {
       "The trough doesn't ride very easily on the road surface, and pushing it
        any further along the road really doesn't seem worth the effort. ";
     }


  }
;   

+ Fixture 'walled compound' 'compound'
  "The compound is situated on the corner of the roads leading east and
   south. It's surrounded by the kind of high concrete wall that looks
   equally determined to keep insiders in and outsiders out. "
;

Occluder, DistanceConnector [prisonRoad, northRoad]
 occludeObj(obj, sense, pov)
   {
     if(pov.isIn(northRoad))
       return obj.onSouthSide;             
     return nil;
   } 
;

prisonRoadNorthWall : RoomPart 'n north high brick wall*walls' 'north brick wall'
  "It's just a high brick wall -- too high to climb. "
;

prisonRoadSouthWall : RoomPart 's south high brick wall*walls' 'south brick wall'
  "The brick wall on the south side of the road is just as high as that
   on the north, but there is a gate it it. "   
   onSouthSide = true
;

prisonRoadCoverallBarrier : TravelBarrier
  canTravelerPass(traveler)
  {
    return (warnedAboutCoveralls || !(blueCoveralls.isIn(traveler) 
      && traveler.canSee(blueCoveralls)));
  }
  explainTravelBarrier(traveler)
  {
   warnedAboutCoveralls = true;
       "You take a hesitant step forward and then stop, feeling <i>really</i> nervous
       about walking along the road right in front on the prison
       <<blueCoveralls.isWornBy(traveler) ? 'in' : 'carrying'>>
        your conspicuous prison coveralls.<.p>";
  }
  warnedAboutCoveralls = nil
;

prisonRoadGuardBarrier : TravelBarrier
  canTravelerPass(traveler)
  {
    return (warnedAboutGuard && !gRevealed('squarecircle-statement')) 
      || !guardian.isIn(prisonRoad);
  }
  explainTravelBarrier(traveler)
  {
    warnedAboutGuard = true;
       "You take two steps forward, and then see the guard throw
       a curious glance your way. You feel almost certain that if you get much
       closer to him he'll recognize you. ";
  }
  warnedAboutGuard = nil
;

prisonRoad : OutdoorRoom 'Road Past Prison' 'the road past the prison'
  "The high brick wall continues to run along the north side of the road here. There is
   an equally high brick wall along the southern side, but this is pierced by a gate
   next to which is a large white sign. "
  south = prisonGate
  north = wallBarrier
  west = northRoad
  east = departmentRoad
  roomAfterAction
  {
   if(blueCoveralls.isIn(gActor) && gActionIs(TravelVia) && gActor.canSee(blueCoveralls))
    {
      "A man in the uniform of the Punishment Service runs out, 
       and takes one look at your prison clothes. ";
       guardian.moveIntoForTravel(self);
       guardian.setCurState(guardianWatching);
       guardian.curState.afterAction();
    }
  }
  roomParts = static(inherited + prisonRoadNorthWall + prisonRoadSouthWall)

  travelBarrier = [prisonRoadCoverallBarrier, prisonRoadGuardBarrier]
;


+ prisonGate : IndirectLockable, Door -> prisonGate2 
   'six feet tall black painted black-painted steel prison gate/railings' 
   'prison gate'
   "The gate, which is about six feet tall, is made of black-painted steel railings with 
    sharp spikes running along the top. Through the gate you can see a driveway running
    down a long avenue of trees. "
    initiallyOpen = true
    initiallyLocked = nil
    onSouthSide = true 
    cannotClimbMsg = 'It doesn\'t look that easy too climb, and the attempt would
     in any case be utterly pointless since you could simply walk straight through. '   
;

++ Component 'sharp spikes' 'sharp spikes'     
    "The sharp spikes running along the top of the gate are certainly not the kind
     of thing anyone want to find themselves impaled upon. "
     isPlural = true
     onSouthSide = true
;

+ Fixture 'large white sign' 'large white sign'
   "The large white sign reads:\nDEPARTMENT OF JUSTICE\nEXPERIMENTAL PUNISHMENT FACILITY"
   onSouthSide = true
;

+ Distant 'long driveway/drive/avenue/(trees)' 'driveway'
  "Beyond the gate the driveway runs southwards down an avenue formed by the tall
   trees on either side. "
   onSouthSide = true
;

+ Distant 'tall trees/conifers' 'trees'
  "The tall trees lining the avenue running south on the far side of the gate are
   mainly conifers. "
   onSouthSide = true
;

dRoadNorthWall : RoomPart 'solid high brick north n wall*walls' 'north wall'
  "It's about seven feet high and made of brick. "
  cannotClimbMsg = 'It\'s too high to climb. '
;

dRoadSouthWall : RoomPart 'high brick south s wall*walls' 'south wall'
  "It's about seven feet high and made of brick -- but there's also a low white
   gate in it, with a blue sign next to it. "
  cannotClimbMsg = 'Not is it only too high to climb, but it\'s also utterly
  pointless to attempt to climb it when there\'s a perfectly good gate. '
;

departmentRoad : OutdoorRoom 'Road' 'the road'   
  "The road continues to run east-west between high brick walls, but there is a gateway
   through the wall to the north, with a large blue sign next to it. Over to the east
   the road runs towards some sort of checkpoint. A large white building towers up behind
   the wall to the north. "
   vocabWords = 'road'
   roomParts = static(inherited + dRoadNorthWall + dRoadSouthWall)
   south = wallBarrier
   west = prisonRoad
   east : FakeConnector, ShuffledEventList { 
     [
      'You dare not get any nearer that checkpoint -- the risk that
      the guards on duty there have been warned to look out for you is just too great.
      <.reveal checkpoint> '
     ]
     [
       'You really don\'t want to go any nearer the guards on that checkpoint. ',
       
       'You take a couple of steps nearer the checkpoint, but your nerve fails
        when you see the guards watch your approach. Trying to look unconcerned,
        you retrace your steps. ',
        
       'You feel quite sure the guards on the checkpoint will have been warned to
        watch out for you. ',
        
       'You decide it\'s not worth the risk; besides, you still have unfinished
        business this side of the barrier. '  
     ] 
    }
   north = departmentGate
;


+ departmentGate : AutoClosingDoor ->departmentGate2 
   'white low chest-high perfectly good painted gate/gateway' 'white gate'
   "<<departmentGate2.desc>>"
;

+ Fixture 'large blue sign' 'large blue sign'
  "The large blue sign reads:\n
   DEPARTMENT OF APPLIED RATIONALITY"
;

+ Distant 'red (and) white check guard point/checkpoint/pole/barrier/box' 'checkpoint'
  "The checkpoint to the east comprises a red and white pole barrier across the road next
   to a large red and white guard-post. A pair of guards stands by the barrier."
   #ifdef __DEBUG
     verifyDobjSnarf { nonObvious; }
   #endif
;

+ Distant 'small basic red (and) white guard-post/hut/shelter' 'guard-post'
  "The guard-post is effectively just a small hut with room for one man to stand
   in or two to get uncomfortably cosy in. It's probably intended as nothing
   more than a basic shelter in bad weather. "
;

+ Distant 'pair guards' 'guards'
  "The guards are dressed in khaki fatigues and white helmets. They're too far away to
   make out the details, but they could well be armed. They seem to be there to check
   on all traffic -- pedestrians included -- attempting to pass the barrier. "
  isPlural = true 
;

+ Distant 'large tall white ten-storey building' 'large white building'
  "There may be a hint of classicism in the architecture of this ten-storey building,
   but it is mainly utilitarian -- the face that can be seen above the wall is an 
   austere white rectangle pierced by a regular array of rectangular windows. "
;

++ Distant 'bland white-framed equispaced rectangular windows' 'windows'
   "The bland, white-framed windows are equispaced six to a storey. "
   isPlural = true
;


departmentGarden : OutdoorRoom 'Neat Garden' 'the neat garden'
   "Four square flowerbeds have been laid out in geometric precision here, two on either side
    of the short gravel path leading from the gate to the south to the entrance of the
    tall white building to the north. "
   vocabWords = 'neat garden'
   north = glassDoorsOutside
   in asExit(north)
   south = departmentGate2
   travelerArriving(traveler, origin, connector, backConnector)
   {
     inherited(traveler, origin, connector, backConnector);
     traveler.moveIntoForTravel(gardenPath);
   }
;

+ departmentGate2 : AutoClosingDoor 'chest-high white painted gate' 'white gate'
  "It's chest high and painted white. "
  
;

+ Decoration 
  '(four) square flower yellow red regimented pair/flowerbeds/beds/formation/rows' 
   'flowerbeds'
  "Two square flowerbeds are laid out on the right side of the path, and two
   on the left, creating a square formation of flowerbeds. Each flowerbed
   has been planted with four regimented rows of tulips, alternatingly
   red and yellow. "
   smellDesc = "A tulip by any other name..."
   isPlural = true
   notImportantMsg = 'The flowerbeds may be a bit over-regimented, but 
   it would seem unnecessarily vandalistic to disturb them. '
;

+ Decoration 'yellow red flower/tulip/flowers/tulips' 'tulips'
  "The bright red and yellow tulips occupy the flowerbeds on either side of the path. "
  isPlural = true
  notImportantMsg = 'Someone might complain if you disturb them, and you don\'t
   want to get into trouble for anything so trivial. Besides, you can think of
   no one you want to give a flower to now. '
  smellDesc = "A tulip by any other name..."
//  dobjFor(Pick) asDobjFor(Take)
;


+ gardenPath : PathPassage, Platform 'short gravel path' 'short gravel path'
  "The short gravel path runs from the gate to the portico in front of the entrance
   to the building. The path is about three feet wide and ten feet long, and
   there's a pair of square flowerbeds on each side of it. "
   dobjFor(Follow) asDobjFor(TravelVia)
   dobjFor(TravelVia)
   {
     action() { nestedAction(TravelVia, self.connector); }
   }
   connector : AskConnector
   { 
     travelObjs = [departmentGate2, glassDoorsOutside]
     travelAction = GoThroughAction
     promptMessage = "The path leads north to the glass doors and south to
      the gate. "
     travelObjsPhrase = 'of these' 
   }
   down = nil
   out = nil
   checkActorOutOfNested(allowImplicit) { }
   cannotTravel()
    {
        /* use the actor's location's cannotTravel handling */
        gActor.getOutermostRoom.cannotTravel();
    }
;


+ Enterable ->glassDoorsOutside 'large tall ten-storey utilitarian white front/building' 
  'large white building'
   "There may be a hint of classicism in the architecture of this ten-storey building,
   but it is mainly utilitarian, apart from the attempt at a pseudo-classical portico
   in front of the glass doors leading into the building. "   
;

++ Distant 'bland white-framed rectangular windows' 'windows'
   "The bland, white-framed windows are equispaced six to a storey. "
;

+ Booth, Fixture 'pseudo-classical (white) portico' 'portico'
  "This portico represents a half-hearted attempt at decorating the front of the
   building, but in a severely rational fashsion, since it comprises little more
   an unadorned triangular pediment supported by a pair of equally unadorned
   pillars. "   
;

++ Component 'plain white triangular isoceles pediment/triangle' 'pediment'
  "The pediment is a plain white isoceles triangle, supported by the pillars. "
;

++ Component 'plain white pair/pillars/columns/cylinders' 'pillars'
  "The pair of pillars supporting the triangular pediment are neither Corinthian
   nor Doric nor any other genuinely classical design; they are simply plain 
   white cylinders. "
;


+ glassDoorsOutside : IndirectLockable, AutoClosingDoor 
    ->glassDoorsInside '(building) glass doors/entrance' 'glass doors' 
    isPlural=true
    initiallyLocked = nil
    nothingThroughMsg = 'Through the doors {you/he} make{s} out some sort of
   reception area. '
;



receptionArea : Room 'Reception Area' 'the reception area'
  "The reception area is clean almost to the point of antiseptic sterility. The walls are painted
   a plain white, relieved only by a minimal amount of abstract geometrical art. Behind the
   reception desk a corridor leads off into the depths of the building,
   and a series of gleaming steel doors indicate the presence of lifts. The way out is back
   through the glass doors to the south. "
  south = glassDoorsInside
  out asExit(south)
  north = corridor // in practice unreachable
  
  travelerLeaving(traveler, dest, connector)
     {
       if(telephone.isIn(traveler))
       {
         reportFailure('{You/he} will have to put the phone down before {you/he} leave{s}
          here, since it\'s attached to the floor by its cable.' );
         exit;
       }
       inherited(traveler, dest, connector);
     }
   atmosphereList : ShuffledEventList {
   [  
      nil, 
      
      new function { "A man in a dark suit emerges from one of the lifts and walks briskly out
        through the glass doors. ";
        unMan.makePresent();
        }, 
        
        nil,
        
      new function {       
      "A young man in a crash-helmet and cycling leathers
       barges past you and drops a thick brown envelope into the tray on the receptionist's
       desk. There's a brief spoken interchange between the receptionist and the messenger
       while she signs a form he holds out to her; then he hurries back out through the
       glass doors.<.p><<gSetSeen(biker)>>";
       brownEnvelope.moveInto(wireBasket); 
       gActor.setHasSeen(brownEnvelope);
       brownEnvelope.moved = nil;
       },
       nil, new function {
       "A young redhead strides past, giving {the receptionist/her} a cheery wave before
        leaping into one of the lifts just in time. ";
        unRedhead.makePresent();
       },        
      
       new function {
       "A pale man in a flapping loose shirt charges breathlessly down the corridor and
        drops a white envelope in the tray. {The receptionist/she} glances at it
        and remarks, <q>I'm afraid you just missed the courier.</q>\b
        <q>Damn!</q> he mutters, <q>It's bloody urgent!</q>\b
        <q>No need to flap!</q> she rebukes him, <q>Remember, we're servants of
         Rational Government, so keep calm and rational!
         Besides, there'll be another courier along soon.</q>\b
        <q>I suppose so,</q> he mutters, before retreating back down the corridor.<.p>";
        whiteEnvelope.moveInto(wireBasket);
        whiteEnvelope.moved = nil;
        gActor.setHasSeen(whiteEnvelope);
       },
       
       nil,
       new function {
       "A pair of chattering young men emerge from the corridor and enter one of the lifts. ";
       unPairOfMen.makePresent();
       },
       nil, nil,
       new function {
       "A middle-aged woman glides past, flashing her pass at the receptionist before
        disappearing off down the corridor. ";
        unMiddleAgedWoman.makePresent();
        }              
   ]    
   [
     nil, nil, 'A woman comes in through the glass doors and walks over to the
      lifts. ', nil, nil, 'A young man emerges from one of the lifts and strides
       out through the glass doors. ', nil, nil, 'A young woman steps out of one
       of the lifts and disappears off down the corridor. ', nil, nil, nil,
      'A pair of women emerge from the corridor and walk brisky out through the
       glass doors. ', nil, nil, 'A pair of men walk in through the glass doors,
       flash their pass at {the receptionist/her} and continue on down the
       corridor. ', nil, nil, nil, nil, nil 
   ]
   }  
   
   roomBeforeAction()
   {
     if(gActionIs(ThrowAt))
     {
       "Your presence here is suspicious enough as it is; you certainly don't want to 
        start calling more unfavourable attention to yourself by such uncouth
        behaviour as throwing things around. ";
       exit;
     }
   }
;

+ glassDoorsInside : AutoClosingDoor 'glass door/doors' 'glass doors'
  isPlural=true
  dobjFor(LookThrough)
  {
    action() { "Through the glass doors you see a path leading through a small,
     neat garden. "; }
  } 
  
;

+ Distant 'small neat garden/path' 'path'
  "The path can be seen running through the garden on the far side of the
   glass doors. "
;

+ receptionDesk : Heavy, Surface 'plain (reception) utilitarian desk laminate desk/top' 'desk'
  "It's a plain, utilitarian desk, with a laminate top and a set of thin stainless
  steel legs. "
;

++ Component 'thin stainless steel functional (desk) legs' 'stainless steel legs'
  "There's really nothing remarkable about them: there's one at each corner of the desk,
   and each is regimentally identical to the others. In short, the 
   desk legs are purely functional, thin square tubes of stainless steel that serve
   only to keep the desk top clear of the floor. "
   isPlural = true
;

++ telephone : Thing 'utilitarian small plain black phone/telephone/handset' 'telephone'
  "It's a small, plain black handset, purely utilitarian in design. "
  bulk = 3
  properPlace = receptionDesk
;

+++ Component 'black length/cable/wire/cord/socket' 'cable'
  "A length of black cable connects the telephone to a socket in the floor beneath
   the desk. "
;

++ papers : PaperSurface 'routine official pile/papers/documents' 'papers'
  "The papers don't look terribly interesting -- just a pile of routine official documents,
   written in routine officialese. "
  isPlural = true
  cannotWriteOnMsg = &doNotDefaceMsg
  cannotDrawOnMsg = &doNotDefaceMsg
  properPlace = receptionDesk
  bulk = 2
  weight = 2
;

++ wireBasket : Container 
  'plain wire (paper) basket/tray/in-tray/paper-tray' 'wire basket'
  "It's a plain wire basket, of the sort offices use for paper-trays. This one seems
   to be an in-tray. "
   bulk = 4
   bulkCapacity = 4
   actionDobjTake()
   {
     if(!(brownEnvelope.isIn(self) && whiteEnvelope.isIn(self)))
        "You pick up the basket and give it a quick lookover, but since it seems
         completely useless to you, you put it back where you found it. ";
     else
        inherited;     
   }
   isObviousContainer = nil // to stop the receptionist bothering to search it.
   properPlace = receptionDesk
   inflammable = nil
;

+ Distant 'corridor' 'corridor'
  "The corridor leads into the heart of the building behind the desk. "
;

+ Distant 'gleaming steel lift elevator elevators/lifts/signals/doors' 'lifts'
  "There's a row of three gleaming steel lift doors to the left of the corridor. Every now
  and again the flicker of the signals above them indicates the ascent
  and descent of the lifts. "
  isPlural = true
;

+ Distant 'flickering illuminated signals/numbers/arrows' 'signals'
  "The signals, mounted on the wall by the lift doors, signal the ascent and descent
   of the lifts, both by means of a series of illuminated numbers above the lift doors,
   and by arrows that light up to indicate which way a given lift is traveling. "
;

+ Decoration 'abstract geometrical art/pictures/paintings/squares/lines/circle' 
  'abstract geometrical art'
  "As a minimal nod towards the need for decoration, a few paintings have been hung
   about the walls. They're mainly in black and white, and are all brutally abstract:
   squares, circles and lines for the most part. Indeed, they're all so soulless
   that they seem hardly to merit the appellation <q>art</q>."
;

class UnPerson : PresentLater, Decoration
  dobjFor(Follow)
  {
    verify() { logicalRank(110, 'unman'); }
    check() {}
    action() { tooLateMsg; }    
  }  
  discover()
  {
    inherited;
    gSetSeen(self);
  }
  notImportantMsg = '\^'+ itIsContraction + ' no longer here. '
  itIsContraction()
  {
    if(isPlural) return 'they\'re';
    if(isHim) return 'he\'s';
    if(isHer) return 'she\'s';
    return 'it\'s';
  }
;

+ unMan : UnPerson 'pale young man' 'man who was here'
  "He's not here any more. "
  tooLateMsg = "Too late: he's gone. "  
  isHim = true  
;

+ unRedhead : UnPerson 'young redhead' 'young redhead'
  "She isn't here. "
  isHer = true
  tooLateMsg = "Too late: she's gone, and you can't get to the lifts. "  
;

+ unPairOfMen : UnPerson 'chattering young pair/men' 'pair of young men'
  "They disappeared into a lift. "
  tooLateMsg = "You can't get to the lifts, and you're too late: they've gone. "    
  isPlural = true
;

+ unMiddleAgedWoman : UnPerson 'middle-aged woman' 'middle-aged woman'
  "She's no longer here. "
  tooLateMsg = "She's disappeared out of sight, and in any case you can't
   get to the corridor. "
  isHer = true
;


class Envelope : Openable, RestrictedContainer
 dobjFor(Open)
  {
    preCond = static inherited + objHeld
    action()
    {
      if(gActor.getOutermostRoom is in (departmentRoad, departmentGarden, receptionArea,
      prisonRoad, avenue, driveway) && !hasBeenOpened)
      {
        switch(gActor.getOutermostRoom)
        {                    
          case departmentRoad:
          case departmentGarden:
             "You glance anxiously back towards the large white building and down
              the road to the checkpoint, and decide to put more space between
              {the receptionist/her} and your spoils before examining them. ";
              break;
          case driveway:
             "This really doesn't seem the time or place. ";
             break;
          case avenue:
          case prisonRoad:
             "This looks the sort of place where Punishment Service personnel
              might appear at any moment, and you really don't want them catching
              you studying the contents of {the dobj/him}. ";
             break; 
          case receptionArea:
              "{The receptionist/she} might stop reading and look up at any moment;
               you don't want her to catch you looking inside <<theName>>. ";
              break;   
          default:
             "You'd rather get clean away before stopping to open <<theName>>. ";
             
        }
      }
      else
      {
        hasBeenOpened = true;
        inherited;
      }
    }
  }
  hasBeenOpened = nil
  validContents = [coverPage, document, greenLetter, note, pressRelease, paperScrap,
    foodNote, newFoodNote, hutNote]
  cannotWriteOnMsg = &doNotDefaceMsg
  cannotDrawOnMsg = &doNotDefaceMsg 
  isObviousContainer = nil // to stop the receptionist searching it
  sightSize = small
;

brownEnvelope : Envelope 'thick brown envelope*envelopes' 
   'thick brown envelope'
  "It's about six inches by four. <<isIn(wireBasket) ? 'Although it\'s upside
  down from your point of view, you manage to make out the writing on it. ' : nil>>
  Written on it in large letters is\b<.reveal dunderhead>  
  Prof. B.A. Dunderhead\nSenior Director\nDepartment of Applied Rationality.\b
  <FONT COLOR=RED>EXTREMELY URGENT\nABSOLUTELY & TOTALLY TOP SECRET</FONT><.p>" 
  properPlace = wireBasket
;

+ coverPage : Readable, PaperSurface 'covering note' 'covering note'
  "The covering note declares\b
   <FONT COLOR=RED>MOST SECRET</FONT>\bRE: PANDRA.\b
   For the Director's eyes only.\b
   Note: It is absolutely <i>essential</i> that the enclosed information
   is kept from the public. Dire damage to the government's credibility
   would almost certainly result if any of it ever became generally known. "
   cannotWriteOnMsg = &doNotDefaceMsg
   cannotDrawOnMsg = &doNotDefaceMsg
   dobjFor(Read) { preCond = static inherited + objHeld }
   dobjFor(Examine) { preCond = static inherited + objHeld }
   sightSize = small
;

+ document : Readable, PaperSurface 'secret document/pages' 'document'
  "It's several pages long, and seems to be all about Pandra.<.reveal pandra>"
   
  readDesc = "A quick read of the document reveals the following:\b
  1) Pandra, the author of <i>Principles of Rational Government</i>, the book
  that inspired the New Enlightenment, has now become <i>persona non 
  grata</i><<personaNote.noteRef()>> with the authorities and placed under arrest.\b
  
  2) The reason for this is that Pandra is intending to recant the views expressed
  in <i>Principles of Rational Government</i> by claiming that the New
  Enlightenment project is <q>as irrational and impractical as attempting
  to draw a square circle.</q>\b
  
  3) It is obviously vital that these facts <u>never</u> become public knowledge,
   otherwise public confidence in the New Enlightenment project could well become
   dangerously undermined.\b
   
  4) It is equally obvious that Pandra must be terminated before becoming more
   of a menace to the project -- but an attempt will first be made to trick or
   coerce Pandra into signing a statement that may prove useful for presentational
   purposes should news of the <q>square circle</q> jibe ever leak out.\b
  
  5) The Department of Applied Rationality is thereby instructed, in the first instance,
   to prepare to announce Pandra's tragically premature demise, but in the second, to
   repackage the history of the New Enlightenment so that Pandra's role as a key
   thinker is drastically reduced.\b
  
  6) There will shortly be an exciting press release about the forthcoming elections.
   This might make today a good day to bury the bad news of Pandra\'s premature 
   demise.\b  
  
  7) A picture of Pandra is appended to the last page.<<pandraPicture.discover>>"
  
  dobjFor(Read)
  {
    preCond = static inherited + objHeld
    action() { inherited; hasBeenRead = true; }
  }  
  hasBeenRead = nil
  cannotWriteOnMsg = &doNotDefaceMsg
  cannotDrawOnMsg = &doNotDefaceMsg
  shouldNotBreakMsg = 'That would not be a good idea. '
  properPlace = brownEnvelope
  sightSize = small
;

++ pandraPicture : Hidden, Component, StopEventList 'picture/photo/photograph/pandra' 'picture'
  "<<doScript>>"  
  cannotWriteOnMsg = &doNotDefaceMsg
  cannotDrawOnMsg = &doNotDefaceMsg
  eventList = [
   'The face in the picture is yours. ',
   
   'It\'s your face in the picture, all right, no doubt about it. As you stare
    at it a second time memories start to stir. ',
    
   'It\'s undoubtedly your face in the picture. ' 
  ]
  sightSize = small
  bulk = 0
  weight = 0
;
  
whiteEnvelope : Envelope 'square white envelope*envelopes' 
  'square white envelope'  
  "It's addressed to THE GOVERNMENT BROADCASTING DIRECTORATE and
   marked <FONT COLOR=RED>URGENT</FONT>. "
   dobjFor(Open)
   {
     action()
     {
       inherited;
       motorBike.startDaemon();       
     }
   }
   shouldNotBreakMsg = 'You decide you\'d rather keep it intact. '
   properPlace = wireBasket
;

+ greenLetter : Readable, PaperSurface 'green sheet/letter/piece/paper' 'green sheet of paper'
  "The letter reads:\b
   <FONT COLOR=RED>URGENT</FONT>\b
   The following press release has been cleared by the Directorate of the Department
   of Applied Rationality and is to be broadcast to all citizens by ALL available
   channels as a matter of UTMOST PRIORITY.\bPlease ensure that the contents
   of the document enclosed with this note are published and broadcast 
   IMMEDIATELY on receipt on this note.\b
   (signed) Professor B.A. Dunderhead<.p>"
   cannotWriteOnMsg = &doNotDefaceMsg
   cannotDrawOnMsg = &doNotDefaceMsg
   dobjFor(Read) { preCond = static inherited + objHeld }
   dobjFor(Examine) { preCond = static inherited + objHeld }
   shouldNotBreakMsg = 'You hesitate to destroy it, feeling that you might
    be able to put it to some use. '
    sightSize = small
;

+ pressRelease : Readable, PaperSurface 'press release' 'press release'
  "<b>URGENT PRESS RELEASE</b>\b
  ELECTION ARRANGEMENTS -- GOOD NEWS!\b
  Citizens will be delighted to learn that arrangements for tomorrow's general
  election have been rationalized and simplified, making it easier for all
  concerned.\b
  A panel of expert psephologists employed by the Department of Applied Rationality
  have calculated what the outcome of the election would be assuming all our citizens
  vote rationally. The government know that they can totally trust the rationality
  of all our citizens. We thus know how you will vote without your even having to bother!\b
  This is <i>fantastically</i> good news for all of us because:\n
  (1) we can be sure of a rational outcome to the election;\n
  (2) our psephologists have already ensured that <i>your</i> wishes will be acurately reflected
   in the results;\n
  (3) you do not have to spend hours of your time assessing the various candidates,
   freeing you to work on tasks in your own area of expertise;\n
  (4) you do not even have to bother to vote to get the government you want!\b
  Thanks to this breakthrough in Rational Democracy, there will be a few minor changes
  to tomorrow's voting arrangements. The principal one is that NO POLLING STATIONS
  WILL BE OPEN, since they have now become redundant. So please DO NOT go to your
  polling station -- your vote has already been pre-counted by government experts.<.p>"
  cannotWriteOnMsg = &doNotDefaceMsg
  cannotDrawOnMsg = &doNotDefaceMsg
  dobjFor(Read) { preCond = static inherited + objHeld }
  dobjFor(Examine) { preCond = static inherited + objHeld }
  shouldNotBreakMsg = 'If you want to destroy this press release, you\'d better find a way
   to do it thoroughly and irreversibly. '
  sightSize = small 
;

corridor : Room 'Corridor' 'the corridor'
  "If you reach this corridor something has gone wrong!"
  south = receptionArea
;  
  
motorBike : Heavy, Chair 'large black motor bike/cycle/motorbike/seat/cycle/motorcycle/machine'
   'motorbike'
  "It looks a powerful machine, with shiny handlebars in front of the seat
   and a large black pouch behind. "
  specialDesc = "A large black motorbike is parked by the side of the road. "
  daemonID = nil
  startDaemon()
  {
    if(!moved && daemonID==nil)
        daemonID = new Daemon(self, &daemon, 1);
  }
  daemon()
  {
    if(gPlayerChar.getOutermostRoom not in (departmentRoad, departmentGarden, receptionArea,
      prisonRoad, avenue) && brownEnvelope.moved)
    {
      moveInto(departmentRoad);
      biker.moveIntoForTravel(receptionArea);
      receptionist.setCurState(receptionistBikerState);
      guardian.moveIntoForTravel(avenue);
      guardian.posture=standing;
      guardian.setCurState(guardianWatching);     
      guardian.scriptedTravelTo(prisonRoad);
      daemonID.removeEvent();
      daemonID = nil;
    } 
  }
;   

+ pouch : OpenableContainer, Component 'large black pouch' 'black pouch'
  "The pouch is marked <i>Government Courier Service</i>. "
  notifyInsert(obj, newCont)
  {
    if(obj==whiteEnvelope)
    {
      "Just as you push the white envelope into the pouch, a man emerges from the
       tall white building wearing black leather motorcycle gear and donning his
       helmet. ";
       if(gPlayerChar.isIn(motorBike)) nestedAction(Out);
       "You step smartly away from the bike to avoid appearing to interfere
       with it. Fortunately, the despatch rider does not seem to notice you; instead
       he thrusts another batch of envelopes into the pouch, fastens it, then leaps
       onto his bike and goes roaring away into the distance.\b
       You watch as he reaches the pole barrier, and then as the barrier is raised
       and he goes racing on his way, presumably to deliver the white envelope along
       with the rest.<.p>";
       motorBike.moveInto(nil);
       biker.moveIntoForTravel(nil);
       bikeCheck();
    }
  }
;
 
+ Component 'shiny handlebars' 'handlebars'
  "The handlebars are mounted on the bike just in front of the seat. "
  isPlural = true
  dobjFor(Turn){
    preCond = [touchObj]
    verify() { }
    action {
      "{You/he} turn{s} the handlebars, but this doesn't seem to achieve much. ";
    }
  }
;
 
 
/* Function to check the result of the biker delivering the mail */ 
  
bikeCheck()
{
  "As the motor bike vanishes into the distance, ";
  if(!document.isIn(whiteEnvelope))
  {
     "you wish you'd thought a bit more about what to put in that white envelope;
      as it is you realize you may just have blown your last chance at hitting
      back at the government.<.p>";

      endGame(ftFailure);
  }
  if(coverPage.isIn(whiteEnvelope))
  {
     "it suddenly occurs to you that you left the covering letter -- the one saying
      that the Pandra document must <i>not</i> be published -- in the envelope. With
      a sickening, sinking feeling you realize that you've just made a total mess
      of your only chance to strike back.<.p>";

      endGame(ftFailure);
  }  
  if(!greenLetter.isIn(whiteEnvelope))
  {
     "you realize that the chances of Government Broadcasting Directorate
      publishing the contents of the Pandra document would have been a
      good deal better if you had included the green sheet of paper.<.p>";
      addToScore(1, 'sending the Pandra document to the Broadcasting Directorate');

      endGame(ftGameOver);
  }
  if(pressRelease.isIn(whiteEnvelope))
  { 
     "it occurs to you that it would have been far better not to have left the
      press release in the envelope along with the green sheet of paper and the Pandra
      document. Tomorrow's non-election would have been far more embarrassing
      for the government without the press release preparing the way, and there's
      a risk that the Broadcasting Directorate will realize that the Pandra
      document shouldn't have been included in the envelope at all.<.p>";
      addToScore(2, 'sending the Pandra document to the Broadcasting Directorate
       with the covering note');

      endGame(ftGameOver);
  }
  else
    {
       "you feel quietly confident that the sensitive document describing Pandra's
       change of heart will soon be public knowledge. As an added
       bonus, the press release about tomorrow's elections will not be published,
       so that voters turning up at closed polling stations will be stirred up all
       the more.\b
       Maybe, just maybe, the public will start to lose confidence in the New
       Enlightenment project. Maybe you can draw a square circle on a sphere,
       but as you look round the sun-swept hills and feel a fresh breeze blow in
       your face, you become increasingly convinced that the New Englightenment is 
       ultimately as doomed as trying to draw a square circle on a flat sheet of paper. ";
       if(hermit.isIn(avenue))
         "<.p>Just before the motorbike finally disappears out of sight you hear a
         distant bang. You hope it's the bike misfiring, and not another shot.
         But you remember {the hermit/he} disappearing out of sight with the
         guardian, and the guardian's grip on his machine pistol, and you hope
         against hope that {the hermit/he} has not paid too high a price to
         secure your triumph.\b";
       victoryAchievement.awardPointsOnce();

       endGame(ftVictory);      
    }
  
}

victoryAchievement : Achievement { +4 "ensuring the publication of the Pandra document" }
;

 /* The biker is such a basic NPC that we don't bother to give him a separate file */


biker : Person 'young despatch biker/rider/man/courier' 'despatch rider'
  "He's dressed in black leathers and a motorbike helmet. "
  isHim = true
;

+ bikerTalkingState : HermitActorState
  stateDesc = "He's busily talking to the receptionist. "
  specialDesc = "A despatch rider is standing by the desk, deep in
   conversation with {the receptionist/her}. "
  isInitState = true
  noResponse = "He ignores you, probably because he's more interested
   in talking with {the receptionist/her}. "
  afterAction()
  {
    if(whiteEnvelope.isIn(wireBasket))
    {
      "The despatch rider finally finishes talking with {the receptionist/her}
       and scoops up the contents of the wire basket, then turns and walks
       briskly out.<.p>";
       foreach(local cur in wireBasket.contents)
          cur.moveInto(biker);
       biker.moveIntoForTravel(departmentRoad);
       biker.setCurState(bikerRidingState);
       receptionist.setCurState(recepSitting);
       
    }
  } 
;

+ bikerRidingState : HermitActorState
  stateDesc = "He's standing by his bike. "
  specialDesc = "The despatch rider is standing by his bike, adjusting his
   helmet and the strap on the bike's pouch. "
  afterAction()
  {
    if(gActor==gPlayerChar)
    {
     whiteEnvelope.moveInto(nil);    
     nestedActorAction(getActor, SitOn, motorBike);
     "The despatch rider starts the bike, and then with its engine roaring,
     rides it rapidly down the road towards the barrier. After a brief
     check, the barrier is raised, allowing him through, and he continues
     on his way. ";
     motorBike.moveInto(nil);
     bikeCheck();
    }
  } 
  
;

escapeRoom : OutdoorRoom 'Edge of Forest' 'the edge of the forest'
  "A broad path back into the forest lies to the west, otherwise the
   countryside lies wide open in every direction, stretching
   towards a low range of hills on the eastern horizon. "
  east = escapeConnector  
  southeast = escapeConnector
  northeast = escapeConnector
  
  north : FakeConnector { "You could go that way, but there doesn't seem
   to be much point; it would just take you along the edge of the forest. "; }
   
  south: FakeConnector { "There doesn't seem to be much point in heading 
   off to the south; pretty soon you'll come to the river, and it's far
   from obvious you'll be able to find a way to cross it. "; }
  
  west : TravelMessage {
    -> forestClearing
    "You retrace your steps through the forest paths and tracks and
     eventually arrive back at a large, familiar clearing. "
  }
  atmosphereList : EventList {
  [
    'Looking round, you realize you have reached the point of decision. You
     could, even now, turn back and try to strike a blow against the New 
     Enlightenment, risky though that might prove, or you could turn your
     back on all your past, walk away, and seek a new life somewhere else. '
  ]}
  enteringRoom(traveler)
  {
    daylight.time = dusk;
  }
;

+ Distant 'low green distant western range/hills/horizon/slopes' 'hills'
  "The distant green hills scretch across the horizon, beckoning you on
   to climb their slopes and discover what lies on the far side. "
  isPlural = true
;

+ Fixture 'thick forest/trees' 'forest'
  "The thick forest lies directly to the west, its border stretching north and
  south almost as far as you can see. "
  dobjFor(Enter) remapTo(West)
;

+ Fixture 'series open countryside/fields' 'countryside'
  "A series of open field stretches eastwards towards a low range of
   hills on the horizon. It looks like it would a long, bracing but
   not particularly arduous walk to cross the fields to the the hills. "
;



escapeConnector : OneWayRoomConnector
  ->homefree
  
  canTravelerPass(traveler)  { return boots.wornBy == traveler; }
  explainTravelBarrier(traveler)
  {
    "Although it looks like a fairly easy walk over pretty even ground, you really
     don't fancy setting out on such a long trek with bare feet. ";
  }
;

homefree : OutdoorRoom 'Walking Across Open Fields'
  desc()
  {
    "You set off across the fields in quest of a new life. For a moment you
     feel a nagging doubt that you should, after all, have turned back and
     tried to do something to sabotage the New Enlightenment project; but
     then what could you, one person alone, have done against the system?
     You brush the doubt aside, telling yourself that it's too late for
     doubts, too late for regrets, your mind is made up and you must stand by
     your decision.\b
     As you walk on, the circular disc of the reddening sun is already dropping
     to the western horizon behind you. When you pause to turn back for a
     moment, it's already starting to disappear behind the forest, and for
     that moment some trick of vision makes it look almost square.\b
     You chuckle to yourself, turn again, and continue on your way. You've
     done with square circles -- for good.\b";
     addToScore(2, 'getting clean away');
     finishGameMsg('YOU HAVE ESCAPED YOUR PAST', [finishOptionUndo, finishOptionCredits,
     finishOptionFullScore]);
  
  }
;