#charset "us-ascii"

/*
 *  TADS 3 Library Extension: AutoSave (US-English implementation).
 *  Version: April 11, 2005.
 *
 *  Copyright 2004-2005 by Michel Nizette.
 */

#include <tads.h>
#include <adv3.h>
#include <en_us.h>


/*
 *  English syntax for the command RETRY.
 */
VerbRule(Retry)
  'retry'
  : RetryAction

  verbPhrase = 'retry/retrying the current challenge'
;


/*
 *  Text, response keyword, and response key for the RETRY end-of-game option.
 */
modify finishOptionRetry
  desc = "<<aHrefAlt('retry', 'RETRY', 'RE<b>T</b>RY',
                     'Retry the last challenge')>> the last challenge"
  responseKeyword = 'retry'
  responseChar = 't'
;


/*
 *  English syntax for the command RETRY SHOW, including less acurate but
 *  intuitive phrasings.
 */
VerbRule(RetryShow)
  'retry' ('show' | 'shown' | 'on' | 'verbose')
  : RetryShowAction

  verbPhrase = 'enable/enabling challenge notifications'
;


/*
 *  English syntax for the command RETRY HIDE, including less acurate but
 *  intuitive phrasings.
 */
VerbRule(RetryHide)
  'retry' ('hide' | 'hidden' | 'off' | 'quiet')
  : RetryHideAction

  verbPhrase = 'disable/disabling challenge notifications'
;
