!*** NEW VERBS --------------------------------------------------------------

! Some grammar, such as "remove" needs to come before default library
! grammar. For this reason, if we have a reason to extend a verb, be sure
! to include the syntax in its entirety, so that it all works right.

xverb "setmenu"
    * "on"      DoMenuOn
    * "off"     DoMenuOff

xverb "walkthrough", "walkthru", "walk-thru", "walk-through", "solution"
    *           DoWalkthru

xverb "xyzzy"
    *           DoXyzzy

xverb "plugh"
    *           DoPlugh

xverb "about"
    *           DoAbout

xverb "help"
    * "me"      DoHelp
    *           DoHelp

xverb "hint", "tip", "clue"
    * "for"/"about" held            DoHint
    * "for"/"about" "object" held   DoHint
    * "object" held                 DoHint
    * held                          DoHint
    *                               DoHint

verb "wake"
    *                                        DoVague
    * "up"                                   DoWake
    * "up" living                            DoWake
    * living "up"                            DoWake
    * living                                 DoWake

verb "rouse", "awake", "awaken"
    *                                        DoVague
    * living                                 DoWake

!Replaces "read" so that we can separate "read" from look" when needed"
verb "read", "peruse"
    *                                 DoVague
    * readable                        DoRead

!Replaces "throw" from the "verbstub.g" file to be a little more robust.
verb "throw", "hurl", "toss", "pitch", "chuck", "chunk", "lob", "fling"
    *                                                     DoVague
    * held "at"/"to"/"toward"/"into"/"in" xobject         DoThrowAt
    * held                                                DoThrowAt

!Added to mimic "get" -- because some places say "you're not HOLDing that.."
verb "hold", "collect"
    * held "to"/"against" xobject    DoTouchReverse
    * multi                          DoGet

verb "fix", "repair"
    *                                DoVague
    * object "with"/"using" held     DoRepair
    * object                         DoRepair

!Not a replacement to "look" -- just another implemenation of it.
verb "inspect"
    * object                         DoLook

!This is from VerbStub, which we're not using for this game.
verb "push", "shove", "press"
    *                                       DoVague
    * "on" object                           DoPush
    * held "to"/"against" xobject           DoTouchReverse
    * object                                DoPush

!This is from VerbStub, which we're not using for this game. Also, the
!versions with "parent" were adding to make it easier to "pull spike from..."
verb "pull", "yank", "tug"
    *                                                   DoVague
    * multi "from"/"off"/"on"/"in" parent               DoGet
    * multi "offof"/"outof" parent                      DoGet
    * multi "from" "offof"/"outof"/"on"/"in" parent     DoGet
    * "on" object                                       DoPull
    * object                                            DoPull

!For this game, we'll be cutting or tearing something with a sharp object
!that we're not actually holding. So, I needed to extend this verb.
verb "cut", "slice", "chop", "sever", "slash"
    *                                             DoVague
    * cuttable "with"/"using"/"on"/"at" xobject   DoCut
    * cuttable                                    DoCut

verb "stab", "poke"
    *                                             DoVague
    * object "with"/"using" held                  DoStab
    * held "at"/"toward"/"to"/"on" object         DoStabReverse
    * object                                      DoStab

!Basically the same handler as "cut" for the purposes of this game.
verb "rip", "tear", "shred", "split"
    *                                             DoVague
    * rippable "with"/"using"/"on"/"at" xobject   DoRip
    * rippable                                    DoRip

!Basically support bandage, wrap, etc.
verb "wrap", "bandage", "cover"
    *                                             DoVague
    * object "in"/"with"/"using" held             DoWrapReverse
    * held "on"/"around" object                   DoWrap
    * object                                      DoWrap

!The one from VerbStub wasn't quite right, so using this instead. Basically,
!it's normal DoTie usage, except where we try to tie something "around" in
!which case then what we're really attempting to do is wrap the thing.
verb "tie", "lash", "attach"
    *                                       DoVague
    * held "to"/"on" xobject                DoTie
    * object "with"/"using" held            DoTieReverse
    * held "around" xobject                 DoWrap
    * object                                DoTie

verb "untie", "unlash"
    *                                       DoVague
    * object "from" "around" xobject        DoUnTie
    * object "from" xobject                 DoUnTie
    * object                                DoUnTie

verb "unwrap", "unbandage"
    *                                       DoVague
    * object "from" "around" xobject        DoUnWrap
    * object "from" xobject                 DoUnWrap
    * object                                DoUnWrap

!Add a special condition so we can use the terminal without the menu.
!Basically, this is done so that we can use PLAYBACK, even though it's
!very unlikely players are ever going to figure out this alternative.
verb "touch", "tap"
    * "number"/"option"/"opt"/"menu"/"choice" number "with"/"using" held DoTouchOpt
    * "number"/"option"/"opt"/"menu"/"choice" number                     DoTouchOpt

!Original definition was in VerbStub, which isn't included.
verb "touch", "tap"
    *                                             DoVague
    * "anywhere"                                  DoVague
    * "anywhere" "on" object                      DoTouch
    * "anywhere" "on" object "with"/"using" held  DoTouch
    * held "anywhere" "to"/"on"/"against" xobject DoTouchReverse
    * held "to"/"against" xobject                 DoTouchReverse
    * object "with"/"using" held                  DoTouch
    * object "anywhere" "with"/"using" held       DoTouch
    * object "anywhere"                           DoTouch
    * object                                      DoTouch

verb "feel", "rub",
    * object                                DoTouch

verb "chisel", "carve"
    *                                       DoVague
    * object "with"/"using" held            DoChisel
    * object                                DoChisel

verb "search"
    *                                               DoVague
    * "for" anything                                DoVague
    * "under"/"underneath"/"beneath"/"below" object DoLookUnder
    * "in"/"around" object                          DoSearch
    * object                                        DoSearch

verb "pry"
    *                                             DoVague
    * object "with"/"using" held                  DoPry
    * "on" object "with"/"using" held             DoPry
    * object                                      DoPry

!This doesn't always work right. When normal verbs return false there is
!still history in the buffer even though it's not recorded via MAIN, and
!parsed pronouns insert all adjectives and a noun, which looks odd. So,
!this will have to wait until later, when maybe I can figure it out better.
!!
!! xverb "hist", "history"
!!     *          DoCommandHist

!This extends the default "remove" so that we can basically untie the
!netting ribbon from the spike. It's not of general use, but necessary
!to avoid a possible guess-the-verb situation.
!
!verb "remove"
!    *                                            DoVague
!    * cuttable "from" xobject                    DoUnwrap
!    * rippable "from" xobject                    DoUnwrap
!    * multi "from"/"outof"/"offof" parent        DoGet
!    * (undersuit)                                DoTakeOff
!    * multi                                      DoGet
!
!Update -- grammar conflicts, so had to add a "DoRemove" that basically is
!a stub that calls DoGet, DoUnwrap, or DoTakeOff as appropriate!
verb "remove"
    *                                            DoVague
    * object "from" "around" xobject             DoUnwrap
    * multi "from"/"outof"/"offof" xobject       DoRemove
    * multi                                      DoRemove

verb "jump", "leap"
    *                                            DoJump
    * "over"/"across" object                     DoJump
    * object                                     DoJump

verb "swing", "twirl"
    *                                            DoVague
    * held                                       DoSwing
    * held "around"                              DoSwing
    * held "around" "at"/"toward"/"to" xobject   DoSwing
    * held "at"/"toward"/"to" xobject            DoSwing

!Replaces "climb" from the "verbstub.g" file
!Added "over" and "across" as a words
verb "climb", "scale", "ascend"
    *                                            DoVague
    * "in"/"into"/"inside" object                DoEnter
    * "in"/"inside"                              DoEnter
    * "on"/"onto" object                         DoClimb
    * "up"/"down"/"over"/"across" object         DoClimb
    * "over"/"across" object                     DoClimb
    * object                                     DoClimb

verb "point", "aim"
    *                                            DoVague
    * object                                     DoPoint
    * object "at"/"toward"/"to" xobject          DoPoint


verb "listen"
    *                                            DoListen
    * "to"/"toward"/"for" object                 DoListen
    * direction                                  DoListen

verb "chase", "follow"
    *                                            DoChase
    * "after" anything                           DoChase
    * anything                                   DoChase
