/* sglk.c: sglk extensions to glk
        for GlkDOS, curses.h/allegro implementation of the Glk API
    Designed by L. Ross Raszewski <lraszewski@justice.loyola.edu>
    
    based upon GlkTerm by Andrew Plotkin <erkyrath@netcom.com>
    http://www.eblong.com/zarf/glk/index.html
*/
#ifndef SGLK
#define SGLK

#define SGLK_BOLD       1
#define SGLK_ITAL       2
#define SGLK_FIXED      4
#define SGLK_REVERSE    8
#define SGLK_DIM        16
#define SGLK_DEFAULT    0xffffffff

#define SGLK_GRAPHICS   1
#define SGLK_SOUND      2

void sglk_set_style(strid_t, glui32,glui32,glui32);
void sglk_get_default_colors(glui32 *fg, glui32 *bg);
void *sglk_get_image(winid_t,glsi32,glsi32,glui32,glui32);
void sglk_delete_image(void *b);
glui32 sglk_image_draw(winid_t win, void *b, glsi32 val1, glsi32 val2);
glui32 sglk_image_draw_scaled(winid_t win, void *b, 
    glsi32 val1, glsi32 val2, glui32 width, glui32 height);
glui32 sglk_color_distinguish(glui32 c1, glui32 c2);
glui32 sglk_color_distinguish_graphics(glui32 c1, glui32 c2);
void sglk_request_abilities(glui32 a);
void sglk_set_basename(char *s);
#endif
