/* sglk.c: sglk extensions to glk
        for GlkDOS, curses.h/allegro implementation of the Glk API
    Designed by L. Ross Raszewski <lraszewski@justice.loyola.edu>
    
    based upon GlkTerm by Andrew Plotkin <erkyrath@netcom.com>
    http://www.eblong.com/zarf/glk/index.html
*/

#include <stdio.h>
#include "cscr.h"
#include "glk.h"
#include "glkdos.h"
#include "sglk.h"
#include "gtpref.h"
#include "gtw_buf.h"

// External definitions
chtype tocursescolor(int);
glui32 toglkcolor(char);
void glkdos_set_basename(char *);
void *gli_get_image(winid_t win, glsi32 x, glsi32 y, glui32 w, glui32 h);
void *gli_free_bitmap(void *);
int colorcvt(glui32 col);

 

// Can the given colors be distinguished in a graphics window?
glui32 sglk_color_distinguish_graphics(glui32 c1, glui32 c2)
{
 int a,b;
 a=colorcvt(c1);
 b = colorcvt(c2);
 return a!=b;
}

// Can the given colors be distinguished in a text window?
glui32 sglk_color_distinguish(glui32 c1, glui32 c2)
{
 int a,b;
 a=tocursescolor(c1);
 b = tocursescolor(c2);
 return a!=b;
}

// tweak style
void sglk_set_style(strid_t str, glui32 f, glui32 b, glui32 a)
{
 winid_t win = str->win;
 if (!win) return;
 if (win->style == style_USECOLOR && f == SGLK_DEFAULT && b == SGLK_DEFAULT &&
        a == 0)
 {   win->style=win->real_style;
     return;
 }
 if (win->style!=style_USECOLOR)
  win->real_style=win->style;

 if (f == SGLK_DEFAULT)
  win->fg=cscr_color_to_8bit(win->winstyle[win->real_style]) & 0x0f;
 else 
  win->fg=tocursescolor(f);
 if (b == SGLK_DEFAULT)
  win->bg=cscr_color_to_8bit(win->winstyle[win->real_style]) >> 4;
 else 
  win->bg=tocursescolor(b);
 win->style=style_USECOLOR;
 if (a & SGLK_REVERSE)
 {
   win->bg ^= win->fg;
   win->fg ^= win->bg;
   win->bg ^= win->fg;
 }
 if (a & SGLK_DIM)
  win->fg &= ~0x8;
 if (a & SGLK_BOLD)
  win->fg |= 0x8;

}

// Get default colors
void sglk_get_default_colors(glui32 *fg, glui32 *bg)
{
 glui32 f,b;
 f = toglkcolor(glk_preferences[pref_fg_color]);
 b = toglkcolor(glk_preferences[pref_fg_color]);
 if (glk_preferences[pref_normalize_wipe])
  b = toglkcolor((cscr_color_to_8bit(win_textbuffer_styleattrs[style_Normal]) & 0xf0) >> 24);
 if (fg) *fg = f;
 if (bg) *bg = b;
}

// Get the contents of a graphics window
void *sglk_get_image(winid_t win, glsi32 x, glsi32 y, glui32 w, glui32 h)
{
 if (win->type != wintype_Graphics)
  return NULL;
 return gli_get_image(win,x,y,w,h);
}

// Free a graphics capture
void sglk_delete_image(void *b)
{
 if (b)
  gli_free_bitmap(b);
}

void sglk_set_basename(char *s)
{
 glkdos_set_basename(s);
}
int sglk_abilities;
void sglk_request_abilities(glui32 a)
{
 sglk_abilities=a;
}
