//---------------------------------------------------------------------------

#ifndef glkclassH
#define glkclassH

#include <Classes.hpp>
#include "RichEdit20.h"
#include "grid.h"

#define WINMETHOD_ABOVE 1
#define WINMETHOD_BELOW 2
#define WINMETHOD_LEFT 4
#define WINMETHOD_RIGHT 8
#define WINMETHOD_FIXED 16
#define WINMETHOD_PROPORTIONAL 32

#define WINTYPE_BLANK 0
#define WINTYPE_TEXTBUFFER 1
#define WINTYPE_TEXTGRID 2
#define WINTYPE_GRAPHICS 3

//---------------------------------------------------------------------------
struct WINDOW{
  TRichEdit20 *textbuffer;
  TEXTGRID *textgrid;
  TControl *window;
  int split, method,size,wintype,rock;
  TFont *font;
};

class GLK
{            
private:
  bool insert;
  bool char_input;
  wchar_t key_pressed[2];
  OSVERSIONINFO win_version;
  void *args[5];
  int win_count;
  WINDOW window[10];

  void plant_args(void *argv0,void *argv1,void *argv2,void *argv3,void *argv4);
  void dig_args(void *argv0,int size0,void *argv1,int size1,void *argv2,int size2,void *argv3,int size3,void *argv4,int size4);

  int font_width(TFont *font);
  int font_height(TFont *font);
  bool arrange_windows(int new_win,int &left,int &top,int &width,int &height);

  void __fastcall WindowOpen();

public:
  GLK(bool CreateSuspended);
  ~GLK();
  void resize_redraw();

  int window_open(int split,int method,int size,int wintype,int rock);
  void window_get_size(int win,int &width,int &height);

  TFont *textbuffer_font,*textgrid_font;
  TColor back_color;
  bool mored;
  int left_margin,right_margin;
  unsigned char version;
};


//---------------------------------------------------------------------------
#endif
