//===========================================================================
// Copyright  1998 Thin Air Enterprises and Robert Dunn
//===========================================================================
//---------------------------------------------------------------------------
// TRichEdit20 implementation                                                 
//---------------------------------------------------------------------------
//#include <vcl\vcl.h>
#include <vcl.h>
#include <registry.hpp>
#include <algorithm.h>                            
#include <vcl\comctrls.hpp>
#include <vcl\comobj.hpp>
#include <vcl\ole2.hpp>
#include <vcl\oledlg.hpp>
#include <richole.h>
#pragma hdrstop

#include "richedit20.h"
#include "Main.h"
#include "glkthread.h"
#include "margins.h"

#ifdef MAX_TAB_STOPS
#undef MAX_TAB_STOPS
#define MAX_TAB_STOPS 32
#endif


typedef struct tagTPageOffset {
        long int Start;
        long int End;
        RECT rendRect;
        } TPageOffsets;

extern GLK *glk;

const CHARRANGE set_range={246913578,246913579};

//---------------------------------------------------------------------------
__fastcall TRichEdit20::TRichEdit20(TComponent* Owner,int tag,int left_margin,int right_margin,bool borders,bool scrollbar)
#ifdef USERICHEDITOLE
	: TRichEdit(Owner), FInsertMode(true), FOnInsertChange(0),
		FRichEditOle(0), FAutoUrlDetect(true), FSelAttributes2(0),
		FDefAttributes2(0)
#else
	: TRichEdit(Owner), 
		FSelAttributes2(0), FDefAttributes2(0)
#endif
{
	// allocate text attribute members
	FSelAttributes2 = new TTextAttributes2(this, atSelected);
	FDefAttributes2 = new TTextAttributes2(this, atDefaultText);
	FParaAttributes2 = new TParaAttributes2(this);

  Visible=false;
  Parent=MainForm;
  Tag=tag;
  HideScrollBars=false;
  HideSelection=false;
  OnEnter=OnFocus;
  OnMouseDown=on_MouseDown;
  OnSelectionChange=on_SelectionChange;
  OnMouseWheel=on_MouseWheel;
  OnMouseWheelUp=on_wheel_up;
  OnMouseWheelDown=on_wheel_down;
  PopupMenu=MainForm->PopupMenu;

  history=new TStringList();
  hist_pos=-1;

  had_output=false;
  sel_change=false;

  Perform(EM_EXLIMITTEXT,0,0x7fffffff);
  Perform(EM_SETUNDOLIMIT,0,0);

//  Perform(EM_SETMARGINS,EC_LEFTMARGIN|EC_RIGHTMARGIN,MAKELONG(left_margin,right_margin));
  lmargin=left_margin;
  rmargin=right_margin;

  if (!borders){
    BorderStyle=bsNone;};

  if (scrollbar){
   ScrollBars=ssVertical;}
  else{
    ScrollBars=ssNone;};

  input_pos.cpMin=0;
  input_pos.cpMax=0;

  hyper_count=0;
  hyper_active=false;

}
//---------------------------------------------------------------------------
__fastcall TRichEdit20::~TRichEdit20()
{
	if (FSelAttributes2) delete FSelAttributes2;
	if (FDefAttributes2) delete FDefAttributes2;
	if (FParaAttributes2) delete FParaAttributes2;
  delete history;
}
//---------------------------------------------------------------------------
TRect TRichEdit20::TwipsToTargetRect(HDC hdc, TRect rect)
{
	int logx = ::GetDeviceCaps(hdc, LOGPIXELSX);
	int logy = ::GetDeviceCaps(hdc, LOGPIXELSY);

	TRect r;
	r.Left = ::MulDiv(rect.Left, logx, 1440);
	r.Top = ::MulDiv(rect.Top, logy, 1440);
	r.Right = ::MulDiv(rect.Right, logx, 1440);
	r.Bottom = ::MulDiv(rect.Bottom, logy, 1440);

	return r;
}
//---------------------------------------------------------------------------
// do stuff when creating/recreating window
//
void __fastcall TRichEdit20::CreateWnd(void)
{
	TRichEdit::CreateWnd();

	// set up ole callback
#ifdef USERICHEDITOLE
	FRichEditOle = new TIRichEditOle(this);
#endif

  DWORD dwMask = SNDMSG(Handle, EM_GETEVENTMASK, 0, 0);
  dwMask = dwMask | ENM_SCROLL;
  SNDMSG(Handle, EM_SETEVENTMASK, 0, dwMask);
  Perform(EM_SETMARGINS,EC_LEFTMARGIN|EC_RIGHTMARGIN,MAKELONG(lmargin,rmargin));
}
//---------------------------------------------------------------------------
// the following ensures that the new version of richedit (v2.0) is loaded;
// TRichEdit unloads the DLL that *IT* loads in the WM_NCDESTROY handler (which,
// disappointingly enough, is private rather than protected; damned if FLibHandle
// isn't also, or we could simply unload it later) but we do it in DestroyWnd()...
// (note:  do not call TRichEdit::CreateParams -- it will attempt to
// load the older version of the rich edit DLL -- not a Good Thing -- too bad
// if anything important goes on there)
//
void __fastcall TRichEdit20::CreateParams(Controls::TCreateParams &Params)
{
	const char RichEditModuleName[] = "RICHED20.DLL";
	long int OldError;

	OldError = SetErrorMode(SEM_NOOPENFILEERRORBOX);
	FLibHandle = (int) LoadLibrary(RichEditModuleName);
	if (FLibHandle < HINSTANCE_ERROR) FLibHandle = 0;
	SetErrorMode(OldError);
//	TRichEdit::CreateParams(Params);                         
	TCustomMemo::CreateParams(Params);
	CreateSubClass(Params, "RICHEDIT20W");
//	CreateSubClass(Params, RICHEDIT_CLASS);
//  strcpy(Params.WinClassName,"RICHEDIT20W");
	Params.Style = Params.Style |
		(HideScrollBars ? 0 : ES_DISABLENOSCROLL) |
		(HideSelection ? 0 : ES_NOHIDESEL);
}
//---------------------------------------------------------------------------
// free the library on destroy (actually, it will not unload until last
// TRichEdit20 instance is destroyed)
//
void __fastcall TRichEdit20::DestroyWnd(void)
{
#ifdef USERICHEDITOLE
	if (FRichEditOle) {
		delete FRichEditOle;
		FRichEditOle = 0;
		}
#endif

	TRichEdit::DestroyWnd();

	if (FLibHandle != 0) FreeLibrary((void*) FLibHandle);
}
//---------------------------------------------------------------------------
bool TRichEdit20::FindTextEx(WideString text, int startPos,
	TFindOptions findOptions, int& foundPos, int& foundLength)
{
	::FINDTEXTEXW ft;
	ft.chrg.cpMin = startPos;		// start pos for search
	ft.chrg.cpMax = -1;				// search all from start pos
	ft.lpstrText = text.c_bstr();	// better not modify!!!
	ft.chrgText.cpMin = -1;			// return start
	ft.chrgText.cpMax = -1;			// return end

	WPARAM flags = 0;
	if (findOptions.Contains(frDown)) flags |= FR_DOWN;				// and this is documented WHERE???
	if (findOptions.Contains(frMatchCase)) flags |= FT_MATCHCASE;	// apparently could use FR_MATCHCASE
	if (findOptions.Contains(frWholeWord)) flags |= FT_WHOLEWORD;	// apparently could use FR_WHOLEWORD

	int pos = ::SendMessage(Handle, EM_FINDTEXTEXW, flags, (LPARAM) (::FINDTEXTEX FAR *) &ft);

	if (pos != -1) {
		foundPos = ft.chrgText.cpMin;
		foundLength = ft.chrgText.cpMax - foundPos;
		}
	return pos != -1;
}
//---------------------------------------------------------------------------

bool TRichEdit20::insert_picture(TGraphic *picture,int width,int height,bool below_baseline)
{
if (glk->is_hyperlinking(Tag-1)){
  SETTEXTEX unicode_text;
  unicode_text.flags=ST_SELECTION;
  unicode_text.codepage=1200;
  wchar_t tmp[2];
  tmp[0]=' ';
  tmp[1]=0;
  Perform(EM_SETTEXTEX,(LONG)&unicode_text,(LONG)tmp);
  hypertext[hyper_count-1].end++;};

Graphics::TBitmap *bitmap=new Graphics::TBitmap();
bitmap->Width=width;
bitmap->Height=height;
TRect rect;
rect.left=0;
rect.top=0;
rect.right=width;
rect.bottom=height;
bitmap->Canvas->Lock();
bitmap->Canvas->StretchDraw(rect,picture);
bitmap->Canvas->Unlock();
bool result=InsertPicture(bitmap,below_baseline);
delete bitmap;

return (result);
};

//---------------------------------------------------------------------------
bool __fastcall TRichEdit20::InsertPicture(Graphics::TBitmap *bitmap,bool below_baseline)
{
        IDataObject* pDataObject;
        LPOLEOBJECT lpOleObject = NULL;
        LPSTORAGE lpStorage = NULL;
        LPOLECLIENTSITE lpOleClientSite = NULL;
        LPLOCKBYTES lpLockBytes = NULL;
        CLIPFORMAT cfFormat = 0;
        LPFORMATETC lpFormatEtc = NULL;
        FORMATETC formatEtc;
        LPRICHEDITOLE lpRichEditOle;
        LPUNKNOWN lpUnknown;
        REOBJECT reobject;
        CLSID clsid;
        SIZEL sizel;
        DWORD dwStart, dwEnd;

        CoInitialize(NULL);
        if( OpenClipboard(NULL) )
        {
                EmptyClipboard();
                SetClipboardData( CF_BITMAP, bitmap->Handle );
                CloseClipboard();
        }
        else
                return 0;
   
        OleGetClipboard(&pDataObject);
        if (pDataObject == NULL)
                return 0;
        CreateILockBytesOnHGlobal(NULL, TRUE, &lpLockBytes);
        if (lpLockBytes == NULL)
                return 0;

        StgCreateDocfileOnILockBytes(lpLockBytes,
STGM_SHARE_EXCLUSIVE|STGM_CREATE|STGM_READWRITE, 0, &lpStorage);
        if (lpStorage == NULL)
                return 0;

        lpFormatEtc = &formatEtc;
        lpFormatEtc->cfFormat = cfFormat;
        lpFormatEtc->ptd = NULL;
        lpFormatEtc->dwAspect = DVASPECT_CONTENT;
        lpFormatEtc->lindex = -1;
        lpFormatEtc->tymed = TYMED_NULL;

        SendMessage(Handle, EM_GETOLEINTERFACE, 0,
(LPARAM)&lpRichEditOle);
        if (lpRichEditOle == NULL)
                return 0;

        lpRichEditOle->GetClientSite(&lpOleClientSite);
        if (lpOleClientSite == NULL)
                return 0;

        OleCreateStaticFromData(pDataObject, IID_IUnknown,
OLERENDER_DRAW, lpFormatEtc, lpOleClientSite, lpStorage,
(void**)&lpOleObject);
        if (lpOleObject == NULL)
                return 0;

        lpUnknown = (LPUNKNOWN)lpOleObject;
        lpUnknown->QueryInterface(IID_IOleObject,(void**)&lpOleObject);
        lpUnknown->Release();
        OleSetContainedObject((LPUNKNOWN)lpOleObject, TRUE);

        ZeroMemory(&reobject, sizeof(REOBJECT));
        reobject.cbStruct = sizeof(REOBJECT);

        lpOleObject->GetUserClassID(&clsid);

        reobject.clsid = clsid;
        reobject.cp = REO_CP_SELECTION;
        reobject.dvaspect = DVASPECT_CONTENT;
        if (below_baseline)
          reobject.dwFlags = REO_BELOWBASELINE; //REO_RESIZABLE | REO_BELOWBASELINE;
        reobject.dwUser = 0;
        reobject.poleobj = lpOleObject;
        reobject.polesite = lpOleClientSite;
        reobject.pstg = lpStorage;

        sizel.cx = sizel.cy = 0;
        reobject.sizel = sizel;

        SendMessage(Handle, EM_SETSEL, 0, -1);
        SendMessage(Handle, EM_GETSEL, (WPARAM)&dwStart,(LPARAM)&dwEnd);
        SendMessage(Handle, EM_SETSEL, dwEnd+1, dwEnd+1);

        lpRichEditOle->InsertObject(&reobject);

        lpLockBytes->Release();
        lpStorage->Release();
        pDataObject->Release();
        lpRichEditOle->Release();
        lpOleClientSite->Release();
        lpOleObject->Release();
        CoUninitialize();

        OpenClipboard(NULL);
        EmptyClipboard();
        CloseClipboard();

        return 1; 

}
//---------------------------------------------------------------------------
// is this used/needed???
//
void __fastcall TRichEdit20::RecreateWnd(void)	// not virtual in base!!!
{
	TRichEdit::RecreateWnd();
}
//---------------------------------------------------------------------------
void __fastcall TRichEdit20::SetSelAttributes2(TTextAttributes2* attr)
{
	SelAttributes2->Assign(attr);
}
//---------------------------------------------------------------------------
void __fastcall TRichEdit20::SetDefAttributes2(TTextAttributes2* attr)
{
	DefAttributes2->Assign(attr);          
}
//---------------------------------------------------------------------------
void __fastcall TRichEdit20::OnFocus(TObject *Sender)
{
glk->check_focus(Tag);
};
//---------------------------------------------------------------------------
void __fastcall TRichEdit20::on_MouseDown(TObject *Sender,TMouseButton Button,TShiftState Shift,int X,int Y)
{
glk->active_win=Tag;
sel_change=true;

glk->MouseDownTextBuffer(Tag-1);

if (hyper_active){
  POINTL pos;
  pos.x=X;
  pos.y=Y;
  int loc=Perform(EM_CHARFROMPOS,0,(LONG)&pos);
  for (int i=0;i<hyper_count;i++){
    if (hypertext[i].start<=loc&&hypertext[i].end>=loc){
      hyper_active=false;
      glk->ProcessHyper(Tag-1,hypertext[i].linkval);
      return;};};};
};
//---------------------------------------------------------------------------

void __fastcall TRichEdit20::on_SelectionChange(TObject *Sender)
{
if (glk->double_click){
  glk->double_click=false;
  GETTEXTEX params;
  params.cb=200;
  params.flags=GT_SELECTION;
  params.codepage=1200;
  params.lpDefaultChar=NULL;
  params.lpUsedDefChar=NULL;
  wchar_t buffer[100];
  Perform(EM_GETTEXTEX,(LONG)&params,(LONG)buffer);
  WideString word=" ";
  word+=buffer;
  word+=" ";                            
  if (Trim(word).Length()!=0)
    glk->update_input(word);};
};
//---------------------------------------------------------------------------
void TRichEdit20::add_to_hist(String command)
{
history->Insert(0,command);
if (history->Count>100)
  history->Delete(100);
hist_pos=-1;
};
//---------------------------------------------------------------------------
void TRichEdit20::retrieve_hist(int pos)
{
if (pos==-1)
  glk->do_command("",false);
else
  glk->do_command(history->Strings[pos],false);
};
//---------------------------------------------------------------------------

void __fastcall TRichEdit20::post_output()
{
if (had_output){
  had_output=false;
  sel_change=false;

  Perform(WM_SETREDRAW,false,NULL);
  SetFocus();

  if (glk->moring){
    MSG message;
    Perform(WM_VSCROLL,SB_BOTTOM,0);
    unsigned int line1=Perform(EM_GETFIRSTVISIBLELINE,0,0);
    Perform(EM_EXSETSEL,NULL,(LONG)&input_pos);
    unsigned int line2=Perform(EM_GETFIRSTVISIBLELINE,0,0);
    bool scrolled=(line1!=line2&&!(line1==(line2+1)));

    while (scrolled&&!glk->more_cancel){
      Perform(WM_SETREDRAW,true,NULL);
      Repaint();

      MainForm->toggle_waittimer();
      glk->mored=true;
      EnableScrollBar(Handle,SB_VERT,ESB_DISABLE_BOTH);
      MainForm->toggle_menus(false);
      MainForm->StatusBar->Panels->Items[0]->Text="** MORE ** -- Press a key or click the mouse to continue";
      do{
        WaitMessage();
        PeekMessage(&message,Handle,NULL,NULL,PM_NOREMOVE);
        if (message.message==WM_KEYDOWN||message.message==WM_LBUTTONDOWN||message.message==WM_MBUTTONDOWN||message.message==WM_RBUTTONDOWN){
          GetMessage(&message,Handle,NULL,NULL);
          GetMessage(&message,Handle,NULL,NULL);
          break;}
        else{
          Application->ProcessMessages();};}      
      while (glk->mored&&!glk->more_cancel);
      Perform(WM_VSCROLL,SB_PAGEDOWN,NULL);
      unsigned int prev_pos=line2;
      line2=Perform(EM_GETFIRSTVISIBLELINE,0,0);
      if (prev_pos==line2)
        glk->more_cancel=true;
      scrolled=(line1!=line2);
      if (!glk->mored)
        return;};

    if (glk->mored){
      glk->mored=false;
      EnableScrollBar(Handle,SB_VERT,ESB_ENABLE_BOTH);
      MainForm->toggle_menus(true);
      MainForm->StatusBar->Panels->Items[0]->Text="";};}

  Perform(EM_EXSETSEL,NULL,(LONG)&set_range);
  Perform(EM_EXGETSEL,NULL,(LONG)&input_pos);

  if (input_pos.cpMin>60000){
    int old_len=input_pos.cpMin;
    Perform(WM_SETREDRAW,false,NULL);
    unsigned int del_point=Perform(EM_LINEINDEX,50,NULL);
    Perform(EM_SETSEL,0,del_point);
    Perform(EM_REPLACESEL,false,(LONG)"");
    Perform(EM_EXSETSEL,NULL,(LONG)&set_range);
    Perform(EM_EXGETSEL,NULL,(LONG)&input_pos);
    int change=old_len-input_pos.cpMin;
    for (int i=0;i<hyper_count;i++){
      hypertext[i].start-=change;
      hypertext[i].end-=change;
      if (hypertext[i].start<0){
        hypertext[i].start=0;
        if (hypertext[i].end<0){
          hyper_count--;
          for (int j=i;j<hyper_count;j++){
            hypertext[j]=hypertext[j+1];};
          i--;};};};};

  glk->more_cancel=false;
  Perform(WM_SETREDRAW,true,NULL);
  Repaint();
  Perform(WM_VSCROLL,SB_BOTTOM,NULL);}

else{
  Perform(WM_SETREDRAW,true,NULL);};
//  Repaint();};
};
//----------------------------------------------------------------------------

void TRichEdit20::clear(TColor color)
{
Color=color;
if (Lines->Count){
  if (glk->more_clear)
    post_output();
  Clear();
  input_pos.cpMin=0;
  input_pos.cpMax=0;
  hyper_count=0;};
};
//---------------------------------------------------------------------------

void __fastcall TRichEdit20::on_MouseWheel(TObject *Sender,TShiftState shift,int WheelDelta,const TPoint &MousePos,bool &Handled)
{
if (glk->mored)
  Handled=true;
};
//---------------------------------------------------------------------------

void __fastcall TRichEdit20::on_wheel_up(TObject *Sender,TShiftState Shift,const TPoint &MousePos,bool &Handled)
{
Perform(WM_VSCROLL,SB_LINEUP,NULL);
Handled=true;
};
//---------------------------------------------------------------------------

void __fastcall TRichEdit20::on_wheel_down(TObject *Sender,TShiftState Shift,const TPoint &MousePos,bool &Handled)
{
Perform(WM_VSCROLL,SB_LINEDOWN,NULL);
Handled=true;
};





//---------------------------------------------------------------------------
// end of TRichEdit20 implementation
//---------------------------------------------------------------------------
//===========================================================================
// Copyright  1998 Thin Air Enterprises and Robert Dunn
//===========================================================================

