/* infocom.c
 *
 *  ``pinfocom'' -- a portable Infocom Inc. data file interpreter.
 *  Copyright (C) 1987-1992  InfoTaskForce
 *  Modified 2003 by Nils Gesbert
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.  If not, write to the
 *  Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Header: RCS/infocom.c,v 3.0 1992/10/21 16:56:19 pds Stab $
 */

#define NO_SIGNALS

#include "infocom.h"
#include <args.h>

#define COPYRIGHT   "\n\
    This program comes with ABSOLUTELY NO WARRANTY.\n\
    This program is free software, and you are welcome to redistribute it\n\
    under certain conditions; see the file COPYING in the source directory\n\
    for full details.\n"

#ifndef CONTEXT
#define CONTEXT 2
#endif

#ifndef MAX_PAGE_ENTRIES
#define MAX_PAGE_ENTRIES    10 /* valeur pifomtrique. Plus c'est beaucoup plus le prg. utilise
				  de mmoire et moins il charge souvent depuis le fichier. */
#endif


/* Qques pointeurs qu'il faudra freer */
typedef struct
{
    word    page;
    byte    next;
    byte    prev;
} pg_table_t;
extern pg_table_t *pg_table;
extern print_buf_t text, room;

gflags_t    gflags;
byte        *base_ptr;
word        pc_page;
char        *ti_location;
char        *ti_status;
byte        *strt_vocab_table;
byte        *end_of_sentence;
word        *stack_var_ptr; /* a c'est le  frame pointer  */
print_buf_t *pbf_p;
byte        *prog_block_ptr;
/* Parat que c'est mal d'utiliser des variables globales, surtout pas initialises.
   eh ben on n'est pas sorti de l'auberge hein... */
/* J'en transforme certaines en macros, cf. infocom.h */
/* Il semble qu'en mettant les deux suivantes dans une mme structure on rduise
   pas mal la taille du prg. (200 octets ?????????????) */
#ifdef BIDOUILLE
struct {
#endif

word        pc_offset;
word        *stack;

#ifdef BIDOUILLE
} structure_magique;

#define pc_offset structure_magique.pc_offset
#define stack structure_magique.stack

#endif

char ws_table[] = { ' ','\t','\r','.',',','?','\0','\0' };

char table[] =
{
    'a','b','c','d','e','f','g','h','i','j','k','l','m',
    'n','o','p','q','r','s','t','u','v','w','x','y','z',
    'A','B','C','D','E','F','G','H','I','J','K','L','M',
    'N','O','P','Q','R','S','T','U','V','W','X','Y','Z',
    ' ',' ','0','1','2','3','4','5','6','7','8','9','.',
    ',','!','?','_','#','\'','"','/','\\','-',':','(',')',
    '\0','\0'
};

#include "titi.c"
#include "support.c"
#include "file.c"
#include "funcs.c"
#include "variable.c"
#include "input.c"
#include "jump.c"
#include "object.c"
#include "page.c"
#include "print.c"
#include "property.c"
#include "init.c"
#include "interp.c"

void _main () {
  ESI argptr;
  const char *sauvegarde = NULL;

#ifdef ALPHALOCK
  unsigned char c;
  alphaLockOn (&c);
#endif
  
    /* Allez il faut rinitialiser les pointeurs globaux*/
  base_ptr = NULL;
  pg_table = NULL;
  text.buf = NULL;
  room.buf = NULL;
  prog_block_ptr = NULL;

  nom_jeu = NULL;

  gflags.game_state = NOT_INIT;

  InitArgPtr (argptr);
  if (GetArgType (argptr) == STR_TAG) nom_jeu = GetStrnArg (argptr);
  if (GetArgType (argptr) == POSINT_TAG) srand (GetIntArg (argptr)); /* graine de chaos */
  else randomize();
  if (GetArgType (argptr) == STR_TAG) sauvegarde = GetStrnArg (argptr);


  /*
   * Open the game file, if possible...
   */

  nom_jeu = open_file (nom_jeu);
  
  if (nom_jeu == NULL) return;
  
  if (init()) {
    LCD_BUFFER buffer;
    LCD_save (&buffer);
    gflags.game_state = INIT_GAME;
    ClrScr();
    scr_setup();
    if (sauvegarde) rextore (sauvegarde);
    else change_status();

    interp();
    LCD_restore (&buffer);
  }
  else
    ST_helpMsg (gflags.game_state == NOT_INIT ? "pas assez de mmoire" : "erreur de chargement");

  if (base_ptr) free (base_ptr);
  if (pg_table) free (pg_table);
  if (text.buf) free (text.buf);
  if (room.buf) free (room.buf);
  scr_shutdown();
}
