package zpplet.data;

import zpplet.machine.ZMachine;
import zpplet.misc.*;

public class ZObjectTree4
		extends ZObjectTree
	{
	public ZObjectTree4(ZMachine zm)
		{
		super(zm);
		}

	protected int getEntryLoc(int obj)
		{
		return obj == 0 ? 0 : tree + (obj - 1) * 14;
		}

	protected int numProperties()
		{
		return 63;
		}

	public int getParent(int obj)
		{
		return obj == 0 ? 0 : zm.getWord(getEntryLoc(obj) + 6);
		}

	public int getSibling(int obj)
		{
		return obj == 0 ? 0 : zm.getWord(getEntryLoc(obj) + 8);
		}

	public int getChild(int obj)
		{
		return obj == 0 ? 0 : zm.getWord(getEntryLoc(obj) + 10);
		}

	public void setParent(int obj, int newparent)
		{
		if (obj != 0)
			zm.setWord(getEntryLoc(obj) + 6, newparent);
		}

	public void setSibling(int obj, int newsibling)
		{
		if (obj != 0)
			zm.setWord(getEntryLoc(obj) + 8, newsibling);
		}

	public void setChild(int obj, int newchild)
		{
		if (obj != 0)
			zm.setWord(getEntryLoc(obj) + 10, newchild);
		}

	public int getPropertyTableAddr(int obj)
		{
		return obj == 0 ? 0 : zm.getWord(getEntryLoc(obj) + 12);
		}
	
	public int getPropEntryAddr(int obj, int propnum)
		{
		if (obj == 0)
			return 0;
		int addr = getPropertyTableAddr(obj);
		addr += zm.getByte(addr) * 2 + 1;
		int sizebyte = zm.getByte(addr);
		while (sizebyte != 0)
			{
			int curpropnum = sizebyte & 0x3F;
			if (curpropnum == propnum)
				return addr;
			else if (curpropnum < propnum)
				return 0;
			
			int length; // includes size byte(s)
			if ((sizebyte & 0x80) != 0)
				{
				length = (zm.getByte(addr + 1) & 0x3F) + 2;
				if (length == 2) // entry of 0 means 64
					length += 64;
				}
			else
				length = (sizebyte >> 6) + 2;
			addr += length;
			sizebyte = zm.getByte(addr);
			}
		return 0;
		}

	public int getNextProp(int obj, int propnum)
			throws ZError
		{
		int addr;

		if (propnum == 0)
			{ // first property
			addr = getPropertyTableAddr(obj);
			if (addr == 0)
				throw new ZError(
						"Tried to get next property for object with no properties");
			addr += zm.getByte(addr) * 2 + 1;
			}
		
		else
			{
			addr = getPropEntryAddr(obj, propnum);
			if (addr == 0)
				throw new ZError(
						"Tried to get next property for nonexistent property");
			int sizebyte = zm.getByte(addr);
			int length;
			if ((sizebyte & 0x80) != 0)
				{
				length = (zm.getByte(addr + 1) & 0x3F) + 2;
				if (length == 2) // entry of 0 means 64
					length += 64;
				}
			else
				length = (sizebyte >> 6) + 2;
			addr += length;
			}

		return zm.getByte(addr) & 0x3F;
		}

	public int getPropAddr(int obj, int propnum)
		{
		int addr = getPropEntryAddr(obj, propnum);

		if (addr == 0)
			return 0;
		else if ((zm.getByte(addr) & 0x80) != 0)
			return addr + 2;
		else
			return addr + 1;
		}

	public int getPropLen(int addr)
		{
		if (addr == 0)
			return 0;

		int sizebyte = zm.getByte(addr - 1);
		if ((sizebyte & 0x80) != 0) // presumes a second size byte has bit 7 set
			return (sizebyte & 0x3F) == 0 ? 64 : sizebyte & 0x3F; 
		return (sizebyte >> 6) + 1;
		}
	}