/* glkstart.c: Unix-specific startup code -- sample file.
    Designed by Andrew Plotkin <erkyrath@netcom.com>
    http://www.eblong.com/zarf/glk/index.html

    This is Unix startup code for the simplest possible kind of Glk
    program -- no command-line arguments; no startup files; no nothing.

    Remember, this is a sample file. You should copy it into the Glk
    program you are compiling, and modify it to your needs. This should
    *not* be compiled into the Glk library itself.
*/

#include "glk.h"
#include "glkstart.h"
#include "ztypes.h"
#include <stdio.h>

extern int strictz_report_mode;
extern int strictz_error_count[STRICTZ_NUM_ERRORS];

glkunix_argumentlist_t glkunix_arguments[] = {
  { "", glkunix_arg_ValueFollows, "filename: The game file to load." },
  { "-strictz", glkunix_arg_NumberValue, "Error reporting mode (0-3)." },
  { NULL, glkunix_arg_End, NULL }
};

int glkunix_startup_code(glkunix_startup_t *data)
{
  int i;
  strictz_report_mode = STRICTZ_DEFAULT_REPORT_MODE;
  for (i = 0; i < STRICTZ_NUM_ERRORS; i++)
    strictz_error_count[i] = 0;

  for (i = 1; i < data->argc - 1; i++)
    if (strcmp(data->argv[i], "-strictz") == 0) {
      strictz_report_mode = atoi(data->argv[i + 1]);
      while (i < data->argc - 2) {
        data->argv[i] = data->argv[i + 2];
        i++;
      }
      data->argc -= 2;
      break;
    }

  if (data->argc != 2) {
    fprintf(stderr, "You must supply exactly one filename.\n");
    exit(1);
  }
  open_story(data->argv[1]);
  return TRUE;
}

