// Generated by CoffeeScript 1.7.1
var Run, all, commands, destroy, disambiguate, dividers, find, get, hear, heroes, lastMove, lastThanked, look, lookAt, neighbour, player, position, randomMove, recollection, replace, root, scanMap, see, spill, turn, visible, world;

lastMove = -1;

dividers = ["in", "on", "at"];

turn = 0;

lastThanked = 0;

Run = function(c) {
  var entrance, exit, i, input, o, object, objectText, sides, subject, subjectText, thing, things, verb, _i, _j, _k, _len, _len1, _len2, _ref, _ref1, _ref2, _ref3, _ref4, _ref5;
  if (player.hp <= 0) {
    location.reload();
  }
  if (c === "") {
    return;
  }
  if (turn === 60) {
    i = localStorage.length;
    localStorage["memory no. " + i] = c;
    Say("I understand.", "box monospace");
    player.hp = 0;
    transition.fadeVertical('transparent', 'black');
    return;
  }
  input = c.toLowerCase().split(' ');
  i = 0;
  while (i < input.length) {
    if (synonyms[input[i]]) {
      input[i] = synonyms[input[i]];
    }
    i++;
  }
  sides = null;
  if (sides) {
    i = sides[0].indexOf(' ');
    verb = sides[0].slice(0, +i + 1 || 9e9);
    subject = sides[0].slice(i + 1);
    object = sides[1];
  } else {
    verb = input[0];
    subject = input.slice(1);
  }
  subjectText = subject.join(' ');
  if (object) {
    objectText = object.join(' ');
  }
  i = 0;
  while (i < directions.length) {
    if (c === directions[i] || c === directions_long[i]) {
      player.move(i);
      lastMove = i;
      break;
    }
    i++;
  }
  if (subject.length) {
    things = find(subject);
    if (i === directions.length && things.length === 0 && verb !== "shout") {
      Say("You can't find a " + subject + ".");
      i = 0;
    }
  }
  if (i === directions.length) {
    switch (verb) {
      case "look":
        if (input.length === 1) {
          look(player.inside);
        } else {
          i = directions.indexOf(input[1]);
          if (player.inside.exits[i]) {
            Say("To the " + directions[i] + " you see--");
            look(player.inside.exits[i]);
          } else {
            Say("'Examine' is a vague action. Try a more concrete action such as " + (assemble(someOf(["lick", "taste", "feel", "smell", "read", "listen", "smell"], 3), " or ")) + ".");
          }
        }
        break;
      case "get":
        player.get(matchGet(things));
        break;
      case "drop":
        player.inside.get(matchDrop(things));
        break;
      case "inventory":
        if ((_ref = player.contents) != null ? _ref.length : void 0) {
          things = [];
          _ref1 = player.contents;
          for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
            object = _ref1[_i];
            things.push(lookAt(object));
          }
          Say("You are carrying " + (assemble(things)) + ".");
        } else {
          Say("You carry nothing.");
        }
        break;
      case "enter":
        if (input.length === 1) {
          _ref2 = player.inside.contents;
          for (_j = 0, _len1 = _ref2.length; _j < _len1; _j++) {
            o = _ref2[_j];
            if (o.building) {
              thing = o;
              break;
            }
          }
        } else {
          thing = matchEnter(things);
        }
        if (thing) {
          if (thing.enterby) {
            thing.enterby(player);
            return;
          }
          entrance = select(thing.contents, function(c) {
            return c.room;
          });
          if (entrance[0]) {
            Say("You enter " + (knowIntimately(thing)) + ".");
            get(entrance[0], player);
            look(player.inside);
          } else {
            Say("There is no obvious entrance.");
          }
        } else {
          Say("You see nothing to enter.");
        }
        break;
      case "exit":
        if (player.inside.exits.length > 0) {
          _ref3 = player.inside.exits;
          for (_k = 0, _len2 = _ref3.length; _k < _len2; _k++) {
            exit = _ref3[_k];
            if (exit && (exit === player.inside.inside || exit === ((_ref4 = player.inside.inside) != null ? _ref4.inside : void 0))) {
              get(exit, player);
              look(player.inside);
              return;
            }
          }
          randomMove(player);
        } else if (player.inside.exitable) {
          get(player, player.inside.inside);
          look(player.inside);
        }
        break;
      case "forward":
        player.move(lastMove);
        break;
      case "backward":
        player.move((lastMove + 4) % 8);
        break;
      case "escape":
        randomMove(player);
        break;
      case "attack":
        player.attack(matchGet(things));
        break;
      case "thanks":
        if (turn - lastThanked > 1) {
          Say(oneOf(["No problem.", "All in a day's work.", "Any time."]));
        } else {
          Say("Now I'm embarrassed.");
        }
        lastThanked = turn;
        break;
      case "lick":
        player.lick(matchGet(things));
        break;
      case "read":
        player.read(matchDrop(things));
        break;
      case "push":
        player.push(matchGet(things));
        break;
      case "talk":
        player.talk(matchGet(things));
        break;
      case "kiss":
        player.kiss(matchGet(things));
        break;
      case "shout":
        player.shout(subject);
        break;
      case "sing":
        player.sing;
        break;
      case "eat":
        player.eat(matchGet(things));
        break;
      case "shake":
        player.shake(matchDrop(things));
        break;
      case "smell":
        player.smell();
        break;
      case "use":
        Say("'Use' is a vague action. Try a more concrete action such as " + (assemble(someOf(["open", "twist", "shake", "break", "drink", "throw", "eat"], 3), " or ")) + ".");
        break;
      case "wait":
        Say("Time passes.");
        break;
      case "commands":
        Say(commands());
        break;
      default:
        Say("I did not understand " + c + ".");
    }
  }
  if ((_ref5 = magicWords[input[0]]) != null) {
    _ref5.effect();
  }
  everything(active, "act");
  scanMap(player);
  turn++;
  if (turn === 1) {
    Say("Navigate by compass directions ('n', 'e', 'sw') or 'enter building' and 'exit'.", "box monospace");
  }
  if (turn === 2) {
    Say("The icons in the top right display your 'L'ocation, 'I'nventory and suggested 'C'ommands, respectively.", "box monospace");
  }
  if (turn === 3) {
    Say("Be bold. Life is short.", "box monospace");
  }
  if (turn === 40) {
    if (root(player).outdoors) {
      Say("The sun is setting " + (oneOf(getWords(ADJECTIVE))) + "ly on the horizon.");
    }
  }
  if (turn === 50) {
    if (root(player).outdoors) {
      Say("The stars are coming out.");
    }
    get(player.inside, new Mayfly());
  }
  if (turn === 60) {
    Clear();
    return Say("Tell me. What your life was like?", "box monospace");
  }
};

look = function(room) {
  var d, distance, dx, dy, exits, i, l, landmark, miss, nearThing, neighbour, preface, sibling, sights, thing, thingsSeen, _i, _j, _k, _l, _len, _len1, _len2, _len3, _len4, _m, _ref, _ref1, _ref2, _ref3, _ref4;
  Say("<br>" + capitalise(room.name), "box pinned");
  _ref = room.contents;
  for (_i = 0, _len = _ref.length; _i < _len; _i++) {
    sibling = _ref[_i];
    if (sibling !== player) {
      if ((_ref1 = sibling.relation) != null ? _ref1.peer : void 0) {
        Say("" + sibling.relation.peer + " you see " + (lookAt(sibling)) + ".");
      } else {
        if (!sights) {
          sights = [];
        }
        sights.push(lookAt(sibling));
      }
    }
  }
  if (sights) {
    preface = room.preface;
    if (!preface) {
      preface = "You see";
    }
    Say("" + preface + " " + (assemble(sights)) + ".");
  }
  if (room.outdoors) {
    l = room.location;
    i = 0;
    for (_j = 0, _len1 = deltas.length; _j < _len1; _j++) {
      d = deltas[_j];
      neighbour = l.map.get(l.x + d[0], l.y + d[1], 0);
      thingsSeen = [];
      if (neighbour.contents) {
        _ref2 = neighbour.contents;
        for (_k = 0, _len2 = _ref2.length; _k < _len2; _k++) {
          thing = _ref2[_k];
          if (thing.size >= 100) {
            miss = false;
            _ref3 = room.contents;
            for (_l = 0, _len3 = _ref3.length; _l < _len3; _l++) {
              nearThing = _ref3[_l];
              if (nearThing.name === thing.name) {
                miss = true;
              }
            }
            if (!miss) {
              thingsSeen.push(know(thing));
            }
          }
        }
        if (thingsSeen.length) {
          Say("To the " + directions_long[i] + " you see " + (assemble(thingsSeen)) + ".");
        }
      }
      i++;
    }
  }
  if (room.outdoors) {
    for (_m = 0, _len4 = landmarks.length; _m < _len4; _m++) {
      landmark = landmarks[_m];
      l = position(landmark);
      dx = room.location.x - l.x;
      dy = room.location.y - l.y;
      distance = Math.sqrt(dx * dx + dy * dy);
      if (distance > 1.9 && distance * 1000 <= landmark.size) {
        Say("" + (distance > 2 ? 'Far to' : 'To') + " the " + (directionFrom(player, landmark)) + " you see " + (know(landmark)) + ".");
      }
    }
  }
  if (!room.outdoors) {
    exits = [];
    i = 0;
    while (i < directions.length) {
      if ((_ref4 = room.exits) != null ? _ref4[i] : void 0) {
        exits.push(directions_long[i]);
      }
      i++;
    }
    if (exits.length) {
      Say("You can go " + (assemble(exits)) + ".");
    } else {
      Say("There are no exits.");
    }
  }
  return room.known = true;
};

find = function(words, container) {
  var results, thing, word, _i, _j, _k, _len, _len1, _len2, _ref, _ref1;
  if (container === void 0) {
    container = player.inside;
    for (_i = 0, _len = words.length; _i < _len; _i++) {
      word = words[_i];
      if (word[word.length - 1] === "s") {
        words.push(word.slice(0, word.length - 1));
      }
    }
  }
  results = [];
  _ref = container.contents;
  for (_j = 0, _len1 = _ref.length; _j < _len1; _j++) {
    thing = _ref[_j];
    for (_k = 0, _len2 = words.length; _k < _len2; _k++) {
      word = words[_k];
      if (thing.synonyms.indexOf(word) !== -1) {
        results.push(thing);
        break;
      }
    }
    if (((_ref1 = thing.contents) != null ? _ref1.length : void 0) > 0) {
      results = results.concat(find(words, thing));
    }
  }
  return results;
};

disambiguate = function(ranks) {
  var names, rank, thing, _i, _j, _len, _len1;
  for (_i = 0, _len = ranks.length; _i < _len; _i++) {
    rank = ranks[_i];
    if (rank.length === 0) {

    } else if (rank.length === 1) {
      return rank[0];
    } else {
      names = [];
      for (_j = 0, _len1 = rank.length; _j < _len1; _j++) {
        thing = rank[_j];
        names.push("" + (_i + 1) + ") " + (knowIntimately(thing)) + " in " + (knowIntimately(thing.inside)));
      }
      Say("Did you mean " + assemble(names, " or ") + "?");
      return;
    }
  }
};

get = function(to, thing) {
  if (thing.inside) {
    remove(thing.inside.contents, thing);
  }
  thing.inside = to;
  if (!to.contents) {
    to.contents = [];
  }
  return to.contents.push(thing);
};

spill = function(object, indent) {
  var i, thing, _i, _len, _ref, _ref1, _results;
  _ref1 = (_ref = object.contents) != null ? _ref : [];
  _results = [];
  for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
    thing = _ref1[_i];
    Say(((function() {
      var _j, _results1;
      _results1 = [];
      for (i = _j = 0; 0 <= indent ? _j <= indent : _j >= indent; i = 0 <= indent ? ++_j : --_j) {
        _results1.push("-");
      }
      return _results1;
    })()).join('') + thing.name);
    _results.push(spill(thing, indent + 1));
  }
  return _results;
};

lookAt = function(thing) {
  var child, clause, clauses, l, r, t, _i, _len, _ref, _ref1;
  r = thing.lookedAt();
  clauses = {};
  l = [];
  _ref1 = (_ref = thing.contents) != null ? _ref : [];
  for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
    child = _ref1[_i];
    if (!(thing.building && child.relation === relation["in"]) && !child.inconspicuous) {
      t = lookAt(child);
      if (thing.postfix) {
        t += thing.postfix;
      }
      if (!clauses[child.relation.text]) {
        clauses[child.relation.text] = [t];
      } else {
        clauses[child.relation.text].push(t);
      }
    }
  }
  for (clause in clauses) {
    l.push(" " + clause + " " + assemble(clauses[clause]));
  }
  return r + assemble(l);
};

visible = function(thing, viewer) {
  if (!viewer) {
    viewer = player;
  }
  return root(thing) === root(viewer);
};

root = function(thing) {
  while (true) {
    if (thing.room) {
      return thing;
    }
    if (thing.relation === relation.buried) {
      return thing.inside;
    }
    thing = thing.inside;
  }
};

randomMove = function(thing) {
  var exits, i, j;
  exits = thing.inside.exits;
  if ((exits != null ? exits.length : void 0) > 0) {
    i = 0;
    while (i < 1000) {
      j = between(0, 8);
      if (exits[j]) {
        thing.move(j);
        return;
      }
    }
  } else if (thing.inside.outdoors) {
    return thing.move(between(0, 8));
  }
};

scanMap = function(object) {
  var location;
  location = position(player);
  location.map.get(location.x - 1, location.y - 1, location.z);
  location.map.get(location.x + 1, location.y - 1, location.z);
  location.map.get(location.x - 1, location.y + 1, location.z);
  return location.map.get(location.x + 1, location.y + 1, location.z);
};

position = function(thing) {
  while (!thing.location) {
    thing = thing.inside;
  }
  return thing.location;
};

all = function(thing) {
  var list, t, _i, _len, _ref;
  list = [];
  _ref = thing.contents;
  for (_i = 0, _len = _ref.length; _i < _len; _i++) {
    t = _ref[_i];
    list.push(t);
    if (t.contents) {
      list = list.concat(all(t));
    }
  }
  if (!thing.inside) {
    list.push(thing);
  }
  return list;
};

see = function(text, one, two, three) {
  if (!one || visible(one)) {
    return Say(capitalise(replace(text, one, two, three)));
  }
};

hear = function(text, one, two, three) {
  var direction, dummy;
  direction = neighbour(one);
  if (direction === 99) {
    return Say(capitalise(replace(text, one, two, three)));
  } else if (direction !== 100) {
    dummy = {};
    dummy.name = "something to the " + directions_long[direction];
    dummy.singular = true;
    return Say(capitalise(replace(text, dummy, dummy, three)));
  }
};

replace = function(text, one, two, three) {
  if (one) {
    text = text.replace("#1", knowIntimately(one));
    text = text.replace("#s", s(one));
  }
  if (two) {
    text = text.replace("#2", knowIntimately(two));
  }
  if (three) {
    text = text.replace("#3", knowIntimately(three));
  }
  return text;
};

neighbour = function(from, to) {
  var d, l1, l2, r1, r2, _i, _j;
  if (!to) {
    to = player;
  }
  r1 = root(from);
  r2 = root(to);
  if (!r1.outdoors || !r2.outdoors) {
    return 100;
  }
  if (r1 === r2) {
    return 99;
  }
  l1 = position(from);
  l2 = position(to);
  if (l1 && l2) {
    for (d = _i = 0; _i < 8; d = ++_i) {
      if (l2.x + deltas[d][0] === l1.x && l2.y + deltas[d][1] === l1.y) {
        return d;
      }
    }
  } else {
    for (d = _j = 0; _j < 8; d = ++_j) {
      if (from.exit[d] === r2) {
        return exit;
      }
    }
  }
  return 100;
};

commands = function() {
  var c;
  c = assemble(someOf(["open", "close", "twist", "shake", "break", "drink", "throw", "eat", "talk to", "kill", "kiss", "wait", "inventory", "again", "sing", "shout"], 3));
  return "Suggested commands: " + c + ".";
};

recollection = function() {
  if (localStorage.length === 0) {
    return "Nevermore!";
  }
  return localStorage["memory no. " + between(0, localStorage.length)];
};

destroy = function(thing) {
  if (thing.inside) {
    remove(thing.inside.contents, thing);
    thing.inside = void 0;
  }
  return delete thing.active;
};

player = new Animal({
  name: "Maribel",
  synonyms: ["me", "protagonist", "hero", "player"],
  gender: "female",
  singular: true,
  description: "You're as odd-looking as ever."
});

heroes = [
  player, new Animal({
    name: "Gretel",
    gender: "female",
    singular: true,
    pause: true
  }), new Animal({
    name: "Aras",
    gender: "male",
    singular: true,
    pause: true
  })
];

world = generate();

get(world.get(0, 0, 0), player);
