#!/usr/bin/perl

package eBay::API::XML::DataType::ShippingDetailsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ShippingDetailsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ShippingDetailsType

=head1 DESCRIPTION

Type for the shipping-related details for an item or transaction,
including flat and calculated shipping costs and shipping
insurance costs.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ShippingDetailsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AmountType;
use eBay::API::XML::DataType::CalculatedShippingDiscountType;
use eBay::API::XML::DataType::CalculatedShippingRateType;
use eBay::API::XML::DataType::FlatShippingDiscountType;
use eBay::API::XML::DataType::InsuranceDetailsType;
use eBay::API::XML::DataType::InternationalShippingServiceOptionsType;
use eBay::API::XML::DataType::PromotionalShippingDiscountDetailsType;
use eBay::API::XML::DataType::SalesTaxType;
use eBay::API::XML::DataType::ShippingServiceOptionsType;
use eBay::API::XML::DataType::TaxTableType;
use eBay::API::XML::DataType::Enum::InsuranceOptionCodeType;
use eBay::API::XML::DataType::Enum::ShippingRateTypeCodeType;
use eBay::API::XML::DataType::Enum::ShippingTypeCodeType;


my @gaProperties = ( [ 'AllowPaymentEdit', 'xs:boolean', '', '', '' ]
	, [ 'ApplyShippingDiscount', 'xs:boolean', '', '', '' ]
	, [ 'CODCost', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'CalculatedShippingDiscount', 'ns:CalculatedShippingDiscountType', ''
	     ,'eBay::API::XML::DataType::CalculatedShippingDiscountType', '1' ]
	, [ 'CalculatedShippingRate', 'ns:CalculatedShippingRateType', ''
	     ,'eBay::API::XML::DataType::CalculatedShippingRateType', '1' ]
	, [ 'ChangePaymentInstructions', 'xs:boolean', '', '', '' ]
	, [ 'DefaultShippingCost', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'FlatShippingDiscount', 'ns:FlatShippingDiscountType', ''
	     ,'eBay::API::XML::DataType::FlatShippingDiscountType', '1' ]
	, [ 'GetItFast', 'xs:boolean', '', '', '' ]
	, [ 'InsuranceDetails', 'ns:InsuranceDetailsType', ''
	     ,'eBay::API::XML::DataType::InsuranceDetailsType', '1' ]
	, [ 'InsuranceFee', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'InsuranceOption', 'ns:InsuranceOptionCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::InsuranceOptionCodeType', '' ]
	, [ 'InsuranceWanted', 'xs:boolean', '', '', '' ]
	, [ 'InternationalCalculatedShippingDiscount', 'ns:CalculatedShippingDiscountType', ''
	     ,'eBay::API::XML::DataType::CalculatedShippingDiscountType', '1' ]
	, [ 'InternationalFlatShippingDiscount', 'ns:FlatShippingDiscountType', ''
	     ,'eBay::API::XML::DataType::FlatShippingDiscountType', '1' ]
	, [ 'InternationalInsuranceDetails', 'ns:InsuranceDetailsType', ''
	     ,'eBay::API::XML::DataType::InsuranceDetailsType', '1' ]
	, [ 'InternationalPromotionalShippingDiscount', 'xs:boolean', '', '', '' ]
	, [ 'InternationalShippingDiscountProfileID', 'xs:string', '', '', '' ]
	, [ 'InternationalShippingServiceOption', 'ns:InternationalShippingServiceOptionsType', '1'
	     ,'eBay::API::XML::DataType::InternationalShippingServiceOptionsType', '1' ]
	, [ 'PaymentEdited', 'xs:boolean', '', '', '' ]
	, [ 'PaymentInstructions', 'xs:string', '', '', '' ]
	, [ 'PromotionalShippingDiscount', 'xs:boolean', '', '', '' ]
	, [ 'PromotionalShippingDiscountDetails', 'ns:PromotionalShippingDiscountDetailsType', ''
	     ,'eBay::API::XML::DataType::PromotionalShippingDiscountDetailsType', '1' ]
	, [ 'SalesTax', 'ns:SalesTaxType', ''
	     ,'eBay::API::XML::DataType::SalesTaxType', '1' ]
	, [ 'SellingManagerSalesRecordNumber', 'xs:int', '', '', '' ]
	, [ 'ShipmentTrackingNumber', 'xs:string', '', '', '' ]
	, [ 'ShippingDiscountProfileID', 'xs:string', '', '', '' ]
	, [ 'ShippingRateErrorMessage', 'xs:string', '', '', '' ]
	, [ 'ShippingRateType', 'ns:ShippingRateTypeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ShippingRateTypeCodeType', '' ]
	, [ 'ShippingServiceOptions', 'ns:ShippingServiceOptionsType', '1'
	     ,'eBay::API::XML::DataType::ShippingServiceOptionsType', '1' ]
	, [ 'ShippingServiceUsed', 'xs:token', '', '', '' ]
	, [ 'ShippingType', 'ns:ShippingTypeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ShippingTypeCodeType', '' ]
	, [ 'TaxTable', 'ns:TaxTableType', ''
	     ,'eBay::API::XML::DataType::TaxTableType', '1' ]
	, [ 'ThirdPartyCheckout', 'xs:boolean', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAllowPaymentEdit()

Instead of using this tag, see the PaymentEdited tag.
Originally, the AllowPaymentEdit tag specified whether the seller allows the
buyer to edit the payment amount for the transaction. (Sellers
enabled this property in their My eBay user preferences on the
eBay site.) ShippingDetails.AllowPaymentEdit is no longer being
populated by calls to GetItemTransactions.
Not applicable to Half.com.

#    Argument: 'xs:boolean'

=cut

sub setAllowPaymentEdit {
  my $self = shift;
  $self->{'AllowPaymentEdit'} = shift
}

=head2 isAllowPaymentEdit()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isAllowPaymentEdit {
  my $self = shift;
  return $self->{'AllowPaymentEdit'};
}


=head2 setApplyShippingDiscount()

Whether the seller specifies that a shipping discount is to be
applied (in the event that an item's transaction is later
combined with others into a single order).
Not applicable to Half.com.

#    Argument: 'xs:boolean'

=cut

sub setApplyShippingDiscount {
  my $self = shift;
  $self->{'ApplyShippingDiscount'} = shift
}

=head2 isApplyShippingDiscount()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine


  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isApplyShippingDiscount {
  my $self = shift;
  return $self->{'ApplyShippingDiscount'};
}


=head2 setCODCost()

Italy site (site ID 101) only. Contains
the cash-on-delivery (COD) cost, for COD shipping.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=CODInShippingDetails
Title: Specifying the Cash on Delivery Option in Shipping Details

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
         AddOrder
  RequiredInput: Conditionally

#    Argument: 'ns:AmountType'

=cut

sub setCODCost {
  my $self = shift;
  $self->{'CODCost'} = shift
}

=head2 getCODCost()

  Calls: GetItemShipping
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrders
  Returned: Conditionally
  Details: DetailLevel: none

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
  ExcludeFromContext: Transaction
  Context: Order

#    Returns: 'ns:AmountType'

=cut

sub getCODCost {
  my $self = shift;
  return $self->_getDataTypeInstance( 'CODCost'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setCalculatedShippingDiscount()

If a calculated shipping discount was offered for the domestic shipping services, this
contains the details of the calculated shipping discount. Otherwise, it is not returned.
Only returned if the calling user is the seller.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ShippingDiscountProfiles
Title: Shipping Cost Discount Profiles

#    Argument: 'ns:CalculatedShippingDiscountType'

=cut

sub setCalculatedShippingDiscount {
  my $self = shift;
  $self->{'CalculatedShippingDiscount'} = shift
}

=head2 getCalculatedShippingDiscount()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'ns:CalculatedShippingDiscountType'

=cut

sub getCalculatedShippingDiscount {
  my $self = shift;
  return $self->_getDataTypeInstance( 'CalculatedShippingDiscount'
		,'eBay::API::XML::DataType::CalculatedShippingDiscountType');
}


=head2 setCalculatedShippingRate()

Details pertinent to one or more items for which
calculated shipping has been offered by the seller, such as
package dimension and weight and packaging/handling costs.
Not applicable to Half.com or eBay Motors vehicle listings.
If your call may specify a large-dimension item listed with UPS, see
<a href="http://ebay.custhelp.com/cgi-bin/ebay.cfg/php/enduser/std_adp.php?p_faqid=1159">Dimensional Weight limit on UPS shipping services results in failure of shipping calculator</a>.
For Germany and the UK, this field is ignored when Item.ListingType=Express.
<p></p>
<span class="tablenote"><b>Note:</b>
At the end of April 2008, UK and Germany eBay Express will be shutdown. No
users will be eligible to list on these sites. All users previously registered
on UK and Germany Express will have their registered status revoked. Any
Express only items listed on these sites will be ended and credited the full
insertion fee to their sellers. Please refer to the respective Express sites
for more information.
</span>

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: 'ns:CalculatedShippingRateType'

=cut

sub setCalculatedShippingRate {
  my $self = shift;
  $self->{'CalculatedShippingRate'} = shift
}

=head2 getCalculatedShippingRate()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetItemShipping
  Returned: Conditionally

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'ns:CalculatedShippingRateType'

=cut

sub getCalculatedShippingRate {
  my $self = shift;
  return $self->_getDataTypeInstance( 'CalculatedShippingRate'
		,'eBay::API::XML::DataType::CalculatedShippingRateType');
}


=head2 setChangePaymentInstructions()

Whether the seller specified payment and shipping instructions during
checkout (for example, to update the details of a transaction). Flat and
calculated shipping.
Not applicable to Half.com.

#    Argument: 'xs:boolean'

=cut

sub setChangePaymentInstructions {
  my $self = shift;
  $self->{'ChangePaymentInstructions'} = shift
}

=head2 isChangePaymentInstructions()

  Calls: GetItemShipping
  Returned: Conditionally

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isChangePaymentInstructions {
  my $self = shift;
  return $self->{'ChangePaymentInstructions'};
}


=head2 setDefaultShippingCost()

The default shipping cost for the item. If the seller specified
multiple shipping services, this is the "first" shipping service
as specified by the seller when they listed the item. <br>
<br>
For GetSearchResults:<br>
If ShippingType has the value Flat, then the actual shipping cost is shown. If
ShippingType has the value Free, then zero is shown. If ShippingType has the
value Calculated, then this tag (DefaultShippingCost) is not shown. If
ShippingType has the value NotSpecified, then this tag (DefaultShippingCost)
is not shown. If ShippingType has the value Freight, then this tag
(DefaultShippingCost) is not shown.
<br>
<br>
In GetSearchResultsExpress:<br>
If flat shipping was specified or the shipping cost is 0.00 (free) for the
item, then the actual shipping cost is shown. If calculated shipping was
specified for the item, then this tag (DefaultShippingCost) is only shown if
PostalCode is specified in the GetSearchResultsExpress request. Otherwise,
ShippingRateErrorMessage is returned with a message that the postal code is
required for the shipping calculation.
Only returned when ItemDetails is set to Fine.
<br>
<br>
Not applicable to Half.com.

#    Argument: 'ns:AmountType'

=cut

sub setDefaultShippingCost {
  my $self = shift;
  $self->{'DefaultShippingCost'} = shift
}

=head2 getDefaultShippingCost()

  Calls: GetProducts
  Returned: Conditionally

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
           GranularityLevel: Coarse


#    Returns: 'ns:AmountType'

=cut

sub getDefaultShippingCost {
  my $self = shift;
  return $self->_getDataTypeInstance( 'DefaultShippingCost'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setFlatShippingDiscount()

If a flat rate shipping discount was offered for the domestic shipping services, this
contains the details of the flat rate shipping discount. Otherwise, it is not returned.
Only returned if the calling user is the seller.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ShippingDiscountProfiles
Title: Shipping Cost Discount Profiles

#    Argument: 'ns:FlatShippingDiscountType'

=cut

sub setFlatShippingDiscount {
  my $self = shift;
  $self->{'FlatShippingDiscount'} = shift
}

=head2 getFlatShippingDiscount()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'ns:FlatShippingDiscountType'

=cut

sub getFlatShippingDiscount {
  my $self = shift;
  return $self->_getDataTypeInstance( 'FlatShippingDiscount'
		,'eBay::API::XML::DataType::FlatShippingDiscountType');
}


=head2 setGetItFast()

Indicates whether the seller has opted the listing into the Get
It Fast feature. If GetItFast is true and if at least one of
the domestic shipping services offered by the seller is an
expedited shipping service, every shipping service offered by
the seller is considered a Get It Fast service, and the seller
commits to delivering the item to the buyer-selected shipping
service within one day.
Also applicable to Half.com (for GetOrders).

#    Argument: 'xs:boolean'

=cut

sub setGetItFast {
  my $self = shift;
  $self->{'GetItFast'} = shift
}

=head2 isGetItFast()

  Calls: GetBidderList
         GetItemShipping
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription,
						ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none

  Calls: GetOrderTransactions
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isGetItFast {
  my $self = shift;
  return $self->{'GetItFast'};
}


=head2 setInsuranceDetails()

Container for domestic insurance information. (Note that there are fields
named InsuranceFee and InsuranceOption at the same level as this container.
These were once used for representing both domestic and international
insurance details.)
If this (newer) container is provided on input and if
ShippingDetails.InsuranceFee or
ShippingDetails.InsuranceOption are also provided, those two (older fields)
are ignored.
If this container is omitted on input, its InsuranceFee and InsuranceOption
subfields are set to match whatever (the older fields)
ShippingDetails.InsuranceFee and ShippingDetails.InsuranceOption are set to.
For flat and calculated shipping, depending on which subfields are used.

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:InsuranceDetailsType'

=cut

sub setInsuranceDetails {
  my $self = shift;
  $self->{'InsuranceDetails'} = shift
}

=head2 getInsuranceDetails()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'ns:InsuranceDetailsType'

=cut

sub getInsuranceDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'InsuranceDetails'
		,'eBay::API::XML::DataType::InsuranceDetailsType');
}


=head2 setInsuranceFee()

Cost of shipping insurance set by the seller. If the
buyer bought more than one of this item, this is the insurance
for just a single item. Exception: for GetItemShipping, this is
proportional to QuantitySold. Value should be greater than 0.00 if
InsuranceOption is Optional or Required. For flat shipping only.
Optional as input and only allowed if ChangePaymentInstructions
is true.
This field is ignored when InsuranceOption is not specified in the request.
This field is ignored when Item.ListingType=Express.
<br>
<br>
Applicable to Half.com for GetOrders.
Not applicable to eBay Motors vehicle listings.

Max: Default: 0.00
Min: 
  Calls: AddItem
         GetItemRecommendations
         AddOrder
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:AmountType'

=cut

sub setInsuranceFee {
  my $self = shift;
  $self->{'InsuranceFee'} = shift
}

=head2 getInsuranceFee()

  Calls: GetBidderList
         GetItemShipping
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none

  Calls: GetOrderTransactions
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
  ExcludeFromContext: Transaction
  Context: Order

#    Returns: 'ns:AmountType'

=cut

sub getInsuranceFee {
  my $self = shift;
  return $self->_getDataTypeInstance( 'InsuranceFee'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setInsuranceOption()

Whether the seller offers shipping insurance and, if
so, whether the insurance is optional or required. Flat and
calculated shipping. Optional as input and only allowed if
ChangePaymentInstructions is true.
Also applicable to Half.com (for GetOrders).
This field is ignored when Item.ListingType=Express.
If this field is not included in the request, values specified in the InsuranceFee field will be ignored.

  Calls: AddItem
         GetItemRecommendations
         AddOrder
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No
  AllValuesExcept: NotOfferedOnSite

#    Argument: 'ns:InsuranceOptionCodeType'

=cut

sub setInsuranceOption {
  my $self = shift;
  $self->{'InsuranceOption'} = shift
}

=head2 getInsuranceOption()

  Calls: GetBidderList
         GetItemShipping
  Returned: Conditionally

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine


  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none

  Calls: GetOrderTransactions
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'ns:InsuranceOptionCodeType'

=cut

sub getInsuranceOption {
  my $self = shift;
  return $self->{'InsuranceOption'};
}


=head2 setInsuranceWanted()

Whether the buyer selected to pay for insurance offered
by the seller as an option. This only has a value after the
buyer has gone through checkout and selected the insurance
preference.
Also applicable to Half.com (for GetOrders).

#    Argument: 'xs:boolean'

=cut

sub setInsuranceWanted {
  my $self = shift;
  $self->{'InsuranceWanted'} = shift
}

=head2 isInsuranceWanted()

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none

  Calls: GetOrderTransactions
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetItemShipping
  Returned: Conditionally

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isInsuranceWanted {
  my $self = shift;
  return $self->{'InsuranceWanted'};
}


=head2 setInternationalCalculatedShippingDiscount()

If a calculated shipping discount was offered for the international shipping services, this
contains the details of the calculated shipping discount. Otherwise, it is not returned.
Only returned if the calling user is the seller.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ShippingDiscountProfiles
Title: Shipping Cost Discount Profiles

#    Argument: 'ns:CalculatedShippingDiscountType'

=cut

sub setInternationalCalculatedShippingDiscount {
  my $self = shift;
  $self->{'InternationalCalculatedShippingDiscount'} = shift
}

=head2 getInternationalCalculatedShippingDiscount()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'ns:CalculatedShippingDiscountType'

=cut

sub getInternationalCalculatedShippingDiscount {
  my $self = shift;
  return $self->_getDataTypeInstance( 'InternationalCalculatedShippingDiscount'
		,'eBay::API::XML::DataType::CalculatedShippingDiscountType');
}


=head2 setInternationalFlatShippingDiscount()

If a flat rate shipping discount was offered for the international shipping services, this
contains the details of the flat rate shipping discount. Otherwise, it is not returned.
Only returned if the calling user is the seller.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ShippingDiscountProfiles
Title: Shipping Cost Discount Profiles

#    Argument: 'ns:FlatShippingDiscountType'

=cut

sub setInternationalFlatShippingDiscount {
  my $self = shift;
  $self->{'InternationalFlatShippingDiscount'} = shift
}

=head2 getInternationalFlatShippingDiscount()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'ns:FlatShippingDiscountType'

=cut

sub getInternationalFlatShippingDiscount {
  my $self = shift;
  return $self->_getDataTypeInstance( 'InternationalFlatShippingDiscount'
		,'eBay::API::XML::DataType::FlatShippingDiscountType');
}


=head2 setInternationalInsuranceDetails()

Container for international insurance information. (Note that there are fields
named InsuranceFee and InsuranceOption at the same level as this container.
These were once used for representing both domestic and international
insurance details.) If this (newer) container is provided on input and if
ShippingDetails.InsuranceFee or ShippingDetails.InsuranceOption are also
provided, those two (older fields) are ignored.
If this container is omitted on input, its InsuranceFee and InsuranceOption
subfields are set to match whatever (the older fields)
ShippingDetails.InsuranceFee and ShippingDetails.InsuranceOption are set to.
For flat and calculated shipping, depending on which subfields are used.

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:InsuranceDetailsType'

=cut

sub setInternationalInsuranceDetails {
  my $self = shift;
  $self->{'InternationalInsuranceDetails'} = shift
}

=head2 getInternationalInsuranceDetails()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'ns:InsuranceDetailsType'

=cut

sub getInternationalInsuranceDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'InternationalInsuranceDetails'
		,'eBay::API::XML::DataType::InsuranceDetailsType');
}


=head2 setInternationalPromotionalShippingDiscount()

On input, this specifies whether to offer the promotional shipping discount
for the international shipping services of this listing (only applicable if the
seller has a promotional shipping discount in effect at the moment). On
output, this indicates whether the promotional shipping discount is being
offered for the international shipping services of this listing (if the listing is
still active--this is only possible if the seller has a promotional shipping
discount in effect at the moment) or whether the discount was offered at the
time the listing ended.
Only returned if the calling user is the seller.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ShippingDiscountProfiles
Title: Shipping Cost Discount Profiles

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: 'xs:boolean'

=cut

sub setInternationalPromotionalShippingDiscount {
  my $self = shift;
  $self->{'InternationalPromotionalShippingDiscount'} = shift
}

=head2 isInternationalPromotionalShippingDiscount()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isInternationalPromotionalShippingDiscount {
  my $self = shift;
  return $self->{'InternationalPromotionalShippingDiscount'};
}


=head2 setInternationalShippingDiscountProfileID()

On input, this is the ID of the shipping discount to offer for the international
shipping services (where the shipping discount is either of type
FlatShippingDiscount or CalculatedShippingDiscount). On output, this is the ID
of the shipping discount offered and corresponds to whichever is returned:
FlatShippingDiscount or CalculatedShippingDiscount. Only returned if the
calling user is the seller.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ShippingDiscountProfiles
Title: Shipping Cost Discount Profiles

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setInternationalShippingDiscountProfileID {
  my $self = shift;
  $self->{'InternationalShippingDiscountProfileID'} = shift
}

=head2 getInternationalShippingDiscountProfileID()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:string'

=cut

sub getInternationalShippingDiscountProfileID {
  my $self = shift;
  return $self->{'InternationalShippingDiscountProfileID'};
}


=head2 setInternationalShippingServiceOption()

Shipping costs and options related to an international shipping service. If
used, at least one domestic shipping service must also be provided in
ShippingServiceOptions.<br>
<br>
If you specify multiple InternationalShippingServiceOption nodes, the
repeating nodes must be contiguous. That is, you cannot insert other nodes
between InternationalShippingServiceOption nodes.<br>
<br>
If you specify ShippingDetails when you revise or relist an item but you omit
InternationalShippingServiceOption, eBay will drop the international shipping
services from the listing. This may also have unintended side effects, as
other fields that depend on this data may be dropped as well. To retain the
shipping services and dependent fields when you modify other shipping details,
it may be simplest to specify all ShippingDetails that you still want to
include in the listing.<br>
<br>
Not applicable to Half.com or eBay Motors vehicle listings.
This field is ignored when Item.ListingType=Express.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=SchemaOverview
For: rules regarding repeating instances of a nodes (nodes for which maxOccurs is "unbounded" or is greater than 1)
Title: Overview of the API Schema

  Calls: AddItem
         AddOrder
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: reference to an array  
                      of 'ns:InternationalShippingServiceOptionsType'

=cut

sub setInternationalShippingServiceOption {
  my $self = shift;
  $self->{'InternationalShippingServiceOption'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getInternationalShippingServiceOption()

  Calls: GetBidderList
         GetItemShipping
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription,
							ItemReturnAttributes, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetItemTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

  Calls: GetOrders
  Returned: Conditionally
  Details: DetailLevel: none

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: reference to an array  
                      of 'ns:InternationalShippingServiceOptionsType'

=cut

sub getInternationalShippingServiceOption {
  my $self = shift;
  return $self->_getDataTypeArray('InternationalShippingServiceOption');
}


=head2 setPaymentEdited()

Whether the seller allows the buyer to edit the payment amount
for the transaction. (Sellers enable this property in their My
eBay user preferences on the eBay site.)
Not applicable to Half.com.

#    Argument: 'xs:boolean'

=cut

sub setPaymentEdited {
  my $self = shift;
  $self->{'PaymentEdited'} = shift
}

=head2 isPaymentEdited()

  Calls: GetItemShipping
  Returned: Conditionally

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isPaymentEdited {
  my $self = shift;
  return $self->{'PaymentEdited'};
}


=head2 setPaymentInstructions()

Payment instructions/message from the seller to the buyer.
These instructions appear on eBay's View Item page and on eBay's
checkout page when the buyer pays for the item. Sellers usually use
this field to specify payment instructions, return policy details,
how soon the item will shipped, feedback instructions, and other reminders
that the buyer should be aware of when they bid on or buy an item.
This field can be specified regardless of the shipping type.
Some sites also let you specify a standard return policy by using
Item.AttributeSetArray in addition or instead.
eBay only allows 500 characters as input,
but due to the way the eBay Web site UI treats characters, this field can
return more than 500 characters in the response.
Characters like & and ' (apostrophe/single quote) count
as 5 characters each.
To remove this value when revising or relisting an item, use DeletedField.
Applicable to eBay Motors (usually used for the return policy).
Not applicable to Half.com.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ReturnPolicy
Title: Offering a Clear Return Policy
, URL: io_AddItem.html#Request.Item.AttributeSetArray
Title: (AddItem) Item.AttributeSetArray
, URL: io_GetItem.html#Response.Item.AttributeSetArray
Title: (GetItem) Item.AttributeSetArray

MaxLength: 1000

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setPaymentInstructions {
  my $self = shift;
  $self->{'PaymentInstructions'} = shift
}

=head2 getPaymentInstructions()

  Calls: GetBidderList
         GetItemShipping
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription,
						ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:string'

=cut

sub getPaymentInstructions {
  my $self = shift;
  return $self->{'PaymentInstructions'};
}


=head2 setPromotionalShippingDiscount()

On input, this specifies whether to offer the promotional shipping discount
for the domestic shipping services of this listing (only applicable if the
seller has a promotional shipping discount in effect at the moment). On
output, this indicates whether the promotional shipping discount is being
offered for the domestic shipping services of this listing (if the listing is
still active--this is only possible if the seller has a promotional shipping
discount in effect at the moment) or whether the discount was offered at the
time the listing ended.
Only returned if the calling user is the seller.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ShippingDiscountProfiles
Title: Shipping Cost Discount Profiles

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: 'xs:boolean'

=cut

sub setPromotionalShippingDiscount {
  my $self = shift;
  $self->{'PromotionalShippingDiscount'} = shift
}

=head2 isPromotionalShippingDiscount()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isPromotionalShippingDiscount {
  my $self = shift;
  return $self->{'PromotionalShippingDiscount'};
}


=head2 setPromotionalShippingDiscountDetails()

Details of the promotional shipping discount, if such is being offered while the listing is
active or was offered at the time the listing ended.
Only returned if the calling user is the seller.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ShippingDiscountProfiles
Title: Shipping Cost Discount Profiles

#    Argument: 'ns:PromotionalShippingDiscountDetailsType'

=cut

sub setPromotionalShippingDiscountDetails {
  my $self = shift;
  $self->{'PromotionalShippingDiscountDetails'} = shift
}

=head2 getPromotionalShippingDiscountDetails()

  Calls: GetShippingDiscountProfiles
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'ns:PromotionalShippingDiscountDetailsType'

=cut

sub getPromotionalShippingDiscountDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PromotionalShippingDiscountDetails'
		,'eBay::API::XML::DataType::PromotionalShippingDiscountDetailsType');
}


=head2 setSalesTax()

Sales tax details. US site only. Flat and calculated shipping.
Also applicable to Half.com (for GetOrders).
If your application normally calculates sales tax without using eBay's tax
tables, you should understand how purchases via eBay Express will affect
the way you process payments.
For general information about listings on eBay Express,
see the eBay Web Services Guide links below.
Not applicable to eBay Motors vehicle listings.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=SalesTax
Title: Enabling Multi-jurisdiction Sales Tax
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ExpressTax
Title: Specify Sales Tax for Express and eBay


  Calls: AddItem
         AddOrder
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:SalesTaxType'

=cut

sub setSalesTax {
  my $self = shift;
  $self->{'SalesTax'} = shift
}

=head2 getSalesTax()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine


  Calls: GetBidderList
         GetItemShipping
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none

  Calls: GetOrderTransactions
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'ns:SalesTaxType'

=cut

sub getSalesTax {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SalesTax'
		,'eBay::API::XML::DataType::SalesTaxType');
}


=head2 setSellingManagerSalesRecordNumber()

Applicable to Selling Manager Pro sellers. Also applicable to
Half.com (for GetOrders). For GetOrders, the Transaction container
includes this element within ShippingDetails.

#    Argument: 'xs:int'

=cut

sub setSellingManagerSalesRecordNumber {
  my $self = shift;
  $self->{'SellingManagerSalesRecordNumber'} = shift
}

=head2 getSellingManagerSalesRecordNumber()

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrders
  Returned: Conditionally
  Details: DetailLevel: none

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:int'

=cut

sub getSellingManagerSalesRecordNumber {
  my $self = shift;
  return $self->{'SellingManagerSalesRecordNumber'};
}


=head2 setShipmentTrackingNumber()

Shipment tracking number supplied by the shipping carrier.
Not applicable to Half.com.

#    Argument: 'xs:string'

=cut

sub setShipmentTrackingNumber {
  my $self = shift;
  $self->{'ShipmentTrackingNumber'} = shift
}

=head2 getShipmentTrackingNumber()

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:string'

=cut

sub getShipmentTrackingNumber {
  my $self = shift;
  return $self->{'ShipmentTrackingNumber'};
}


=head2 setShippingDiscountProfileID()

On input, this is the ID of the shipping discount to offer for the domestic
shipping services (where the shipping discount is either of type
FlatShippingDiscount or CalculatedShippingDiscount). On output, this is the ID
of the shipping discount offered and corresponds to whichever is returned:
FlatShippingDiscount or CalculatedShippingDiscount. Only returned if the
calling user is the seller.
Only returned if the calling user is the seller.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ShippingDiscountProfiles
Title: Shipping Cost Discount Profiles

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setShippingDiscountProfileID {
  my $self = shift;
  $self->{'ShippingDiscountProfileID'} = shift
}

=head2 getShippingDiscountProfileID()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:string'

=cut

sub getShippingDiscountProfileID {
  my $self = shift;
  return $self->{'ShippingDiscountProfileID'};
}


=head2 setShippingRateErrorMessage()

For most applicable calls, returns the words No Error or returns an error
message related to an attempt to calculate shipping rates. For calculated
shipping only.
Not applicable to Half.com or eBay Motors vehicle listings.
<br>
<br>
GetSearchResultsExpress returns this when no PostalCode was specified in the
request and the item was listed with calculated shipping rates. The message
text explains that a postal code is needed to calculate shipping. Only
returned when ItemDetails is set to Fine.

#    Argument: 'xs:string'

=cut

sub setShippingRateErrorMessage {
  my $self = shift;
  $self->{'ShippingRateErrorMessage'} = shift
}

=head2 getShippingRateErrorMessage()

  Calls: GetItemShipping
  Returned: Conditionally

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'xs:string'

=cut

sub getShippingRateErrorMessage {
  my $self = shift;
  return $self->{'ShippingRateErrorMessage'};
}


=head2 setShippingRateType()

A shipping rate scale for shipping through UPS that affects the shipping cost
calculated for UPS (lower if ShippingRateType is DailyPickup).
ShippingRateType is only returned if ShippingService is one of the UPS
shipping services. For calculated shipping only.
Not applicable to Half.com or eBay Motors vehicle listings.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=Shipping
Title: Shipping

#    Argument: 'ns:ShippingRateTypeCodeType'

=cut

sub setShippingRateType {
  my $self = shift;
  $self->{'ShippingRateType'} = shift
}

=head2 getShippingRateType()

  Calls: GetItemShipping
  Returned: Conditionally

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'ns:ShippingRateTypeCodeType'

=cut

sub getShippingRateType {
  my $self = shift;
  return $self->{'ShippingRateType'};
}


=head2 setShippingServiceOptions()

Shipping costs and options related to domestic shipping services offered by
the seller. Flat and calculated shipping. Required if
InternationalShippingServiceOption is specified.<br>
<br>
If you specify multiple ShippingServiceOptions nodes, the repeating nodes must
be contiguous. For example, you can insert InternationalShippingServiceOption
nodes after a list of repeating ShippingServiceOptions nodes, but not between
them:<br>
<br>
&lt;ShippingServiceOptions&gt;...&lt;/ShippingServiceOptions&gt;<br>
&lt;ShippingServiceOptions&gt;...&lt;/ShippingServiceOptions&gt;<br>
&lt;ShippingServiceOptions&gt;...&lt;/ShippingServiceOptions&gt;<br>
&lt;InternationalShippingServiceOption&gt;...&lt;/InternationalShippingServiceOption&gt;<br>
&lt;InternationalShippingServiceOption&gt;...&lt;/InternationalShippingServiceOption&gt;<br><br>
<br>
If you specify ShippingDetails when you revise or relist an item but you omit
ShippingServiceOptions, eBay will drop the domestic shipping services from the
listing. This may also have unintended side effects, as other fields that
depend on this data may be dropped as well. To retain the shipping services
and dependent fields when you modify other shipping details, it may be
simplest to specify all ShippingDetails that you still want to include in the
listing.<br>
<br>
Not applicable to Half.com or eBay Motors vehicle listings.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=SchemaOverview
For: rules regarding repeating instances of a nodes (nodes for which maxOccurs is "unbounded" or is greater than 1)
Title: Overview of the API Schema

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: Conditionally

  Calls: AddOrder
  RequiredInput: No

#    Argument: reference to an array  
                      of 'ns:ShippingServiceOptionsType'

=cut

sub setShippingServiceOptions {
  my $self = shift;
  $self->{'ShippingServiceOptions'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getShippingServiceOptions()

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList
           WonList
           WatchList
           DeletedFromWonList
           BestOfferList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList
           ActiveList
           ScheduledList

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetItemShipping
  Returned: Conditionally

  Calls: GetItemTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

  Calls: GetOrders
  Returned: Conditionally
  Details: DetailLevel: none

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: reference to an array  
                      of 'ns:ShippingServiceOptionsType'

=cut

sub getShippingServiceOptions {
  my $self = shift;
  return $self->_getDataTypeArray('ShippingServiceOptions');
}


=head2 setShippingServiceUsed()

The shipping service that actually shipped the item(s).
Not applicable to Half.com.

#    Argument: 'xs:token'

=cut

sub setShippingServiceUsed {
  my $self = shift;
  $self->{'ShippingServiceUsed'} = shift
}

=head2 getShippingServiceUsed()

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:token'

=cut

sub getShippingServiceUsed {
  my $self = shift;
  return $self->{'ShippingServiceUsed'};
}


=head2 setShippingType()

The shipping cost model offered by the seller. This is not returned for
various calls since shipping type can be deduced: if a CalculatedShippingRate
structure is returned by the call, the shipping type is Calculated. Otherwise,
it is one of the other non-Calculated shipping types.
Not applicable to Half.com.

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No
  AllValuesExcept: Free, Freight

  Calls: GetItemRecommendations
  RequiredInput: No
  AllValuesExcept: Free, Freight

#    Argument: 'ns:ShippingTypeCodeType'

=cut

sub setShippingType {
  my $self = shift;
  $self->{'ShippingType'} = shift
}

=head2 getShippingType()

  Calls: GetBidderList
  Returned: Conditionally
  AllValuesExcept: Free

  Calls: GetProducts
  Returned: Conditionally

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
           GranularityLevel: Coarse


  Calls: GetItemTransactions
  Returned: Conditionally
  AllValuesExcept: Free, Freight
  Details: DetailLevel: ItemReturnDescription, none, ReturnAll

  Calls: GetSellerTransactions
  Returned: Conditionally
  AllValuesExcept: Free, Freight
  Details: DetailLevel: ItemReturnDescription, none, ReturnAll

  Calls: GetItem
  Returned: Conditionally
  AllValuesExcept: Free, Freight
  Details: DetailLevel: ItemReturnAttributes, none, ReturnAll

#    Returns: 'ns:ShippingTypeCodeType'

=cut

sub getShippingType {
  my $self = shift;
  return $self->{'ShippingType'};
}


=head2 setTaxTable()

Tax details for a jurisdiction such as a state or province.
If no tax table is associated with the item, no tax table is returned,
even if IncludeTaxTable is set to true.
<p>
If a tax table is associated with the item:
<br>
- the tax table is returned if DetailLevel is ReturnAll or
ItemReturnDescription (and the value of IncludeTaxTable does not matter)
<br>
- if no DetailLevel is specified or if DetailLevel is ItemReturnAttributes,
the tax table is returned only if IncludeTaxTable is true
<p>
Not applicable to Half.com.

#    Argument: 'ns:TaxTableType'

=cut

sub setTaxTable {
  my $self = shift;
  $self->{'TaxTable'} = shift
}

=head2 getTaxTable()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetBidderList
         GetItemShipping
  Returned: Conditionally

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Coarse, Medium, Fine


  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'ns:TaxTableType'

=cut

sub getTaxTable {
  my $self = shift;
  return $self->_getDataTypeInstance( 'TaxTable'
		,'eBay::API::XML::DataType::TaxTableType');
}


=head2 setThirdPartyCheckout()

Whether checkout for this is to be handled by a
Third-Party Checkout application. The counterpart in the AddItem
family of calls is Item.ThirdPartyCheckout.
Not applicable to Half.com.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ThirdPartyCheckout
Title: Third Party Checkout
, URL: io_AddItem.html#Request.Item.ThirdPartyCheckout
Title: (AddItem) Item.ThirdPartyCheckout


  Calls: AddOrder
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setThirdPartyCheckout {
  my $self = shift;
  $self->{'ThirdPartyCheckout'} = shift
}

=head2 isThirdPartyCheckout()

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription,
						ItemReturnAttributes, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine


  Calls: GetBidderList
         GetItemShipping
  Returned: Conditionally

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isThirdPartyCheckout {
  my $self = shift;
  return $self->{'ThirdPartyCheckout'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
