#!/usr/bin/perl

package eBay::API::XML::DataType::DeliveryURLDetailType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. DeliveryURLDetailType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::DeliveryURLDetailType

=head1 DESCRIPTION

Defines settings for a notification URL (including the URL name in DeliveryURLName).



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::DeliveryURLDetailType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::Enum::EnableCodeType;


my @gaProperties = ( [ 'DeliveryURL', 'xs:anyURI', '', '', '' ]
	, [ 'DeliveryURLName', 'xs:string', '', '', '' ]
	, [ 'Status', 'ns:EnableCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::EnableCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDeliveryURL()

The address of a notification delivery URL.
This address applies to the DeliveryURLName
within the same
ApplicationDeliveryPreferences.DeliveryURLDetails container.
For delivery to a server, the URL
begins with http:// or https:// and must be well
formed. Use a URL that is functional at the time of the
call. For delivery to an email address, the URL begins
with mailto: and specifies a valid email address.

MaxLength: unknown

  Calls: SetNotificationPreferences
  RequiredInput: No

#    Argument: 'xs:anyURI'

=cut

sub setDeliveryURL {
  my $self = shift;
  $self->{'DeliveryURL'} = shift
}

=head2 getDeliveryURL()

  Calls: GetNotificationPreferences
  Returned: Conditionally

#    Returns: 'xs:anyURI'

=cut

sub getDeliveryURL {
  my $self = shift;
  return $self->{'DeliveryURL'};
}


=head2 setDeliveryURLName()

The name of a notification delivery URL.

  Calls: SetNotificationPreferences
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setDeliveryURLName {
  my $self = shift;
  $self->{'DeliveryURLName'} = shift
}

=head2 getDeliveryURLName()

  Calls: GetNotificationPreferences
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getDeliveryURLName {
  my $self = shift;
  return $self->{'DeliveryURLName'};
}


=head2 setStatus()

The status of a notification delivery URL.
This status applies to the DeliveryURLName and delivery URL
within the same ApplicationDeliveryPreferences.DeliveryURLDetails container.
If the status is disabled, then notifications will not be sent to the delivery URL.

  Calls: SetNotificationPreferences
  RequiredInput: No

#    Argument: 'ns:EnableCodeType'

=cut

sub setStatus {
  my $self = shift;
  $self->{'Status'} = shift
}

=head2 getStatus()

  Calls: GetNotificationPreferences
  Returned: Conditionally

#    Returns: 'ns:EnableCodeType'

=cut

sub getStatus {
  my $self = shift;
  return $self->{'Status'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
