/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.AffineOpImage;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class AffineBilinearOpImage
extends AffineOpImage {
    public AffineBilinearOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, AffineTransform affineTransform, Interpolation interpolation, double[] dArray) {
        super(renderedImage, borderExtender, map, imageLayout, affineTransform, interpolation, dArray);
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        int n = rectangle2.x;
        int n2 = rectangle2.y;
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        int n6 = rasterAccessor2.getNumBands();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n9 = rasterAccessor.getPixelStride();
        int n10 = rasterAccessor.getScanlineStride();
        int n11 = rasterAccessor2.getNumBands();
        int n12 = rectangle.x;
        int n13 = rectangle.y;
        int n14 = rectangle.x + rectangle.width;
        int n15 = rectangle.y + rectangle.height;
        byte[] byArray3 = new byte[n11];
        int n16 = 0;
        while (n16 < n11) {
            byArray3[n16] = (byte)this.backgroundValues[n16];
            ++n16;
        }
        int n17 = n13;
        while (n17 < n15) {
            int n18 = n3;
            ((Point2D)float_).setLocation((double)n12 + 0.5, (double)n17 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n19 = (int)Math.floor(f5);
            int n20 = (int)Math.floor(f6);
            float f7 = f5 - (float)n19;
            float f8 = f6 - (float)n20;
            int n21 = (n20 - n2) * n10;
            int n22 = (n19 - n) * n9;
            int n23 = n21 + n10;
            int n24 = n22 + n9;
            int n25 = n22 + n21;
            int n26 = n24 + n21;
            int n27 = n22 + n23;
            int n28 = n24 + n23;
            int n29 = n12;
            while (n29 < n14) {
                int n30;
                if ((float)n19 >= f && (float)n19 < f3 - 1.0f && (float)n20 >= f2 && (float)n20 < f4 - 1.0f) {
                    n30 = 0;
                    while (n30 < n11) {
                        byte[] byArray4 = byArray2[n30];
                        int n31 = nArray2[n30];
                        int n32 = byArray4[n25 + n31] & 0xFF;
                        int n33 = byArray4[n26 + n31] & 0xFF;
                        float f9 = (float)n32 + (float)(n33 - n32) * f7;
                        int n34 = byArray4[n27 + n31] & 0xFF;
                        int n35 = byArray4[n28 + n31] & 0xFF;
                        float f10 = (float)n34 + (float)(n35 - n34) * f7;
                        float f11 = f9 + (f10 - f9) * f8;
                        int n36 = f11 < 0.5f ? 0 : (f11 > 254.5f ? 255 : (int)(f11 + 0.5f));
                        byArray[n30][n18 + nArray[n30]] = (byte)(n36 & 0xFF);
                        ++n30;
                    }
                } else if (this.setBackground) {
                    n30 = 0;
                    while (n30 < n11) {
                        byArray[n30][n18 + nArray[n30]] = byArray3[n30];
                        ++n30;
                    }
                }
                if ((double)f7 < this.fracdx1) {
                    n19 += this.incx;
                    f7 = (float)((double)f7 + this.fracdx);
                } else {
                    n19 += this.incx1;
                    f7 = (float)((double)f7 - this.fracdx1);
                }
                if ((double)f8 < this.fracdy1) {
                    n20 += this.incy;
                    f8 = (float)((double)f8 + this.fracdy);
                } else {
                    n20 += this.incy1;
                    f8 = (float)((double)f8 - this.fracdy1);
                }
                n21 = (n20 - n2) * n10;
                n22 = (n19 - n) * n9;
                n23 = n21 + n10;
                n24 = n22 + n9;
                n25 = n22 + n21;
                n26 = n24 + n21;
                n27 = n22 + n23;
                n28 = n24 + n23;
                n18 += n7;
                ++n29;
            }
            n3 += n8;
            ++n17;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        int n6 = rasterAccessor2.getNumBands();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n9 = rasterAccessor.getPixelStride();
        int n10 = rasterAccessor.getScanlineStride();
        int n11 = rasterAccessor2.getNumBands();
        int n12 = rectangle.x;
        int n13 = rectangle.y;
        int n14 = rectangle.x + rectangle.width;
        int n15 = rectangle.y + rectangle.height;
        int[] nArray5 = new int[n11];
        int n16 = 0;
        while (n16 < n11) {
            nArray5[n16] = (int)this.backgroundValues[n16];
            ++n16;
        }
        int n17 = n13;
        while (n17 < n15) {
            int n18 = n3;
            ((Point2D)float_).setLocation((double)n12 + 0.5, (double)n17 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n19 = (int)Math.floor(f5);
            int n20 = (int)Math.floor(f6);
            float f7 = f5 - (float)n19;
            float f8 = f6 - (float)n20;
            int n21 = (n20 - n2) * n10;
            int n22 = (n19 - n) * n9;
            int n23 = n21 + n10;
            int n24 = n22 + n9;
            int n25 = n22 + n21;
            int n26 = n24 + n21;
            int n27 = n22 + n23;
            int n28 = n24 + n23;
            int n29 = n12;
            while (n29 < n14) {
                int n30;
                if ((float)n19 >= f && (float)n19 < f3 - 1.0f && (float)n20 >= f2 && (float)n20 < f4 - 1.0f) {
                    n30 = 0;
                    while (n30 < n11) {
                        int[] nArray6 = nArray3[n30];
                        int n31 = nArray4[n30];
                        int n32 = nArray6[n25 + n31];
                        int n33 = nArray6[n26 + n31];
                        float f9 = (float)n32 + (float)(n33 - n32) * f7;
                        int n34 = nArray6[n27 + n31];
                        int n35 = nArray6[n28 + n31];
                        float f10 = (float)n34 + (float)(n35 - n34) * f7;
                        float f11 = f9 + (f10 - f9) * f8;
                        int n36 = f11 < -2.1474836E9f ? Integer.MIN_VALUE : (f11 > 2.1474836E9f ? Integer.MAX_VALUE : (f11 > 0.0f ? (int)(f11 + 0.5f) : (int)(f11 - 0.5f)));
                        nArray[n30][n18 + nArray2[n30]] = n36;
                        ++n30;
                    }
                } else if (this.setBackground) {
                    n30 = 0;
                    while (n30 < n11) {
                        nArray[n30][n18 + nArray2[n30]] = nArray5[n30];
                        ++n30;
                    }
                }
                if ((double)f7 < this.fracdx1) {
                    n19 += this.incx;
                    f7 = (float)((double)f7 + this.fracdx);
                } else {
                    n19 += this.incx1;
                    f7 = (float)((double)f7 - this.fracdx1);
                }
                if ((double)f8 < this.fracdy1) {
                    n20 += this.incy;
                    f8 = (float)((double)f8 + this.fracdy);
                } else {
                    n20 += this.incy1;
                    f8 = (float)((double)f8 - this.fracdy1);
                }
                n21 = (n20 - n2) * n10;
                n22 = (n19 - n) * n9;
                n23 = n21 + n10;
                n24 = n22 + n9;
                n25 = n22 + n21;
                n26 = n24 + n21;
                n27 = n22 + n23;
                n28 = n24 + n23;
                n18 += n7;
                ++n29;
            }
            n3 += n8;
            ++n17;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        int n6 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n9 = rasterAccessor.getPixelStride();
        int n10 = rasterAccessor.getScanlineStride();
        int n11 = rasterAccessor2.getNumBands();
        int n12 = rectangle.x;
        int n13 = rectangle.y;
        int n14 = rectangle.x + rectangle.width;
        int n15 = rectangle.y + rectangle.height;
        short[] sArray3 = new short[n11];
        int n16 = 0;
        while (n16 < n11) {
            sArray3[n16] = (short)this.backgroundValues[n16];
            ++n16;
        }
        int n17 = n13;
        while (n17 < n15) {
            int n18 = n3;
            ((Point2D)float_).setLocation((double)n12 + 0.5, (double)n17 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n19 = (int)Math.floor(f5);
            int n20 = (int)Math.floor(f6);
            float f7 = f5 - (float)n19;
            float f8 = f6 - (float)n20;
            int n21 = (n20 - n2) * n10;
            int n22 = (n19 - n) * n9;
            int n23 = n21 + n10;
            int n24 = n22 + n9;
            int n25 = n22 + n21;
            int n26 = n24 + n21;
            int n27 = n22 + n23;
            int n28 = n24 + n23;
            int n29 = n12;
            while (n29 < n14) {
                int n30;
                if ((float)n19 >= f && (float)n19 < f3 - 1.0f && (float)n20 >= f2 && (float)n20 < f4 - 1.0f) {
                    n30 = 0;
                    while (n30 < n11) {
                        short[] sArray4 = sArray2[n30];
                        int n31 = nArray2[n30];
                        short s = sArray4[n25 + n31];
                        short s2 = sArray4[n26 + n31];
                        float f9 = (float)s + (float)(s2 - s) * f7;
                        short s3 = sArray4[n27 + n31];
                        short s4 = sArray4[n28 + n31];
                        float f10 = (float)s3 + (float)(s4 - s3) * f7;
                        float f11 = f9 + (f10 - f9) * f8;
                        int n32 = f11 < -32768.0f ? Short.MIN_VALUE : (f11 > 32767.0f ? Short.MAX_VALUE : (f11 > 0.0f ? (int)(f11 + 0.5f) : (int)(f11 - 0.5f)));
                        sArray[n30][n18 + nArray[n30]] = (short)n32;
                        ++n30;
                    }
                } else if (this.setBackground) {
                    n30 = 0;
                    while (n30 < n11) {
                        sArray[n30][n18 + nArray[n30]] = sArray3[n30];
                        ++n30;
                    }
                }
                if ((double)f7 < this.fracdx1) {
                    n19 += this.incx;
                    f7 = (float)((double)f7 + this.fracdx);
                } else {
                    n19 += this.incx1;
                    f7 = (float)((double)f7 - this.fracdx1);
                }
                if ((double)f8 < this.fracdy1) {
                    n20 += this.incy;
                    f8 = (float)((double)f8 + this.fracdy);
                } else {
                    n20 += this.incy1;
                    f8 = (float)((double)f8 - this.fracdy1);
                }
                n21 = (n20 - n2) * n10;
                n22 = (n19 - n) * n9;
                n23 = n21 + n10;
                n24 = n22 + n9;
                n25 = n22 + n21;
                n26 = n24 + n21;
                n27 = n22 + n23;
                n28 = n24 + n23;
                n18 += n7;
                ++n29;
            }
            n3 += n8;
            ++n17;
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        int n6 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n9 = rasterAccessor.getPixelStride();
        int n10 = rasterAccessor.getScanlineStride();
        int n11 = rasterAccessor2.getNumBands();
        int n12 = rectangle.x;
        int n13 = rectangle.y;
        int n14 = rectangle.x + rectangle.width;
        int n15 = rectangle.y + rectangle.height;
        short[] sArray3 = new short[n11];
        int n16 = 0;
        while (n16 < n11) {
            sArray3[n16] = (short)this.backgroundValues[n16];
            ++n16;
        }
        int n17 = n13;
        while (n17 < n15) {
            int n18 = n3;
            ((Point2D)float_).setLocation((double)n12 + 0.5, (double)n17 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n19 = (int)Math.floor(f5);
            int n20 = (int)Math.floor(f6);
            float f7 = f5 - (float)n19;
            float f8 = f6 - (float)n20;
            int n21 = (n20 - n2) * n10;
            int n22 = (n19 - n) * n9;
            int n23 = n21 + n10;
            int n24 = n22 + n9;
            int n25 = n22 + n21;
            int n26 = n24 + n21;
            int n27 = n22 + n23;
            int n28 = n24 + n23;
            int n29 = n12;
            while (n29 < n14) {
                int n30;
                if ((float)n19 >= f && (float)n19 < f3 - 1.0f && (float)n20 >= f2 && (float)n20 < f4 - 1.0f) {
                    n30 = 0;
                    while (n30 < n11) {
                        short[] sArray4 = sArray2[n30];
                        int n31 = nArray2[n30];
                        int n32 = sArray4[n25 + n31] & 0xFFFF;
                        int n33 = sArray4[n26 + n31] & 0xFFFF;
                        float f9 = (float)n32 + (float)(n33 - n32) * f7;
                        int n34 = sArray4[n27 + n31] & 0xFFFF;
                        int n35 = sArray4[n28 + n31] & 0xFFFF;
                        float f10 = (float)n34 + (float)(n35 - n34) * f7;
                        float f11 = f9 + (f10 - f9) * f8;
                        int n36 = (double)f11 < 0.0 ? 0 : (f11 > 65535.0f ? 65535 : (int)(f11 + 0.5f));
                        sArray[n30][n18 + nArray[n30]] = (short)(n36 & 0xFFFF);
                        ++n30;
                    }
                } else if (this.setBackground) {
                    n30 = 0;
                    while (n30 < n11) {
                        sArray[n30][n18 + nArray[n30]] = sArray3[n30];
                        ++n30;
                    }
                }
                if ((double)f7 < this.fracdx1) {
                    n19 += this.incx;
                    f7 = (float)((double)f7 + this.fracdx);
                } else {
                    n19 += this.incx1;
                    f7 = (float)((double)f7 - this.fracdx1);
                }
                if ((double)f8 < this.fracdy1) {
                    n20 += this.incy;
                    f8 = (float)((double)f8 + this.fracdy);
                } else {
                    n20 += this.incy1;
                    f8 = (float)((double)f8 - this.fracdy1);
                }
                n21 = (n20 - n2) * n10;
                n22 = (n19 - n) * n9;
                n23 = n21 + n10;
                n24 = n22 + n9;
                n25 = n22 + n21;
                n26 = n24 + n21;
                n27 = n22 + n23;
                n28 = n24 + n23;
                n18 += n7;
                ++n29;
            }
            n3 += n8;
            ++n17;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        int n6 = rasterAccessor2.getNumBands();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n9 = rasterAccessor.getPixelStride();
        int n10 = rasterAccessor.getScanlineStride();
        int n11 = rasterAccessor2.getNumBands();
        int n12 = rectangle.x;
        int n13 = rectangle.y;
        int n14 = rectangle.x + rectangle.width;
        int n15 = rectangle.y + rectangle.height;
        float[] fArray3 = new float[n11];
        int n16 = 0;
        while (n16 < n11) {
            fArray3[n16] = (float)this.backgroundValues[n16];
            ++n16;
        }
        int n17 = n13;
        while (n17 < n15) {
            int n18 = n3;
            ((Point2D)float_).setLocation((double)n12 + 0.5, (double)n17 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n19 = (int)Math.floor(f5);
            int n20 = (int)Math.floor(f6);
            float f7 = f5 - (float)n19;
            float f8 = f6 - (float)n20;
            int n21 = (n20 - n2) * n10;
            int n22 = (n19 - n) * n9;
            int n23 = n21 + n10;
            int n24 = n22 + n9;
            int n25 = n22 + n21;
            int n26 = n24 + n21;
            int n27 = n22 + n23;
            int n28 = n24 + n23;
            int n29 = n12;
            while (n29 < n14) {
                int n30;
                if ((float)n19 >= f && (float)n19 < f3 - 1.0f && (float)n20 >= f2 && (float)n20 < f4 - 1.0f) {
                    n30 = 0;
                    while (n30 < n11) {
                        float f9;
                        float[] fArray4 = fArray2[n30];
                        int n31 = nArray2[n30];
                        float f10 = fArray4[n25 + n31];
                        float f11 = fArray4[n26 + n31];
                        float f12 = fArray4[n27 + n31];
                        float f13 = fArray4[n28 + n31];
                        float f14 = f10 + (f11 - f10) * f7;
                        float f15 = f12 + (f13 - f12) * f7;
                        fArray[n30][n18 + nArray[n30]] = f9 = f14 + (f15 - f14) * f8;
                        ++n30;
                    }
                } else if (this.setBackground) {
                    n30 = 0;
                    while (n30 < n11) {
                        fArray[n30][n18 + nArray[n30]] = fArray3[n30];
                        ++n30;
                    }
                }
                if ((double)f7 < this.fracdx1) {
                    n19 += this.incx;
                    f7 = (float)((double)f7 + this.fracdx);
                } else {
                    n19 += this.incx1;
                    f7 = (float)((double)f7 - this.fracdx1);
                }
                if ((double)f8 < this.fracdy1) {
                    n20 += this.incy;
                    f8 = (float)((double)f8 + this.fracdy);
                } else {
                    n20 += this.incy1;
                    f8 = (float)((double)f8 - this.fracdy1);
                }
                n21 = (n20 - n2) * n10;
                n22 = (n19 - n) * n9;
                n23 = n21 + n10;
                n24 = n22 + n9;
                n25 = n22 + n21;
                n26 = n24 + n21;
                n27 = n22 + n23;
                n28 = n24 + n23;
                n18 += n7;
                ++n29;
            }
            n3 += n8;
            ++n17;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        int n6 = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n9 = rasterAccessor.getPixelStride();
        int n10 = rasterAccessor.getScanlineStride();
        int n11 = rasterAccessor2.getNumBands();
        int n12 = rectangle.x;
        int n13 = rectangle.y;
        int n14 = rectangle.x + rectangle.width;
        int n15 = rectangle.y + rectangle.height;
        int n16 = n13;
        while (n16 < n15) {
            int n17 = n3;
            ((Point2D)float_).setLocation((double)n12 + 0.5, (double)n16 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n18 = (int)Math.floor(f5);
            int n19 = (int)Math.floor(f6);
            double d = f5 - (float)n18;
            double d2 = f6 - (float)n19;
            int n20 = (n19 - n2) * n10;
            int n21 = (n18 - n) * n9;
            int n22 = n20 + n10;
            int n23 = n21 + n9;
            int n24 = n21 + n20;
            int n25 = n23 + n20;
            int n26 = n21 + n22;
            int n27 = n23 + n22;
            int n28 = n12;
            while (n28 < n14) {
                int n29;
                if ((float)n18 >= f && (float)n18 < f3 - 1.0f && (float)n19 >= f2 && (float)n19 < f4 - 1.0f) {
                    n29 = 0;
                    while (n29 < n11) {
                        double d3;
                        double[] dArray3 = dArray2[n29];
                        int n30 = nArray2[n29];
                        double d4 = dArray3[n24 + n30];
                        double d5 = dArray3[n25 + n30];
                        double d6 = dArray3[n26 + n30];
                        double d7 = dArray3[n27 + n30];
                        double d8 = d4 + (d5 - d4) * d;
                        double d9 = d6 + (d7 - d6) * d;
                        dArray[n29][n17 + nArray[n29]] = d3 = d8 + (d9 - d8) * d2;
                        ++n29;
                    }
                } else if (this.setBackground) {
                    n29 = 0;
                    while (n29 < n11) {
                        dArray[n29][n17 + nArray[n29]] = this.backgroundValues[n29];
                        ++n29;
                    }
                }
                if (d < this.fracdx1) {
                    n18 += this.incx;
                    d += this.fracdx;
                } else {
                    n18 += this.incx1;
                    d -= this.fracdx1;
                }
                if (d2 < this.fracdy1) {
                    n19 += this.incy;
                    d2 += this.fracdy;
                } else {
                    n19 += this.incy1;
                    d2 -= this.fracdy1;
                }
                n20 = (n19 - n2) * n10;
                n21 = (n18 - n) * n9;
                n22 = n20 + n10;
                n23 = n21 + n9;
                n24 = n21 + n20;
                n25 = n23 + n20;
                n26 = n21 + n22;
                n27 = n23 + n22;
                n17 += n7;
                ++n28;
            }
            n3 += n8;
            ++n16;
        }
    }
}

