/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.util.LinkedList;
import java.util.List;
import org.apache.poi.ddf.DefaultEscherRecordFactory;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.hwpf.model.PICF;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndian;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public class PICFAndOfficeArtData {
    private List<EscherRecord> _blipRecords;
    private short _cchPicName;
    private PICF _picf;
    private EscherContainerRecord _shape;
    private byte[] _stPicName;

    public PICFAndOfficeArtData(byte[] dataStream, int startOffset) {
        EscherRecord nextRecord;
        int offset = startOffset;
        this._picf = new PICF(dataStream, offset);
        offset += PICF.getSize();
        if (this._picf.getMm() == 102) {
            this._cchPicName = LittleEndian.getUByte(dataStream, offset);
            this._stPicName = LittleEndian.getByteArray(dataStream, ++offset, this._cchPicName);
            offset += this._cchPicName;
        }
        DefaultEscherRecordFactory escherRecordFactory = new DefaultEscherRecordFactory();
        this._shape = new EscherContainerRecord();
        int recordSize = this._shape.fillFields(dataStream, offset, escherRecordFactory);
        offset += recordSize;
        this._blipRecords = new LinkedList<EscherRecord>();
        while (offset - startOffset < this._picf.getLcb() && ((nextRecord = escherRecordFactory.createRecord(dataStream, offset)).getRecordId() == -4089 || nextRecord.getRecordId() >= -4072 && nextRecord.getRecordId() <= -3817)) {
            int blipRecordSize = nextRecord.fillFields(dataStream, offset, escherRecordFactory);
            offset += blipRecordSize;
            this._blipRecords.add(nextRecord);
        }
    }

    public List<EscherRecord> getBlipRecords() {
        return this._blipRecords;
    }

    public PICF getPicf() {
        return this._picf;
    }

    public EscherContainerRecord getShape() {
        return this._shape;
    }

    public byte[] getStPicName() {
        return this._stPicName;
    }
}

