/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;

public class BitFlagHelper {
    private BitFlagHelper() {
    }

    public static final void setFlag(COSDictionary dic, String field, int bitFlag, boolean value) {
        BitFlagHelper.setFlag(dic, COSName.getPDFName(field), bitFlag, value);
    }

    public static final void setFlag(COSDictionary dic, COSName field, int bitFlag, boolean value) {
        int currentFlags = dic.getInt(field, 0);
        currentFlags = value ? (currentFlags |= bitFlag) : (currentFlags &= ~bitFlag);
        dic.setInt(field, currentFlags);
    }

    public static final boolean getFlag(COSDictionary dic, String field, int bitFlag) {
        return BitFlagHelper.getFlag(dic, COSName.getPDFName(field), bitFlag);
    }

    public static final boolean getFlag(COSDictionary dic, COSName field, int bitFlag) {
        int ff = dic.getInt(field, 0);
        return (ff & bitFlag) == bitFlag;
    }
}

