/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.common.function;

import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.PDRange;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;

public class PDFunctionType3
extends PDFunction {
    private COSArray functions = null;
    private COSArray encode = null;
    private COSArray bounds = null;

    public PDFunctionType3(COSBase functionStream) {
        super(functionStream);
    }

    public int getFunctionType() {
        return 3;
    }

    public float[] eval(float[] input) throws IOException {
        PDFunction function = null;
        float x = input[0];
        PDRange domain = this.getDomainForInput(0);
        x = this.clipToRange(x, domain.getMin(), domain.getMax());
        COSArray functionsArray = this.getFunctions();
        int numberOfFunctions = functionsArray.size();
        if (numberOfFunctions == 1) {
            function = PDFunction.create(functionsArray.get(0));
            PDRange encRange = this.getEncodeForParameter(0);
            x = this.interpolate(x, domain.getMin(), domain.getMax(), encRange.getMin(), encRange.getMax());
        } else {
            float[] boundsValues = this.getBounds().toFloatArray();
            int boundsSize = boundsValues.length;
            float[] partitionValues = new float[boundsSize + 2];
            int partitionValuesSize = partitionValues.length;
            partitionValues[0] = domain.getMin();
            partitionValues[partitionValuesSize - 1] = domain.getMax();
            System.arraycopy(boundsValues, 0, partitionValues, 1, boundsSize);
            for (int i = 0; i < partitionValuesSize - 1; ++i) {
                if (!(x >= partitionValues[i]) || !(x < partitionValues[i + 1]) && (i != partitionValuesSize - 2 || x != partitionValues[i + 1])) continue;
                function = PDFunction.create(functionsArray.get(i));
                PDRange encRange = this.getEncodeForParameter(i);
                x = this.interpolate(x, partitionValues[i], partitionValues[i + 1], encRange.getMin(), encRange.getMax());
                break;
            }
        }
        float[] functionValues = new float[]{x};
        float[] functionResult = function.eval(functionValues);
        return this.clipToRange(functionResult);
    }

    public COSArray getFunctions() {
        if (this.functions == null) {
            this.functions = (COSArray)this.getDictionary().getDictionaryObject(COSName.FUNCTIONS);
        }
        return this.functions;
    }

    public COSArray getBounds() {
        if (this.bounds == null) {
            this.bounds = (COSArray)this.getDictionary().getDictionaryObject(COSName.BOUNDS);
        }
        return this.bounds;
    }

    public COSArray getEncode() {
        if (this.encode == null) {
            this.encode = (COSArray)this.getDictionary().getDictionaryObject(COSName.ENCODE);
        }
        return this.encode;
    }

    private PDRange getEncodeForParameter(int n) {
        COSArray encodeValues = this.getEncode();
        return new PDRange(encodeValues, n);
    }
}

