/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.edit;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.COSStreamArray;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.color.PDPattern;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;
import org.apache.pdfbox.util.MapUtil;

public class PDPageContentStream {
    private PDPage page;
    private OutputStream output;
    private boolean inTextMode = false;
    private Map<PDFont, String> fontMappings = new HashMap<PDFont, String>();
    private Map<PDXObject, String> xobjectMappings = new HashMap<PDXObject, String>();
    private PDResources resources;
    private Map fonts;
    private Map xobjects;
    private PDColorSpace currentStrokingColorSpace = new PDDeviceGray();
    private PDColorSpace currentNonStrokingColorSpace = new PDDeviceGray();
    private float[] colorComponents = new float[4];
    private NumberFormat formatDecimal = NumberFormat.getNumberInstance(Locale.US);
    private static final String BEGIN_TEXT = "BT\n";
    private static final String END_TEXT = "ET\n";
    private static final String SET_FONT = "Tf\n";
    private static final String MOVE_TEXT_POSITION = "Td\n";
    private static final String SET_TEXT_MATRIX = "Tm\n";
    private static final String SHOW_TEXT = "Tj\n";
    private static final String SAVE_GRAPHICS_STATE = "q\n";
    private static final String RESTORE_GRAPHICS_STATE = "Q\n";
    private static final String CONCATENATE_MATRIX = "cm\n";
    private static final String XOBJECT_DO = "Do\n";
    private static final String RG_STROKING = "RG\n";
    private static final String RG_NON_STROKING = "rg\n";
    private static final String K_STROKING = "K\n";
    private static final String K_NON_STROKING = "k\n";
    private static final String G_STROKING = "G\n";
    private static final String G_NON_STROKING = "g\n";
    private static final String APPEND_RECTANGLE = "re\n";
    private static final String FILL = "f\n";
    private static final String LINE_TO = "l\n";
    private static final String MOVE_TO = "m\n";
    private static final String STROKE = "S\n";
    private static final String LINE_WIDTH = "w\n";
    private static final String SET_STROKING_COLORSPACE = "CS\n";
    private static final String SET_NON_STROKING_COLORSPACE = "cs\n";
    private static final String SET_STROKING_COLOR_SIMPLE = "SC\n";
    private static final String SET_STROKING_COLOR_COMPLEX = "SCN\n";
    private static final String SET_NON_STROKING_COLOR_SIMPLE = "sc\n";
    private static final String SET_NON_STROKING_COLOR_COMPLEX = "scn\n";
    private static final int SPACE = 32;

    public PDPageContentStream(PDDocument document, PDPage sourcePage) throws IOException {
        this(document, sourcePage, false, true);
    }

    public PDPageContentStream(PDDocument document, PDPage sourcePage, boolean appendContent, boolean compress) throws IOException {
        this.page = sourcePage;
        this.resources = this.page.getResources();
        if (this.resources == null) {
            this.resources = new PDResources();
            this.page.setResources(this.resources);
        }
        this.fonts = this.resources.getFonts();
        this.xobjects = this.resources.getImages();
        if (appendContent) {
            PDStream contents = sourcePage.getContents();
            PDStream contentsToAppend = new PDStream(document);
            COSStreamArray compoundStream = null;
            if (contents.getStream() instanceof COSStreamArray) {
                compoundStream = (COSStreamArray)contents.getStream();
                compoundStream.appendStream(contentsToAppend.getStream());
            } else {
                COSArray newArray = new COSArray();
                newArray.add(contents.getCOSObject());
                newArray.add(contentsToAppend.getCOSObject());
                compoundStream = new COSStreamArray(newArray);
            }
            if (compress) {
                ArrayList<COSName> filters = new ArrayList<COSName>();
                filters.add(COSName.FLATE_DECODE);
                contentsToAppend.setFilters(filters);
            }
            sourcePage.setContents(new PDStream(compoundStream));
            this.output = contentsToAppend.createOutputStream();
        } else {
            PDStream contents = new PDStream(document);
            if (compress) {
                ArrayList<COSName> filters = new ArrayList<COSName>();
                filters.add(COSName.FLATE_DECODE);
                contents.setFilters(filters);
            }
            sourcePage.setContents(contents);
            this.output = contents.createOutputStream();
        }
        this.formatDecimal.setMaximumFractionDigits(10);
        this.formatDecimal.setGroupingUsed(false);
    }

    public void beginText() throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: Nested beginText() calls are not allowed.");
        }
        this.appendRawCommands(BEGIN_TEXT);
        this.inTextMode = true;
    }

    public void endText() throws IOException {
        if (!this.inTextMode) {
            throw new IOException("Error: You must call beginText() before calling endText.");
        }
        this.appendRawCommands(END_TEXT);
        this.inTextMode = false;
    }

    public void setFont(PDFont font, float fontSize) throws IOException {
        String fontMapping = this.fontMappings.get(font);
        if (fontMapping == null) {
            fontMapping = MapUtil.getNextUniqueKey(this.fonts, "F");
            this.fontMappings.put(font, fontMapping);
            this.fonts.put(fontMapping, font);
        }
        this.appendRawCommands("/");
        this.appendRawCommands(fontMapping);
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(fontSize));
        this.appendRawCommands(32);
        this.appendRawCommands(SET_FONT);
    }

    public void drawImage(PDXObjectImage image, float x, float y) throws IOException {
        this.drawXObject(image, x, y, image.getWidth(), image.getHeight());
    }

    public void drawXObject(PDXObject xobject, float x, float y, float width, float height) throws IOException {
        String xObjectPrefix = null;
        xObjectPrefix = xobject instanceof PDXObjectImage ? "Im" : "Form";
        String objMapping = this.xobjectMappings.get(xobject);
        if (objMapping == null) {
            objMapping = MapUtil.getNextUniqueKey(this.xobjects, xObjectPrefix);
            this.xobjectMappings.put(xobject, objMapping);
            this.xobjects.put(objMapping, xobject);
        }
        this.appendRawCommands(SAVE_GRAPHICS_STATE);
        this.appendRawCommands(this.formatDecimal.format(width));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(0L));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(0L));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(height));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(x));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y));
        this.appendRawCommands(32);
        this.appendRawCommands(CONCATENATE_MATRIX);
        this.appendRawCommands(32);
        this.appendRawCommands("/");
        this.appendRawCommands(objMapping);
        this.appendRawCommands(32);
        this.appendRawCommands(XOBJECT_DO);
        this.appendRawCommands(32);
        this.appendRawCommands(RESTORE_GRAPHICS_STATE);
    }

    public void moveTextPositionByAmount(float x, float y) throws IOException {
        if (!this.inTextMode) {
            throw new IOException("Error: must call beginText() before moveTextPositionByAmount");
        }
        this.appendRawCommands(this.formatDecimal.format(x));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y));
        this.appendRawCommands(32);
        this.appendRawCommands(MOVE_TEXT_POSITION);
    }

    public void setTextMatrix(double a, double b, double c, double d, double e, double f) throws IOException {
        if (!this.inTextMode) {
            throw new IOException("Error: must call beginText() before setTextMatrix");
        }
        this.appendRawCommands(this.formatDecimal.format(a));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(b));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(c));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(d));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(e));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(f));
        this.appendRawCommands(32);
        this.appendRawCommands(SET_TEXT_MATRIX);
    }

    public void setTextScaling(double sx, double sy, double tx, double ty) throws IOException {
        this.setTextMatrix(sx, 0.0, 0.0, sy, tx, ty);
    }

    public void setTextTranslation(double tx, double ty) throws IOException {
        this.setTextMatrix(1.0, 0.0, 0.0, 1.0, tx, ty);
    }

    public void setTextRotation(double angle, double tx, double ty) throws IOException {
        double angleCos = Math.cos(angle);
        double angleSin = Math.sin(angle);
        this.setTextMatrix(angleCos, angleSin, -angleSin, angleCos, tx, ty);
    }

    public void drawString(String text) throws IOException {
        if (!this.inTextMode) {
            throw new IOException("Error: must call beginText() before drawString");
        }
        COSString string = new COSString(text);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        string.writePDF(buffer);
        this.appendRawCommands(new String(buffer.toByteArray(), "ISO-8859-1"));
        this.appendRawCommands(32);
        this.appendRawCommands(SHOW_TEXT);
    }

    public void setStrokingColorSpace(PDColorSpace colorSpace) throws IOException {
        this.currentStrokingColorSpace = colorSpace;
        this.writeColorSpace(colorSpace);
        this.appendRawCommands(SET_STROKING_COLORSPACE);
    }

    public void setNonStrokingColorSpace(PDColorSpace colorSpace) throws IOException {
        this.currentNonStrokingColorSpace = colorSpace;
        this.writeColorSpace(colorSpace);
        this.appendRawCommands(SET_NON_STROKING_COLORSPACE);
    }

    private void writeColorSpace(PDColorSpace colorSpace) throws IOException {
        COSName key = null;
        if (colorSpace instanceof PDDeviceGray || colorSpace instanceof PDDeviceRGB || colorSpace instanceof PDDeviceCMYK) {
            key = COSName.getPDFName(colorSpace.getName());
        } else {
            COSDictionary colorSpaces = (COSDictionary)this.resources.getCOSDictionary().getDictionaryObject(COSName.COLORSPACE);
            if (colorSpaces == null) {
                colorSpaces = new COSDictionary();
                this.resources.getCOSDictionary().setItem(COSName.COLORSPACE, (COSBase)colorSpaces);
            }
            if ((key = colorSpaces.getKeyForValue(colorSpace.getCOSObject())) == null) {
                int counter = 0;
                String csName = "CS";
                while (colorSpaces.containsValue(csName + counter)) {
                    ++counter;
                }
                key = COSName.getPDFName(csName + counter);
                colorSpaces.setItem(key, (COSObjectable)colorSpace);
            }
        }
        key.writePDF(this.output);
        this.appendRawCommands(32);
    }

    public void setStrokingColor(float[] components) throws IOException {
        for (int i = 0; i < components.length; ++i) {
            this.appendRawCommands(this.formatDecimal.format(components[i]));
            this.appendRawCommands(32);
        }
        if (this.currentStrokingColorSpace instanceof PDSeparation || this.currentStrokingColorSpace instanceof PDPattern || this.currentStrokingColorSpace instanceof PDDeviceN || this.currentStrokingColorSpace instanceof PDICCBased) {
            this.appendRawCommands(SET_STROKING_COLOR_COMPLEX);
        } else {
            this.appendRawCommands(SET_STROKING_COLOR_SIMPLE);
        }
    }

    public void setStrokingColor(Color color) throws IOException {
        ColorSpace colorSpace = color.getColorSpace();
        if (colorSpace.getType() == 5) {
            this.setStrokingColor(color.getRed(), color.getGreen(), color.getBlue());
        } else if (colorSpace.getType() == 6) {
            color.getColorComponents(this.colorComponents);
            this.setStrokingColor(this.colorComponents[0]);
        } else if (colorSpace.getType() == 9) {
            color.getColorComponents(this.colorComponents);
            this.setStrokingColor(this.colorComponents[0], this.colorComponents[2], this.colorComponents[2], this.colorComponents[3]);
        } else {
            throw new IOException("Error: unknown colorspace:" + colorSpace);
        }
    }

    public void setNonStrokingColor(Color color) throws IOException {
        ColorSpace colorSpace = color.getColorSpace();
        if (colorSpace.getType() == 5) {
            this.setNonStrokingColor(color.getRed(), color.getGreen(), color.getBlue());
        } else if (colorSpace.getType() == 6) {
            color.getColorComponents(this.colorComponents);
            this.setNonStrokingColor(this.colorComponents[0]);
        } else if (colorSpace.getType() == 9) {
            color.getColorComponents(this.colorComponents);
            this.setNonStrokingColor(this.colorComponents[0], this.colorComponents[2], this.colorComponents[2], this.colorComponents[3]);
        } else {
            throw new IOException("Error: unknown colorspace:" + colorSpace);
        }
    }

    public void setStrokingColor(int r, int g, int b) throws IOException {
        this.appendRawCommands(this.formatDecimal.format((double)r / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)g / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)b / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(RG_STROKING);
    }

    public void setStrokingColor(int c, int m, int y, int k) throws IOException {
        this.appendRawCommands(this.formatDecimal.format((double)c / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)m / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)y / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)k / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(K_STROKING);
    }

    public void setStrokingColor(double c, double m, double y, double k) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(c));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(m));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(k));
        this.appendRawCommands(32);
        this.appendRawCommands(K_STROKING);
    }

    public void setStrokingColor(int g) throws IOException {
        this.appendRawCommands(this.formatDecimal.format((double)g / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(G_STROKING);
    }

    public void setStrokingColor(double g) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(g));
        this.appendRawCommands(32);
        this.appendRawCommands(G_STROKING);
    }

    public void setNonStrokingColor(float[] components) throws IOException {
        for (int i = 0; i < components.length; ++i) {
            this.appendRawCommands(this.formatDecimal.format(components[i]));
            this.appendRawCommands(32);
        }
        if (this.currentNonStrokingColorSpace instanceof PDSeparation || this.currentNonStrokingColorSpace instanceof PDPattern || this.currentNonStrokingColorSpace instanceof PDDeviceN || this.currentNonStrokingColorSpace instanceof PDICCBased) {
            this.appendRawCommands(SET_NON_STROKING_COLOR_COMPLEX);
        } else {
            this.appendRawCommands(SET_NON_STROKING_COLOR_SIMPLE);
        }
    }

    public void setNonStrokingColor(int r, int g, int b) throws IOException {
        this.appendRawCommands(this.formatDecimal.format((double)r / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)g / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)b / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(RG_NON_STROKING);
    }

    public void setNonStrokingColor(int c, int m, int y, int k) throws IOException {
        this.appendRawCommands(this.formatDecimal.format((double)c / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)m / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)y / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format((double)k / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(K_NON_STROKING);
    }

    public void setNonStrokingColor(double c, double m, double y, double k) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(c));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(m));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(k));
        this.appendRawCommands(32);
        this.appendRawCommands(K_NON_STROKING);
    }

    public void setNonStrokingColor(int g) throws IOException {
        this.appendRawCommands(this.formatDecimal.format((double)g / 255.0));
        this.appendRawCommands(32);
        this.appendRawCommands(G_NON_STROKING);
    }

    public void setNonStrokingColor(double g) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(g));
        this.appendRawCommands(32);
        this.appendRawCommands(G_NON_STROKING);
    }

    public void fillRect(float x, float y, float width, float height) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(x));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(y));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(width));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(height));
        this.appendRawCommands(32);
        this.appendRawCommands(APPEND_RECTANGLE);
        this.appendRawCommands(FILL);
    }

    public void drawLine(float xStart, float yStart, float xEnd, float yEnd) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(xStart));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(yStart));
        this.appendRawCommands(32);
        this.appendRawCommands(MOVE_TO);
        this.appendRawCommands(this.formatDecimal.format(xEnd));
        this.appendRawCommands(32);
        this.appendRawCommands(this.formatDecimal.format(yEnd));
        this.appendRawCommands(32);
        this.appendRawCommands(LINE_TO);
        this.appendRawCommands(STROKE);
    }

    public void setLineWidth(float lineWidth) throws IOException {
        this.appendRawCommands(this.formatDecimal.format(lineWidth));
        this.appendRawCommands(32);
        this.appendRawCommands(LINE_WIDTH);
    }

    public void appendRawCommands(String commands) throws IOException {
        this.appendRawCommands(commands.getBytes("ISO-8859-1"));
    }

    public void appendRawCommands(byte[] commands) throws IOException {
        this.output.write(commands);
    }

    public void appendRawCommands(int data) throws IOException {
        this.output.write(data);
    }

    public void close() throws IOException {
        this.output.close();
    }
}

