use lib 'inc';
use Devel::AssertOS qw[Linux];
# This Makefile.PL for Database-Async-SQLite was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.38.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use 5.012000;
use ExtUtils::MakeMaker 6.48;

use ExtUtils::CppGuess;
print qx{cd sqlite_thread && make};

my %WriteMakefileArgs = (
  "ABSTRACT" => "SQLite support for IO::Async",
  "AUTHOR" => "Tom Molesworth <TEAM\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.48"
  },
  "DISTNAME" => "Database-Async-SQLite",
  "LICENSE" => "perl",
  "MIN_PERL_VERSION" => "5.012000",
  "NAME" => "Database::Async::SQLite",
  "PREREQ_PM" => {
    "ExtUtils::CppGuess" => 0,
    "parent" => 0
  },
  "TEST_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "File::Spec" => 0,
    "IO::Handle" => 0,
    "IPC::Open3" => 0,
    "Test::CheckDeps" => "0.010",
    "Test::More" => "0.94"
  },
  "VERSION" => "0.001",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

%WriteMakefileArgs = (
    %WriteMakefileArgs,
    ExtUtils::CppGuess->new(extra_compiler_flags => '-std=c++11 -Isqlite_thread', extra_linker_flags => '-Lsqlite_thread -lsqlite_thread -lsqlite3')->makemaker_options,
);

my %FallbackPrereqs = (
  "ExtUtils::CppGuess" => 0,
  "ExtUtils::MakeMaker" => 0,
  "File::Spec" => 0,
  "IO::Handle" => 0,
  "IPC::Open3" => 0,
  "Test::CheckDeps" => "0.010",
  "Test::More" => "0.94",
  "parent" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
