/*
 * Decompiled with CFR 0.152.
 */
package thredds.filesystem;

import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import thredds.filesystem.FileSystemProto;

public class CacheFileProto
implements Externalizable {
    public static int countRead = 0;
    public static int countReadSize = 0;
    public static int countWrite = 0;
    public static int countWriteSize = 0;
    private static final long serialVersionUID = 7526472295622776147L;
    protected String shortName;
    protected long lastModified;
    protected long length;
    protected boolean isDirectory;
    private HashMap<String, Object> att;

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public void setDirectory(boolean directory) {
        this.isDirectory = directory;
    }

    public String getShortName() {
        return this.shortName;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public long getLength() {
        return this.length;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public void setAttribute(String key, Object value) {
        if (this.att == null) {
            this.att = new HashMap(5);
        }
        this.att.put(key, value);
    }

    public Object getAttribute(String key) {
        if (this.att == null) {
            return null;
        }
        return this.att.get(key);
    }

    public String toString() {
        return "CacheFile{shortName='" + this.shortName + '\'' + ", lastModified=" + this.lastModified + ", length=" + this.length + ", isDirectory=" + this.isDirectory + ", att=" + this.att + '}';
    }

    public CacheFileProto(File f) {
        this.shortName = f.getName();
        this.lastModified = f.lastModified();
        this.length = f.length();
        this.isDirectory = f.isDirectory();
    }

    public CacheFileProto() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        FileSystemProto.File.Builder fileBuilder = FileSystemProto.File.newBuilder();
        fileBuilder.setName(this.getShortName());
        fileBuilder.setIsDirectory(this.isDirectory());
        fileBuilder.setLastModified(this.getLastModified());
        fileBuilder.setLength(this.getLength());
        FileSystemProto.File fileProto = fileBuilder.build();
        byte[] b = fileProto.toByteArray();
        out.writeInt(b.length);
        out.write(b);
        ++countWrite;
        countWriteSize += b.length + 4;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int got;
        int len = in.readInt();
        byte[] b = new byte[len];
        for (int done = 0; done < len; done += got) {
            got = in.read(b, done, len - done);
            if (got >= 0) continue;
            throw new IOException();
        }
        FileSystemProto.File proto = FileSystemProto.File.parseFrom(b);
        this.shortName = proto.getName();
        this.lastModified = proto.getLastModified();
        this.length = proto.getLength();
        this.isDirectory = proto.getIsDirectory();
        ++countRead;
        countReadSize += len + 4;
    }
}

