# Generated by default/object.tt
package Paws::DS::RegionDescription;
  use Moose;
  has DesiredNumberOfDomainControllers => (is => 'ro', isa => 'Int');
  has DirectoryId => (is => 'ro', isa => 'Str');
  has LastUpdatedDateTime => (is => 'ro', isa => 'Str');
  has LaunchTime => (is => 'ro', isa => 'Str');
  has RegionName => (is => 'ro', isa => 'Str');
  has RegionType => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');
  has StatusLastUpdatedDateTime => (is => 'ro', isa => 'Str');
  has VpcSettings => (is => 'ro', isa => 'Paws::DS::DirectoryVpcSettings');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DS::RegionDescription

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DS::RegionDescription object:

  $service_obj->Method(Att1 => { DesiredNumberOfDomainControllers => $value, ..., VpcSettings => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DS::RegionDescription object:

  $result = $service_obj->Method(...);
  $result->Att1->DesiredNumberOfDomainControllers

=head1 DESCRIPTION

The replicated Region information for a directory.

=head1 ATTRIBUTES


=head2 DesiredNumberOfDomainControllers => Int

The desired number of domain controllers in the specified Region for
the specified directory.


=head2 DirectoryId => Str

The identifier of the directory.


=head2 LastUpdatedDateTime => Str

The date and time that the Region description was last updated.


=head2 LaunchTime => Str

Specifies when the Region replication began.


=head2 RegionName => Str

The name of the Region. For example, C<us-east-1>.


=head2 RegionType => Str

Specifies whether the Region is the primary Region or an additional
Region.


=head2 Status => Str

The status of the replication process for the specified Region.


=head2 StatusLastUpdatedDateTime => Str

The date and time that the Region status was last updated.


=head2 VpcSettings => L<Paws::DS::DirectoryVpcSettings>





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

