# Generated by default/object.tt
package Paws::CodeBuild::ProjectBuildBatchConfig;
  use Moose;
  has CombineArtifacts => (is => 'ro', isa => 'Bool', request_name => 'combineArtifacts', traits => ['NameInRequest']);
  has Restrictions => (is => 'ro', isa => 'Paws::CodeBuild::BatchRestrictions', request_name => 'restrictions', traits => ['NameInRequest']);
  has ServiceRole => (is => 'ro', isa => 'Str', request_name => 'serviceRole', traits => ['NameInRequest']);
  has TimeoutInMins => (is => 'ro', isa => 'Int', request_name => 'timeoutInMins', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeBuild::ProjectBuildBatchConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeBuild::ProjectBuildBatchConfig object:

  $service_obj->Method(Att1 => { CombineArtifacts => $value, ..., TimeoutInMins => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeBuild::ProjectBuildBatchConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->CombineArtifacts

=head1 DESCRIPTION

Contains configuration information about a batch build project.

=head1 ATTRIBUTES


=head2 CombineArtifacts => Bool

Specifies if the build artifacts for the batch build should be combined
into a single artifact location.


=head2 Restrictions => L<Paws::CodeBuild::BatchRestrictions>

A C<BatchRestrictions> object that specifies the restrictions for the
batch build.


=head2 ServiceRole => Str

Specifies the service role ARN for the batch build project.


=head2 TimeoutInMins => Int

Specifies the maximum amount of time, in minutes, that the batch build
must be completed in.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeBuild>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

