# Generated by default/object.tt
package Paws::CodeBuild::BuildStatusConfig;
  use Moose;
  has Context => (is => 'ro', isa => 'Str', request_name => 'context', traits => ['NameInRequest']);
  has TargetUrl => (is => 'ro', isa => 'Str', request_name => 'targetUrl', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeBuild::BuildStatusConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeBuild::BuildStatusConfig object:

  $service_obj->Method(Att1 => { Context => $value, ..., TargetUrl => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeBuild::BuildStatusConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->Context

=head1 DESCRIPTION

Contains information that defines how the CodeBuild build project
reports the build status to the source provider.

=head1 ATTRIBUTES


=head2 Context => Str

Specifies the context of the build status CodeBuild sends to the source
provider. The usage of this parameter depends on the source provider.

=over

=item Bitbucket

This parameter is used for the C<name> parameter in the Bitbucket
commit status. For more information, see build
(https://developer.atlassian.com/bitbucket/api/2/reference/resource/repositories/%7Bworkspace%7D/%7Brepo_slug%7D/commit/%7Bnode%7D/statuses/build)
in the Bitbucket API documentation.

=item GitHub/GitHub Enterprise Server

This parameter is used for the C<context> parameter in the GitHub
commit status. For more information, see Create a commit status
(https://developer.github.com/v3/repos/statuses/#create-a-commit-status)
in the GitHub developer guide.

=back



=head2 TargetUrl => Str

Specifies the target url of the build status CodeBuild sends to the
source provider. The usage of this parameter depends on the source
provider.

=over

=item Bitbucket

This parameter is used for the C<url> parameter in the Bitbucket commit
status. For more information, see build
(https://developer.atlassian.com/bitbucket/api/2/reference/resource/repositories/%7Bworkspace%7D/%7Brepo_slug%7D/commit/%7Bnode%7D/statuses/build)
in the Bitbucket API documentation.

=item GitHub/GitHub Enterprise Server

This parameter is used for the C<target_url> parameter in the GitHub
commit status. For more information, see Create a commit status
(https://developer.github.com/v3/repos/statuses/#create-a-commit-status)
in the GitHub developer guide.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeBuild>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

