### base class of several features of the one pass algorithm

use 'GFX::Tools::Buffer::toolsarray';

sub new {
    my $class = shift;

    ### 1. this class contains only a sequence of functors that gets 
    ### executed by exec below using a toolsarray iterator (see below)
    $self = { functors => toolsarray->new, };
    
    bless $self, $class;
}

### functor is a OnePassFunctor
sub addFunctor {
    my ($self, $f) = @_;

    $self->{functors}->add($f);

    ### return last index
    return len($self->{functors}->len - 1); ### FIXME 
}

sub indexFunctor {
    my ($self, $index) = @_;

    return $self->{functors}->indexOf($index);
}

### iterates over functors and executes them in the list order
sub exec {
    my ($self, $args) = @_;
 
    my $iter = toolsarray->new($self->{functors});

    while ($iter->hasNext) {

	my $res = $iter->next->do($args);
	$iter->current->setResult($res);

    }
    
    return 0;
}

1;
