use strict;
use warnings;
use Test::More tests => 68;
use Digest::SHAvite3 qw(shavite3_512 shavite3_512_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::SHAvite3->new(512)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            shavite3_512_hex($data), $digest,
            "shavite3_512_hex: $len bits of $msg"
        );
        ok(
            shavite3_512($data) eq pack('H*', $digest),
            "shavite3_512: $len bits of $msg"
        );
    }

    my $md = Digest::SHAvite3->new(512)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

__DATA__
00|A485C1B2578459D1EFC5DDDD840BB0B4A650AC82FE68F58C4442CCDA747DA006B2D1DC6B4A4EB7D84FF91E1F466FEF429D259ACD995DDDCAD16FA545C7A6E5BA
00|8A62A4B114E19389347E5B8B433869135CD3B035FBF6E53E481DE53878AC2EE1B476CA589B1161280D1B953E9DBC7822670A426AD84FFAA6E442046D213D94D8
C0|6D76074312032C21E6AAE84D48A193F17BA09CF8AF22934140BCC4C5320EE008E976C5C0A50BDCBC659C96DE488C1E3B7C4592BC01D06769A15B8FE48C03CD70
C0|C95E980B3BA6C2C6124BC6DDAA58D6187515480DF61F9F72842E7F39061B9CE8C11D55EC813421402169A770B686E2E5F7A23B897022D008FBFB56B5233B9B05
80|DD6561D99829C32F10548ED525F82DF7182F78586108E184C3679BDD465E6C95DC522F030888F911A05A28E8EF1BB0CE74D28DF31D1D44829D8E80EB5F117EC5
48|F8DFD4C8DFA2E55315C6FA5E3E89B48818A4625AAB310CD9B24E4F0AE53EEC532C267725CEED44B67C83DBFDCD1816AC6F1BA6885FF2BE25B39F118A2A0F270E
50|02CA5BD4580FF0E12F067B262CD25076F7E422CF5DE344DF630677C673D3D0B4A8522565AC8A9CDCC713358727189A5A1F9DAE3E0AE203F9194520952D49D22C
98|9EF28389B3CD8DFF208251969370022D743C633BF53BE5A0342E80CC014BF420ECD447B0A45018F56CB36AE9AFC86044032D7814CDC006F69B63B73CEA30C867
CC|3FE519289541F0EC62F2247B55844F9DFCE6D008C9062E4AE2821A0DD9E47B7E37E9B859E1B2D0E0CF1090C68223034C94314A190B92BF71F3810EE32B2732E6
9800|FECA0186053A2F72ADBC449C371AC742EF61C0AD94F88BEA93D11E0731B850A561AB1588CAA7B0748E760FA6F6EE00C36360CDF01736658B28CE83D07B778712
9D40|E4E6FF38AE76AB4F7869DF062BE303E85320A486B03EDB7CB65DD896A4D624C830475B9C81A9C338353F1FC09EB1F76DD06C3CFC35C5E770A1AC20C50377BA02
AA80|29A2286EA779697C7B3A68355380BD52747C4BC957D877CB9BA039CA12EDDCB3A5A7AECCF46AF1B0783F3F16E7D2B4572CDB8EA0D2A74C79B727131A9B1BFCF7
9830|26DCED3D540C15DE12BFFA3122CD5A44483E027013C43F53CDCC04A006731ECA357E8070B8DEC4B0401F32ED2F120B89717F4F6ECA30D497874C29CB5870808E
5030|A72AAAEA004DB60F44AD1BD80B55028B82F2A29A501C9002572FDFB0CB53B8E6964313D9E55E5A1BC0851542C36074115396EDD26D015C12EEB9F5DB0C1E4F48
4D24|27799E1E4868B9FC97C6D40A5F916A6DE3555EEC8E3B2CEE73485807C934D566A0766603DD0D6C2FD22A5CF5A3161B678C6CB47E8DADC099C8D90AA48CC61E62
CBDE|065CEB087E93B31C0BB25581ABD1F1998FCE13320CB5C1D492B7052AB54FBFB5572BA5C8D417030693CEEC7F9571E3A352A702C9A23697CF2687AE7C5C23A77D
41FB|8DEF5B88BC6D60DA48F14E88EF66DDE72AD2DFFFA51FE5AB2A165598B2B4698C46BEDC79F4F147BB033E9EC8FD2697596DB4329B9C524885B313559BBE2F8E7F
4FF400|7CD9CEE92180B70939861BC9FA073F6740C9BE24A447443D9CA4EC53B5E10E9C922FA843EF357DF4658A668BCEC90B1FAC1CD8EB1F5E5BCEEF5185AB5302783C
FD0440|176459A01A4E2E2CC07DF20E734B523D840121679432267E10BCB1412E5C426D558889332D78692D9651DB18E6BFDCC8B1DC28516C4C8EF30DA9ACD9DA60100D
424D00|7CFEDF55DE94E73ABA229C6832753138D243F61A961314E2B0B59B421B0BC48C629A2068F2F53F6BC4F9ECCF30743FCEA0CE9626BF3A209234BFC54DEE96463A
3FDEE0|39594F5DE1090A493C4E17D41D22DD9FAD521B14A46335AAA096AD68002E81F60AE7FC41F3617BAEDD4E8B5CD362AC60650E5EE04A8B30AD52A2D5AE5B5B70CB
335768|62ED583EFDEABEBF282D0B70DF7803EA10B48E60D013936643944C73D270B996351477190C72663614E0C1C1A7010522FF157CFC1DFBFB4FEB939CA78A1305BD
051E7C|F75B4F57FD846D3D01D61172F2962FD76B19EBFE4A7831D45738CE6D6A34EE57B9F4E7B7BFBFFDE44F5CCE91B26379D5774EC657A4487B6401D21CE89F5FBD09
717F8C|7B686DC99B975DFDB370DB793B255C8E40F53C1020B5C4D2C7565CB8962911761F07A4851078FC4ED49EC38E52AA85448FEB262A19FDF732839CD890D4840AF0
1F877C|EEA90031F7E5954F8D65A58480DD29E7014E03BBE24FEFA9B0F3DD37A3E6F9A1CF4803584C0E19155732C100EECF3F035E00F7DEBEC7F90CE386A9ECD363C3F6
EB35CF80|5E3A349291958263E3C9DD4218366B69ADDBD84D96AE7367536BE962D6F5F8AB9968FEE360CEC8CE37F07F854BCCD0577119F5069F55560DC226A618715CF34D
B406C480|8B18B0DBE3C09BEEDCFF9BE7235A45DC81ADEED39A53FDE4A9104B14DE8BB0D5493E8D719802D3AC9BC3D5669AC814C21A1B6CE69E76A7B597FE8ABEFDDF7D0C
CEE88040|73C391FC395D06830FF49C9BC5B235BD4CBFCF6B04C0B91A16544D397F1081BDEEBA2950D2AA809B03092E3F702F12FB4B706A13EA81C2CC22425C2F3FD09FE9
C584DB70|8D0D667D21202662DDBB1756F3DEB456F451E3C447AF25C508BB8CDAD026B492B20745FA9B72BCA00D73ED676B8CC7FBD978C50169E74A36B2EA4CC5CA3EA003
53587BC8|4C666426ABA39B072AA90D033466B9A30EBAC709C826240623558B50F9442B6F9CF6E7917EEAB46D1EB3B50A79B7454CBBCD734D45849F814486A7143614D5DF
69A305B0|F3F6D7D53F2E954EE9EEDF1C04F75C29EE68F993E6F3D420D963E546A4A0082F6872C07A2EC54C9E6258CF8A79B2AB317718F7B35957EE5F0D98808069D010AA
C9375ECE|AD53F0ACECB688168DF6297D9926B8485000C546CCAF75D3D7E31D8967B3F9AC9960E852150B017ED18E1EE3920C4BA6E119F8751A26C21E46BB1B1C1E254CAC
C1ECFDFC|DCFD5938D89F88EBAFF8D724E59FFC9144B565CF42678773FEB3756A5A756AC52E53402A676E20D526D4513E8251DC7413B760B31563F4F206B6578AB9E118B9
8D73E8A280|90B21C047233A8FF1AD0DEA6B370760E892725DB607AA83F17F1D4E5F797F7BAA575090CB58DDE5FDACB473E490F20EBFFEE044AEA028D10EBB147CCC86A712D
06F2522080|5B62ADB9A1A577BEE0C770D88DF8135AB238A7156EBF8297A34F2B11A9BFE38C6BBC4A2339FA9B29556728EA28ED88D6DDCF97D177AA4247F9B8709E998FDF4F
3EF6C36F20|9376E8ADBFADAC9CA69FB784595DE1385E7389BA00C8AA983AFB8C5C3725FD2F8DE06D570DF3144B162FD51E08488AF3D02607AC74F19E12616A12CAD03EA9BC
0127A1D340|B628A025E08BE22C709F65F6288606F6CF05370ECEE8BA70E048C8A58E1F5565956C5EFBD076BAF8BDA92ED3CE4F9C26844508AE541B038037AA98B135BD817A
6A6AB6C210|FD8F4BB337C30E1DEB2EC157EBC9F6692E95CF64FD46DCFD10E8578A4429DC51E76F8F418178A3700FA75DF0EC5F11F70C9821A86A8080F3A00BBA0D701A7C81
AF3175E160|CF6A7318365B0A7D5B75638189B506B7C3E65479BA6AA5B7E7E70EC041B356F220BC46CFF2BD6D8F6994A5A15414C8726BEE73CAEBD1599A5BA91CAEA6677595
B66609ED86|5C7FF9DC37849E139C574CD5F73BC4D9E88F358EDCA7BF33C576FEA6EB7EE42198773A5588EC54D78748CCEA3909474CEB55C34E14A390A22ED8565D4DEF4BC9
21F134AC57|4087D632E2424E6A0197B1594A7DFAA60964B699E4CC6AC36E6F969FC851F8879BE24B2994FC4770EF60B6F074AB8D6305A06570F8D2808B1AE9248F73C3580D
3DC2AADFFC80|D2D394179100D8F10CF0F801FB97BED88C94DADA844DC54C94726959F6CC0E7D7126F3257DF40712F3027FB64F162A9460EF350A308A8E1C41E303AAE9D3A9FC
9202736D2240|1B7B63B38631E4712F5C0B7FC9BD6D38594F92994DF4B177DF1DEC05F4297021E7423CBBFDD66F2A7913C8F52C5827AC506B6727F191220AC318010527B3DA17
F219BD629820|7FA7CC6B4D4034F57C701F37A6812B26292FD1B20A5F7804A7B41579D0BFE8E6DDF32149DA2B5F2132F5EC7B1FF7140C6F4F61EF2462F320D5EF93A9B643FE12
F3511EE2C4B0|4D80FD078BFE535F431D95B0918907928FC1146A82325F8E293719AFE1FD89EEBCBA753B71E6217F9BAA4F6E65CFD5FB965037EFFF95E18BBBC0C0ABC21F6100
3ECAB6BF7720|89DC1CCD54690891D5E3A56B7E7D3B31B9F4AB4307A0D3E2F38905E39E3445A2BD44315F32C9C3B8DB08D63FC12581C42A45F56E1E8EBFFBF10C90DBCBCF639D
CD62F688F498|08BC8ED916BB8DA87FF62A198B291E7F6EB689A79794743F931254139753D704B49C604390E595964094F27A2E5CDABD2F2FB9933964BA915B03DA8530C1ADD5
C2CBAA33A9F8|F60C08D4E42D331120A27F8339F1F5E7AABD5295449F2098CF7502AD5FEFE8D8A1ED846BD59E7F12A0A93B0F49895529F04BFA150180BBFF1325ADD0AF96937B
C6F50BB74E29|3075666E1FEB7925459EC558AC433F9527B4C0AF2A0A9F61B650DC96C02BB7B0C6F64175EDB9A6D2639AA9A38E80002C42138468634395ADFD789784FEEA88B6
79F1B4CCC62A00|DCCA9BDC5EE0E49B36B340ABEB2B17801B4ED9343D9C11D1842CFD78C01F2C9EA4C5006C8EB3A83ADE8EA0C492330E12BCEF1FA0338BBABF3426622E280E9D12
