use Test::More tests => 5;
use Test::LeakTrace;
use B::Hooks::OP::Check::LeaveEval;

no_leaks_ok {
    my $id = B::Hooks::OP::Check::LeaveEval::register(sub { 1 });
    B::Hooks::OP::Check::LeaveEval::unregister($id);
} 'inline anonymous sub';

no_leaks_ok {
    my $callback = sub { 1 };
    my $id = B::Hooks::OP::Check::LeaveEval::register($callback);
    B::Hooks::OP::Check::LeaveEval::unregister($id);
} 'sub contained in a variable';

no_leaks_ok {
    my $id = B::Hooks::OP::Check::LeaveEval::register(\&do_something);
    B::Hooks::OP::Check::LeaveEval::unregister($id);
} 'reference to a declared sub';

no_leaks_ok {
    my $id = B::Hooks::OP::Check::LeaveEval::register(_gen_callback());
    B::Hooks::OP::Check::LeaveEval::unregister($id);
} 'subref returned froma another sub';

no_leaks_ok {
    my $id = B::Hooks::OP::Check::LeaveEval::register(eval 'sub { 1 }');
    B::Hooks::OP::Check::LeaveEval::unregister($id);
} 'subref generated by eval';

sub do_something { 1 }

sub _gen_callback {
    return sub { 1 };
}
