/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.impl.LongString;
import com.rabbitmq.client.impl.ValueReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodArgumentReader {
    private final ValueReader in;
    private int bits;
    private int bit;

    private void clearBits() {
        this.bits = 0;
        this.bit = 256;
    }

    public MethodArgumentReader(DataInputStream in) {
        this.in = new ValueReader(in);
        this.clearBits();
    }

    public final String readShortstr() throws IOException {
        this.clearBits();
        return this.in.readShortstr();
    }

    public final LongString readLongstr() throws IOException {
        this.clearBits();
        return this.in.readLongstr();
    }

    public final int readShort() throws IOException {
        this.clearBits();
        return this.in.readShort();
    }

    public final int readLong() throws IOException {
        this.clearBits();
        return this.in.readLong();
    }

    public final long readLonglong() throws IOException {
        this.clearBits();
        return this.in.readLonglong();
    }

    public final boolean readBit() throws IOException {
        if (this.bit > 128) {
            this.bits = this.in.readOctet();
            this.bit = 1;
        }
        boolean result = (this.bits & this.bit) != 0;
        this.bit <<= 1;
        return result;
    }

    public final Map<String, Object> readTable() throws IOException {
        this.clearBits();
        return this.in.readTable();
    }

    public final int readOctet() throws IOException {
        this.clearBits();
        return this.in.readOctet();
    }

    public final Date readTimestamp() throws IOException {
        this.clearBits();
        return this.in.readTimestamp();
    }
}

